package org.eclipse.xtext.xtext.ui.wizard.ecore2xtext;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.EPackageInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Ecore2XtextExtensions;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Ecore2XtextProjectInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.UniqueNameUtil;

/**
 * Originally written with M2T Xpand. (Ecore2Xtext.xpt)<br>
 * Translated to Tools Xtend 1:1 where possible.<br>
 * @author Dennis Huebner - Initial contribution and API
 * @since 2.3
 */
@SuppressWarnings("all")
public class Ecore2XtextGrammarCreator {
  public CharSequence grammar(final Ecore2XtextProjectInfo it) {
    CharSequence _xblockexpression = null;
    {
      EPackageInfo _defaultEPackageInfo = it.getDefaultEPackageInfo();
      UniqueNameUtil.clearUniqueNames(_defaultEPackageInfo);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("// automatically generated by Xtext");
      _builder.newLine();
      _builder.append("grammar ");
      String _languageName = it.getLanguageName();
      _builder.append(_languageName, "");
      _builder.append(" with org.eclipse.xtext.common.Terminals");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        Collection<EPackage> _allReferencedEPackages = Ecore2XtextExtensions.allReferencedEPackages(it);
        for(final EPackage it_1 : _allReferencedEPackages) {
          _builder.append("import \"");
          String _nsURI = it_1.getNsURI();
          _builder.append(_nsURI, "");
          _builder.append("\" ");
          {
            boolean _and = false;
            String _uniqueName = UniqueNameUtil.uniqueName(it_1);
            boolean _notEquals = (!Objects.equal(_uniqueName, null));
            if (!_notEquals) {
              _and = false;
            } else {
              String _uniqueName_1 = UniqueNameUtil.uniqueName(it_1);
              boolean _notEquals_1 = (!Objects.equal(_uniqueName_1, ""));
              _and = _notEquals_1;
            }
            if (_and) {
              _builder.append("as ");
              String _uniqueName_2 = UniqueNameUtil.uniqueName(it_1);
              _builder.append(_uniqueName_2, "");
            }
          }
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      EClass _rootElementClass = it.getRootElementClass();
      CharSequence _rules = this.rules(_rootElementClass);
      _builder.append(_rules, "");
      _builder.newLineIfNotEmpty();
      {
        Collection<EClass> _allDispatcherRuleClasses = Ecore2XtextExtensions.allDispatcherRuleClasses(it);
        EClass _rootElementClass_1 = it.getRootElementClass();
        List<EClass> _but = this.<EClass>but(_allDispatcherRuleClasses, _rootElementClass_1);
        for(final EClass it_2 : _but) {
          _builder.newLine();
          CharSequence _subClassDispatcherRule = this.subClassDispatcherRule(it_2);
          _builder.append(_subClassDispatcherRule, "");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        Iterable<EClassifier> _allConcreteRuleClassifiers = Ecore2XtextExtensions.allConcreteRuleClassifiers(it);
        EClass _rootElementClass_2 = it.getRootElementClass();
        List<EClassifier> _but_1 = this.<EClassifier>but(_allConcreteRuleClassifiers, _rootElementClass_2);
        for(final EClassifier it_3 : _but_1) {
          _builder.newLine();
          CharSequence _rule = this.rule(it_3);
          _builder.append(_rule, "");
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = (_builder);
    }
    return _xblockexpression;
  }
  
  public <T extends EClassifier> List<T> but(final Iterable<T> classes, final EClassifier it) {
    final List<T> retVal = IterableExtensions.<T>toList(classes);
    retVal.remove(it);
    return retVal;
  }
  
  public CharSequence subClassDispatcherRule(final EClass it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _needsDispatcherRule = Ecore2XtextExtensions.needsDispatcherRule(it);
      if (_needsDispatcherRule) {
        String _uniqueName = UniqueNameUtil.uniqueName(it);
        _builder.append(_uniqueName, "");
        _builder.append(" returns ");
        String _fqn = Ecore2XtextExtensions.fqn(it);
        _builder.append(_fqn, "");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _subClassAlternatives = this.subClassAlternatives(it);
        _builder.append(_subClassAlternatives, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public String subClassAlternatives(final EClass eClazz) {
    String _xblockexpression = null;
    {
      ArrayList<EClass> _newArrayList = CollectionLiterals.<EClass>newArrayList(eClazz);
      Iterable<EClass> _subClasses = Ecore2XtextExtensions.subClasses(eClazz);
      Iterable<EClass> list = Iterables.<EClass>concat(_newArrayList, _subClasses);
      final Function1<EClass,Boolean> _function = new Function1<EClass,Boolean>() {
        public Boolean apply(final EClass c) {
          return Boolean.valueOf(Ecore2XtextExtensions.needsConcreteRule(c));
        }
      };
      Iterable<EClass> _filter = IterableExtensions.<EClass>filter(list, _function);
      list = _filter;
      final Function1<EClass,String> _function_1 = new Function1<EClass,String>() {
        public String apply(final EClass it) {
          return Ecore2XtextExtensions.concreteRuleName(it);
        }
      };
      Iterable<String> _map = IterableExtensions.<EClass, String>map(list, _function_1);
      _xblockexpression = (IterableExtensions.join(_map, " | "));
    }
    return _xblockexpression;
  }
  
  public CharSequence idAssignment(final EClass it) {
    CharSequence _xblockexpression = null;
    {
      final EAttribute idAttr = Ecore2XtextExtensions.idAttribute(it);
      CharSequence _xifexpression = null;
      boolean _notEquals = (!Objects.equal(idAttr, null));
      if (_notEquals) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = idAttr.getName();
        _builder.append(_name, "");
        _builder.append("=");
        String _assignedRuleCall = Ecore2XtextExtensions.assignedRuleCall(idAttr);
        _builder.append(_assignedRuleCall, "");
        _xifexpression = _builder;
      }
      _xblockexpression = (_xifexpression);
    }
    return _xblockexpression;
  }
  
  public CharSequence assigment(final EStructuralFeature it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isRequired = it.isRequired();
      boolean _not = (!_isRequired);
      if (_not) {
        _builder.append("(");
      }
    }
    String _assignmentKeyword = Ecore2XtextExtensions.assignmentKeyword(it);
    _builder.append(_assignmentKeyword, "");
    {
      boolean _isMany = it.isMany();
      if (_isMany) {
        {
          boolean _isContainment = Ecore2XtextExtensions.isContainment(it);
          if (_isContainment) {
            _builder.append("\'{\' ");
          } else {
            _builder.append("\'(\' ");
          }
        }
      }
    }
    String _name = it.getName();
    String _quoteIfNeccesary = Ecore2XtextExtensions.quoteIfNeccesary(_name);
    _builder.append(_quoteIfNeccesary, "");
    CharSequence _assignmentOperator = this.assignmentOperator(it);
    _builder.append(_assignmentOperator, "");
    CharSequence _assignedTerminal = this.assignedTerminal(it);
    _builder.append(_assignedTerminal, "");
    {
      boolean _isMany_1 = it.isMany();
      if (_isMany_1) {
        _builder.append(" ( \",\" ");
        String _name_1 = it.getName();
        String _quoteIfNeccesary_1 = Ecore2XtextExtensions.quoteIfNeccesary(_name_1);
        _builder.append(_quoteIfNeccesary_1, "");
        CharSequence _assignmentOperator_1 = this.assignmentOperator(it);
        _builder.append(_assignmentOperator_1, "");
        CharSequence _assignedTerminal_1 = this.assignedTerminal(it);
        _builder.append(_assignedTerminal_1, "");
        _builder.append(")* ");
        {
          boolean _isContainment_1 = Ecore2XtextExtensions.isContainment(it);
          if (_isContainment_1) {
            _builder.append("\'}\' ");
          } else {
            _builder.append("\')\' ");
          }
        }
      }
    }
    {
      boolean _isRequired_1 = it.isRequired();
      boolean _not_1 = (!_isRequired_1);
      if (_not_1) {
        _builder.append(")?");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence assignedTerminal(final EStructuralFeature it) {
    CharSequence _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (it instanceof EAttribute) {
        _matched=true;
        _switchResult = Ecore2XtextExtensions.assignedRuleCall(((EAttribute)it));
      }
    }
    if (!_matched) {
      if (it instanceof EReference) {
        _matched=true;
        CharSequence _xifexpression = null;
        boolean _isContainment = ((EReference)it).isContainment();
        if (_isContainment) {
          EClass _eReferenceType = ((EReference)it).getEReferenceType();
          _xifexpression = UniqueNameUtil.uniqueName(_eReferenceType);
        } else {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("[");
          EClass _eReferenceType_1 = ((EReference)it).getEReferenceType();
          String _fqn = Ecore2XtextExtensions.fqn(_eReferenceType_1);
          _builder.append(_fqn, "");
          _builder.append("|EString]");
          _xifexpression = _builder;
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      StringConcatenation _builder = new StringConcatenation();
      _switchResult = _builder;
    }
    return _switchResult;
  }
  
  public CharSequence assignmentOperator(final EStructuralFeature it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isMany = it.isMany();
      if (_isMany) {
        _builder.append("+=");
      } else {
        boolean _and = false;
        EClassifier _eType = it.getEType();
        boolean _isBoolean = Ecore2XtextExtensions.isBoolean(_eType);
        if (!_isBoolean) {
          _and = false;
        } else {
          boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature(it);
          _and = _isPrefixBooleanFeature;
        }
        if (_and) {
          _builder.append("?=");
        } else {
          _builder.append("=");
        }
      }
    }
    return _builder;
  }
  
  public CharSequence rules(final EClassifier it) {
    CharSequence _xifexpression = null;
    boolean _and = false;
    boolean _notEquals = (!Objects.equal(it, null));
    if (!_notEquals) {
      _and = false;
    } else {
      boolean _needsConcreteRule = Ecore2XtextExtensions.needsConcreteRule(it);
      _and = _needsConcreteRule;
    }
    if (_and) {
      _xifexpression = this.rule(it);
    }
    return _xifexpression;
  }
  
  public CharSequence rule(final EClassifier it) {
    CharSequence _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (it instanceof EClass) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        String _concreteRuleName = Ecore2XtextExtensions.concreteRuleName(((EClass)it));
        _builder.append(_concreteRuleName, "");
        _builder.append(" returns ");
        String _fqn = Ecore2XtextExtensions.fqn(it);
        _builder.append(_fqn, "");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        {
          boolean _onlyOptionalFeatures = Ecore2XtextExtensions.onlyOptionalFeatures(((EClass)it));
          if (_onlyOptionalFeatures) {
            _builder.append("\t");
            _builder.append("{");
            String _fqn_1 = Ecore2XtextExtensions.fqn(it);
            _builder.append(_fqn_1, "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          Iterable<EStructuralFeature> _prefixFeatures = Ecore2XtextExtensions.prefixFeatures(((EClass)it));
          for(final EStructuralFeature strF : _prefixFeatures) {
            _builder.append("\t");
            CharSequence _assigment = this.assigment(strF);
            _builder.append(_assigment, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\'");
        String _name = ((EClass)it).getName();
        _builder.append(_name, "\t");
        _builder.append("\'");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _idAssignment = this.idAssignment(((EClass)it));
        _builder.append(_idAssignment, "\t");
        {
          Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(((EClass)it));
          boolean _isEmpty = IterableExtensions.isEmpty(_inlinedFeatures);
          boolean _not = (!_isEmpty);
          if (_not) {
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\'{\'");
            _builder.newLine();
            {
              Iterable<EAttribute> _allAttributes = Ecore2XtextExtensions.allAttributes(((EClass)it));
              for(final EAttribute attr : _allAttributes) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _assigment_1 = this.assigment(attr);
                _builder.append(_assigment_1, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              Iterable<EReference> _allCrossReferences = Ecore2XtextExtensions.allCrossReferences(((EClass)it));
              for(final EReference ref : _allCrossReferences) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _assigment_2 = this.assigment(ref);
                _builder.append(_assigment_2, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              Iterable<EReference> _allContainmentReferences = Ecore2XtextExtensions.allContainmentReferences(((EClass)it));
              for(final EReference conti : _allContainmentReferences) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _assigment_3 = this.assigment(conti);
                _builder.append(_assigment_3, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\'}\'");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _switchResult = _builder;
      }
    }
    if (!_matched) {
      if (it instanceof EEnum) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum ");
        String _name = ((EEnum)it).getName();
        String _quoteIfNeccesary = Ecore2XtextExtensions.quoteIfNeccesary(_name);
        _builder.append(_quoteIfNeccesary, "");
        _builder.append(" returns ");
        String _fqn = Ecore2XtextExtensions.fqn(it);
        _builder.append(_fqn, "");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        EList<EEnumLiteral> _eLiterals = ((EEnum)it).getELiterals();
        final Function1<EEnumLiteral,String> _function = new Function1<EEnumLiteral,String>() {
          public String apply(final EEnumLiteral it) {
            String _name = it.getName();
            String _plus = (_name + " = \'");
            String _name_1 = it.getName();
            String _plus_1 = (_plus + _name_1);
            return (_plus_1 + "\'");
          }
        };
        List<String> _map = ListExtensions.<EEnumLiteral, String>map(_eLiterals, _function);
        String _join = IterableExtensions.join(_map, " | ");
        _builder.append(_join, "\t\t\t\t");
        _builder.append(";");
        _switchResult = _builder;
      }
    }
    if (!_matched) {
      if (it instanceof EDataType) {
        _matched=true;
        CharSequence _xifexpression = null;
        boolean _isSerializable = ((EDataType)it).isSerializable();
        if (_isSerializable) {
          StringConcatenation _builder = new StringConcatenation();
          String _uniqueName = UniqueNameUtil.uniqueName(it);
          _builder.append(_uniqueName, "");
          _builder.append(" returns ");
          String _fqn = Ecore2XtextExtensions.fqn(it);
          _builder.append(_fqn, "");
          _builder.append(":");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _dataTypeRuleBody = Ecore2XtextExtensions.dataTypeRuleBody(((EDataType)it));
          _builder.append(_dataTypeRuleBody, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _xifexpression = _builder;
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      throw new IllegalStateException(("No rule template for " + it));
    }
    return _switchResult;
  }
}
