/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.validation;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.MarkerEraser;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceUIValidatorExtension
extends MarkerEraser
implements IResourceUIValidatorExtension {
    private static final Logger log = Logger.getLogger(DefaultResourceUIValidatorExtension.class);
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private MarkerTypeProvider markerTypeProvider;

    @Override
    public void updateValidationMarkers(IFile file, Resource resource, CheckMode mode, IProgressMonitor monitor) {
        if (this.shouldProcess(file)) {
            this.addMarkers(file, resource, mode, monitor);
        }
    }

    @Override
    public void deleteValidationMarkers(IFile file, CheckMode checkMode, IProgressMonitor monitor) {
        super.deleteValidationMarkers(file, checkMode, monitor);
    }

    protected void addMarkers(IFile file, Resource resource, CheckMode mode, IProgressMonitor monitor) {
        try {
            List list = this.resourceValidator.validate(resource, mode, this.getCancelIndicator(monitor));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.deleteMarkers(file, mode, monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createMarkers(file, list, monitor);
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void createMarkers(IFile file, List<Issue> list, IProgressMonitor monitor) throws CoreException {
        for (Issue issue : list) {
            this.markerCreator.createMarker(issue, (IResource)file, this.markerTypeProvider.getMarkerType(issue));
        }
    }

    protected CancelIndicator getCancelIndicator(final IProgressMonitor monitor) {
        return new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
    }
}

