/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditor;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditorInputRedirector;

public class JavaEditorInputMatcher
implements IEditorMatchingStrategy {
    private static final Logger logger = Logger.getLogger(JavaEditorInputMatcher.class);
    @Inject
    private ITraceForTypeRootProvider traceInformation;
    @Inject
    private XtextEditorInfo editorInfo;
    @Inject
    private StacktraceBasedEditorDecider decisions;
    @Inject
    private XbaseEditorInputRedirector editorInputRedirector;

    public boolean matches(IEditorReference editorRef, IEditorInput inputToCheck) {
        ITrace traceToSource;
        IResource currentResource;
        ITypeRoot newTypeRoot;
        block15: {
            block14: {
                IEditorInput currentInput;
                block13: {
                    IEditorInput newInput;
                    block12: {
                        block11: {
                            IEditorPart existingEditor;
                            ITypeRoot newTypeRoot2;
                            block10: {
                                if (this.editorInfo.getEditorId().equals(editorRef.getId())) break block10;
                                return false;
                            }
                            newInput = this.editorInputRedirector.findOriginalSourceForOuputFolderCopy(inputToCheck);
                            currentInput = editorRef.getEditorInput();
                            if (!newInput.equals(currentInput)) break block11;
                            if (this.decisions.decideAccordingToCaller() != StacktraceBasedEditorDecider.Decision.FORCE_JAVA && (newTypeRoot2 = this.editorInputRedirector.getTypeRoot(newInput)) != null && (existingEditor = editorRef.getEditor(true)) instanceof XbaseEditor) {
                                ((XbaseEditor)existingEditor).markNextSelectionAsJavaOffset(newTypeRoot2);
                            }
                            return true;
                        }
                        if (this.decisions.decideAccordingToCaller() != StacktraceBasedEditorDecider.Decision.FORCE_JAVA) break block12;
                        return false;
                    }
                    newTypeRoot = this.editorInputRedirector.getTypeRoot(newInput);
                    if (newTypeRoot != null) break block13;
                    return false;
                }
                currentResource = ResourceUtil.getResource((IEditorInput)currentInput);
                if (currentResource != null) break block14;
                return false;
            }
            traceToSource = this.traceInformation.getTraceToSource(newTypeRoot);
            if (traceToSource != null) break block15;
            return false;
        }
        try {
            IEditorPart existingEditor;
            if (this.isCurrentResource(currentResource, traceToSource) && (existingEditor = editorRef.getEditor(true)) instanceof XbaseEditor) {
                ((XbaseEditor)existingEditor).markNextSelectionAsJavaOffset(newTypeRoot);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected boolean isCurrentResource(IResource currentResource, ITrace traceToSource) {
        Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        IStorage storage = ((ILocationInResource)iterator.next()).getStorage();
        return currentResource.equals((Object)storage);
    }
}

