/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordAlternativeConverter
extends AbstractValueConverter<String>
implements IValueConverter.RuleSpecific {
    private Set<String> keywords;
    private AbstractRule delegateRule;
    @Inject
    private IValueConverterService delegateService;
    private IValueConverter<Object> delegateConverter;

    @Override
    public String toValue(String string, INode node) throws ValueConverterException {
        if (this.keywords.contains(string)) {
            return string;
        }
        String result = (String)this.getDelegateConverter().toValue(string, node);
        return result;
    }

    @Override
    public String toString(String value) throws ValueConverterException {
        if (this.keywords.contains(value)) {
            return value;
        }
        String result = this.getDelegateConverter().toString(value);
        return result;
    }

    private IValueConverter<Object> getDelegateConverter() {
        if (this.delegateConverter != null) {
            return this.delegateConverter;
        }
        if (this.delegateService instanceof IValueConverterService.Introspectable) {
            this.delegateConverter = ((IValueConverterService.Introspectable)((Object)this.delegateService)).getConverter(this.delegateRule.getName());
            return this.delegateConverter;
        }
        final String ruleName = this.delegateRule.getName();
        this.delegateConverter = new IValueConverter<Object>(){

            @Override
            public Object toValue(String string, INode node) throws ValueConverterException {
                return KeywordAlternativeConverter.this.delegateService.toValue(string, ruleName, node);
            }

            @Override
            public String toString(Object value) throws ValueConverterException {
                return KeywordAlternativeConverter.this.delegateService.toString(value, ruleName);
            }
        };
        return this.delegateConverter;
    }

    protected String keywordToString(Keyword keyword) {
        return keyword.getValue();
    }

    @Override
    public void setRule(AbstractRule rule) {
        if (!GrammarUtil.isDatatypeRule(rule)) {
            throw new IllegalArgumentException(String.valueOf(rule.getName()) + " is not a data type rule");
        }
        if (!(rule.getAlternatives() instanceof Alternatives)) {
            if (rule.getAlternatives() instanceof RuleCall) {
                this.delegateRule = ((RuleCall)rule.getAlternatives()).getRule();
                this.keywords = Collections.emptySet();
                return;
            }
            throw new IllegalArgumentException(String.valueOf(rule.getName()) + " is not an alternative and not a rule call");
        }
        Alternatives alternatives = (Alternatives)rule.getAlternatives();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (AbstractElement element : alternatives.getElements()) {
            if (element instanceof Keyword) {
                builder.add((Object)this.keywordToString((Keyword)element));
                continue;
            }
            if (element instanceof RuleCall) {
                if (this.delegateRule != null) {
                    throw new IllegalArgumentException(String.valueOf(rule.getName()) + "'s body does not contain an alternative of keywords and a single rule");
                }
                this.delegateRule = ((RuleCall)element).getRule();
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(rule.getName()) + "'s body does not contain an alternative of keywords and a single rule");
        }
        this.keywords = builder.build();
    }
}

