/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.formatting.impl.AbstractFormattingConfig;
import org.eclipse.xtext.formatting.impl.BaseFormatter;
import org.eclipse.xtext.formatting.impl.ElementMatcherToDot;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfig2;
import org.eclipse.xtext.formatting.impl.FormattingConfigBasedStream;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeclarativeFormatter
extends BaseFormatter {
    @Inject
    private ConfigStore config;
    @Inject
    private IGrammarAccess grammarAccess;
    @Inject
    private IHiddenTokenHelper hiddenTokenHelper;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    private URI contextResourceURI;
    @Inject
    private IElementMatcherProvider matcherProvider;

    protected abstract void configureFormatting(FormattingConfig var1);

    @Override
    public ITokenStream createFormatterStream(String indent, ITokenStream out, boolean preserveWhitespaces) {
        return new FormattingConfigBasedStream(out, indent, this.getConfig(), this.createMatcher(), this.hiddenTokenHelper, preserveWhitespaces);
    }

    @Override
    public ITokenStream createFormatterStream(EObject context, String indent, ITokenStream out, boolean preserveWhitespaces) {
        if (context != null && context.eResource() != null && context.eResource().getURI() != null) {
            this.contextResourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI(context).trimFragment();
        }
        return new FormattingConfigBasedStream(out, indent, this.getConfig(), this.createMatcher(), this.hiddenTokenHelper, preserveWhitespaces);
    }

    protected FormattingConfig createFormattingConfig() {
        FormattingConfig2 cfg = new FormattingConfig2(this.grammarAccess, this.hiddenTokenHelper, this.getIndentInfo(), this.getLineSeparatorInfo());
        cfg.setWhitespaceRule(this.getWSRule());
        return cfg;
    }

    protected IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern> createMatcher() {
        return this.matcherProvider.createMatcher(this.getConfig().getLocatorsForSemanticTokens());
    }

    protected synchronized FormattingConfig getConfig() {
        if (this.config.config == null) {
            this.config.config = this.createFormattingConfig();
            this.configureFormatting(this.config.config);
        }
        return this.config.config;
    }

    protected IGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    protected IHiddenTokenHelper getHiddenTokenHelper() {
        return this.hiddenTokenHelper;
    }

    protected IIndentationInformation getIndentInfo() {
        return this.whitespaceInformationProvider.getIndentationInformation(this.contextResourceURI);
    }

    protected ILineSeparatorInformation getLineSeparatorInfo() {
        return this.whitespaceInformationProvider.getLineSeparatorInformation(this.contextResourceURI);
    }

    protected IElementMatcherProvider getMatcherProvider() {
        return this.matcherProvider;
    }

    protected void saveDebugGraphvizDiagram(String filename) {
        try {
            File file = new File(filename).getCanonicalFile();
            System.out.println("Saving Graphviz diagram to " + file);
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            new ElementMatcherToDot().draw(this.createMatcher(), ps);
            ps.flush();
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setGrammarAccess(IGrammarAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
    }

    @Singleton
    protected static class ConfigStore {
        protected FormattingConfig config;

        protected ConfigStore() {
        }
    }
}

