/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.TraceRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceRegionSerializer {
    private static final int VERSION_3 = 3;
    private static final int VERSION_4 = 4;

    public void writeTraceRegionTo(AbstractTraceRegion region, OutputStream stream) throws IOException {
        if (region != null && region.getParent() != null) {
            throw new IllegalArgumentException("region must be the root");
        }
        this.doWriteTo(new IdentityStrategy(), region, stream);
    }

    public <Region, Location> void doWriteTo(final Strategy<Region, Location> strategy, Region region, OutputStream stream) throws IOException {
        final DataOutputStream dataStream = new DataOutputStream(new BufferedOutputStream(stream));
        try {
            dataStream.writeInt(4);
            dataStream.writeBoolean(region != null);
            if (region == null) {
                return;
            }
            strategy.writeRegion(region, new Callback<Region, Location>(){

                @Override
                public void doWriteRegion(int offset, int length, int lineNumber, int endLineNumber, List<Location> locations, List<Region> children) throws IOException {
                    dataStream.writeInt(offset);
                    dataStream.writeInt(length);
                    dataStream.writeInt(lineNumber);
                    dataStream.writeInt(endLineNumber);
                    dataStream.writeInt(locations.size());
                    for (Object loc : locations) {
                        strategy.writeLocation(loc, this);
                    }
                    dataStream.writeInt(children.size());
                    for (Object child : children) {
                        strategy.writeRegion(child, this);
                    }
                }

                @Override
                public void doWriteLocation(int offset, int length, int lineNumber, int endLineNumber, URI path) throws IOException {
                    dataStream.writeInt(offset);
                    dataStream.writeInt(length);
                    dataStream.writeInt(lineNumber);
                    dataStream.writeInt(endLineNumber);
                    if (path != null) {
                        dataStream.writeBoolean(true);
                        dataStream.writeUTF(path.toString());
                    } else {
                        dataStream.writeBoolean(false);
                    }
                }
            });
        }
        finally {
            dataStream.flush();
        }
    }

    public AbstractTraceRegion readTraceRegionFrom(InputStream contents) throws IOException {
        return this.doReadFrom(contents, new IdentityStrategy());
    }

    public <Region, Location> Region doReadFrom(InputStream contents, Strategy<Region, Location> reader) throws IOException {
        boolean isNull;
        DataInputStream dataStream = new DataInputStream(new BufferedInputStream(contents));
        int version = dataStream.readInt();
        if (version != 3 && version != 4) {
            return null;
        }
        boolean bl = isNull = !dataStream.readBoolean();
        if (isNull) {
            return null;
        }
        return this.doReadFrom(dataStream, reader, null, version);
    }

    public <Location, Region> Region doReadFrom(DataInputStream dataStream, Strategy<Region, Location> reader, Region parent, int version) throws IOException {
        int offset = dataStream.readInt();
        int length = dataStream.readInt();
        int lineNumber = dataStream.readInt();
        int endLineNumber = dataStream.readInt();
        int locationSize = dataStream.readInt();
        ArrayList allLocations = Lists.newArrayListWithCapacity((int)locationSize);
        while (locationSize != 0) {
            int locationOffset = dataStream.readInt();
            int locationLength = dataStream.readInt();
            int locationLineNumber = dataStream.readInt();
            int locationEndLineNumber = dataStream.readInt();
            URI path = null;
            if (dataStream.readBoolean()) {
                path = URI.createURI((String)dataStream.readUTF());
            }
            if (version == 3 && dataStream.readBoolean()) {
                dataStream.readUTF();
            }
            allLocations.add(reader.createLocation(locationOffset, locationLength, locationLineNumber, locationEndLineNumber, path));
            --locationSize;
        }
        Region result = reader.createRegion(offset, length, lineNumber, endLineNumber, allLocations, parent);
        int childrenSize = dataStream.readInt();
        while (childrenSize != 0) {
            this.doReadFrom(dataStream, reader, result, version);
            --childrenSize;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback<Region, Location> {
        public void doWriteRegion(int var1, int var2, int var3, int var4, List<Location> var5, List<Region> var6) throws IOException;

        public void doWriteLocation(int var1, int var2, int var3, int var4, URI var5) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IdentityStrategy
    implements Strategy<AbstractTraceRegion, ILocationData> {
        protected IdentityStrategy() {
        }

        @Override
        public ILocationData createLocation(int offset, int length, int lineNumber, int endLineNumber, URI path) {
            return new LocationData(offset, length, lineNumber, endLineNumber, path);
        }

        @Override
        public AbstractTraceRegion createRegion(int offset, int length, int lineNumber, int endLineNumber, List<ILocationData> associations, AbstractTraceRegion parent) {
            return new TraceRegion(offset, length, lineNumber, endLineNumber, associations, parent);
        }

        @Override
        public void writeRegion(AbstractTraceRegion region, Callback<AbstractTraceRegion, ILocationData> callback) throws IOException {
            callback.doWriteRegion(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), region.getAssociatedLocations(), region.getNestedRegions());
        }

        @Override
        public void writeLocation(ILocationData location, Callback<AbstractTraceRegion, ILocationData> callback) throws IOException {
            callback.doWriteLocation(location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber(), location.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Strategy<Region, Location> {
        public Location createLocation(int var1, int var2, int var3, int var4, URI var5);

        public Region createRegion(int var1, int var2, int var3, int var4, List<Location> var5, Region var6);

        public void writeRegion(Region var1, Callback<Region, Location> var2) throws IOException;

        public void writeLocation(Location var1, Callback<Region, Location> var2) throws IOException;
    }
}

