/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedName
implements Comparable<QualifiedName> {
    private final int hash;
    private final String[] segments;
    private QualifiedName lowerCase;
    public static final QualifiedName EMPTY = new QualifiedName(new String[0]){

        public QualifiedName append(QualifiedName relativeQualifiedName) {
            return relativeQualifiedName;
        }

        public QualifiedName append(String segment) {
            return QualifiedName.create(segment);
        }

        public QualifiedName toLowerCase() {
            return this;
        }

        public QualifiedName toUpperCase() {
            return this;
        }
    };

    public static QualifiedName create(String ... segments) {
        if (segments == null || segments.length == 0) {
            return EMPTY;
        }
        if (segments.length == 1) {
            return QualifiedName.create(segments[0]);
        }
        int i = 0;
        while (i < segments.length) {
            if (segments[i] == null) {
                throw new IllegalArgumentException("Segment cannot be null");
            }
            ++i;
        }
        return new QualifiedName((String[])segments.clone());
    }

    public static QualifiedName createFromStream(BinaryResourceImpl.EObjectInputStream eObjectInputStream) throws IOException {
        int segmentCount = eObjectInputStream.readCompressedInt();
        if (segmentCount == 0) {
            return EMPTY;
        }
        String[] segments = new String[segmentCount];
        int i = 0;
        while (i < segmentCount) {
            segments[i] = eObjectInputStream.readSegmentedString();
            ++i;
        }
        return new QualifiedName(segments);
    }

    public void writeToStream(BinaryResourceImpl.EObjectOutputStream eObjectOutputStream) throws IOException {
        int segmentCount = this.getSegmentCount();
        eObjectOutputStream.writeCompressedInt(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            eObjectOutputStream.writeSegmentedString(this.getSegment(i));
            ++i;
        }
    }

    public static QualifiedName create(List<String> segments) {
        if (segments == null || segments.isEmpty()) {
            return EMPTY;
        }
        if (segments.size() == 1) {
            String singleSegment = segments.get(0);
            return QualifiedName.create(singleSegment);
        }
        String[] segmentArray = segments.toArray(new String[segments.size()]);
        int i = 0;
        while (i < segmentArray.length) {
            if (segmentArray[i] == null) {
                throw new IllegalArgumentException("Segment cannot be null");
            }
            ++i;
        }
        return new QualifiedName(segmentArray);
    }

    public static QualifiedName create(String singleSegment) {
        if (singleSegment == null) {
            throw new IllegalArgumentException("Segment cannot be null");
        }
        return new QualifiedName(singleSegment);
    }

    public static <F> Function<F, QualifiedName> wrapper(final Function<F, String> nameFunction) {
        return new Function<F, QualifiedName>(){

            public QualifiedName apply(F from) {
                String name = (String)nameFunction.apply(from);
                if (name == null) {
                    return null;
                }
                return QualifiedName.create(name);
            }
        };
    }

    protected QualifiedName(String ... segments) {
        this.segments = segments == null || segments.length == 0 ? Strings.EMPTY_ARRAY : segments;
        this.hash = Arrays.hashCode(this.segments);
    }

    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int index) {
        return this.segments[index];
    }

    public String getLastSegment() {
        return this.segments[this.segments.length - 1];
    }

    public String getFirstSegment() {
        return this.segments[0];
    }

    public QualifiedName append(String segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment cannot be null");
        }
        String[] newSegments = new String[this.getSegmentCount() + 1];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        newSegments[this.segments.length] = segment;
        return new QualifiedName(newSegments);
    }

    public QualifiedName append(QualifiedName relativeQualifiedName) {
        String[] newSegments = new String[this.getSegmentCount() + relativeQualifiedName.getSegmentCount()];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = this.getSegment(i);
            ++i;
        }
        i = 0;
        while (i < relativeQualifiedName.getSegmentCount()) {
            newSegments[i + this.getSegmentCount()] = relativeQualifiedName.getSegment(i);
            ++i;
        }
        return new QualifiedName(newSegments);
    }

    public QualifiedName skipFirst(int skipCount) {
        if (skipCount == this.getSegmentCount()) {
            return EMPTY;
        }
        if (skipCount > this.getSegmentCount() || skipCount < 0) {
            throw new IllegalArgumentException("Cannot skip " + skipCount + " fragments from QualifiedName with " + this.getSegmentCount() + " segments");
        }
        String[] newSegments = new String[this.segments.length - skipCount];
        System.arraycopy(this.segments, skipCount, newSegments, 0, newSegments.length);
        return new QualifiedName(newSegments);
    }

    public QualifiedName skipLast(int skipCount) {
        if (skipCount == this.getSegmentCount()) {
            return EMPTY;
        }
        if (skipCount > this.getSegmentCount() || skipCount < 0) {
            throw new IllegalArgumentException("Cannot skip " + skipCount + " fragments from QualifiedName with " + this.getSegmentCount() + " segments");
        }
        String[] newSegments = new String[this.segments.length - skipCount];
        System.arraycopy(this.segments, 0, newSegments, 0, newSegments.length);
        return new QualifiedName(newSegments);
    }

    public QualifiedName toLowerCase() {
        if (this.lowerCase != null) {
            return this.lowerCase;
        }
        String[] newSegments = new String[this.segments.length];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = this.segments[i].toLowerCase();
            ++i;
        }
        this.lowerCase = new QualifiedNameLowerCase(newSegments);
        return this.lowerCase;
    }

    public QualifiedName toUpperCase() {
        String[] newSegments = new String[this.getSegmentCount()];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = this.segments[i].toUpperCase();
            ++i;
        }
        return new QualifiedName(newSegments);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QualifiedName) {
            QualifiedName other = (QualifiedName)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.segments, other.segments);
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object obj) {
        return obj instanceof QualifiedName && ((QualifiedName)obj).getSegmentCount() == this.getSegmentCount() && this.startsWith((QualifiedName)obj, true);
    }

    @Override
    public int compareTo(QualifiedName qualifiedName) {
        return this.compareTo(qualifiedName, false);
    }

    public int compareToIgnoreCase(QualifiedName qualifiedName) {
        return this.compareTo(qualifiedName, true);
    }

    protected int compareTo(QualifiedName qualifiedName, boolean ignoreCase) {
        int i = 0;
        while (i < Math.min(this.getSegmentCount(), qualifiedName.getSegmentCount())) {
            int result;
            int n = result = ignoreCase ? this.getSegment(i).compareToIgnoreCase(qualifiedName.getSegment(i)) : this.getSegment(i).compareTo(qualifiedName.getSegment(i));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return this.getSegmentCount() - qualifiedName.getSegmentCount();
    }

    public boolean startsWith(QualifiedName prefix) {
        return this.startsWith(prefix, false);
    }

    public boolean startsWithIgnoreCase(QualifiedName prefix) {
        return this.startsWith(prefix, true);
    }

    protected boolean startsWith(QualifiedName prefix, boolean ignoreCase) {
        if (prefix.getSegmentCount() > this.getSegmentCount()) {
            return false;
        }
        int i = 0;
        while (i < prefix.getSegmentCount()) {
            if (ignoreCase && !this.getSegment(i).equalsIgnoreCase(prefix.getSegment(i)) || !ignoreCase && !this.getSegment(i).equals(prefix.getSegment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.toString(".");
    }

    public String toString(String delimiter) {
        int segmentCount = this.getSegmentCount();
        switch (segmentCount) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getFirstSegment();
            }
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < segmentCount) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(this.segments[i]);
            ++i;
        }
        return builder.toString();
    }

    private static class QualifiedNameLowerCase
    extends QualifiedName {
        public QualifiedNameLowerCase(String[] segments) {
            super(segments);
        }

        public QualifiedName toLowerCase() {
            return this;
        }
    }
}

