/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.resource.DescriptionUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.DirtyStateManager;
import org.eclipse.xtext.ui.editor.DirtyStateResourceDescription;
import org.eclipse.xtext.ui.editor.DocumentBasedDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IValidationJobScheduler;
import org.eclipse.xtext.ui.editor.Messages;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.notification.IStateChangeEventBroker;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DirtyStateEditorSupport
implements IResourceDescription.Event.Listener,
VerifyListener {
    private static ISchedulingRule SCHEDULING_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private IStateChangeEventBroker stateChangeEventBroker;
    @Inject
    private DocumentBasedDirtyResource dirtyResource;
    @Inject(optional=true)
    private IResourceStorageFacade resoureStorageFacade;
    private ClientAwareDirtyResource delegatingClientAwareResource;
    @Inject
    private IConcurrentEditingCallback concurrentEditingWarningDialog;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject(optional=true)
    private DescriptionUtils descriptionUtils;
    @Inject(optional=true)
    private IValidationJobScheduler validationJobScheduler;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private volatile IDirtyStateEditorSupportClient currentClient;
    private volatile boolean isDirty;
    private UpdateEditorStateJob updateEditorStateJob;

    public void initializeDirtyStateSupport(IDirtyStateEditorSupportClient client) {
        if (this.currentClient != null) {
            throw new IllegalStateException("editor was already assigned");
        }
        this.currentClient = client;
        this.isDirty = false;
        IXtextDocument document = client.getDocument();
        this.initDirtyResource(document);
        this.stateChangeEventBroker.addListener(this);
        client.addVerifyListener(this);
        this.scheduleValidationJobIfNecessary();
    }

    private void scheduleValidationJobIfNecessary() {
        if (this.validationJobScheduler != null && this.currentClient != null) {
            this.validationJobScheduler.scheduleInitialValidation(this.currentClient.getDocument());
        }
    }

    public void verifyText(VerifyEvent e) {
        if (this.isDirty || !e.doit) {
            return;
        }
        e.doit = this.doVerify();
        if (e.doit) {
            this.isDirty = true;
        }
    }

    public boolean doVerify() {
        if (!this.dirtyStateManager.manageDirtyState(this.delegatingClientAwareResource)) {
            ClientAwareDirtyResource clientAwareDirtyResource;
            IDirtyResource other;
            if (this.dirtyStateManager instanceof DirtyStateManager && (other = ((DirtyStateManager)this.dirtyStateManager).getDirtyResource(this.delegatingClientAwareResource.getURI())) instanceof ClientAwareDirtyResource && !(clientAwareDirtyResource = (ClientAwareDirtyResource)other).isDirty()) {
                clientAwareDirtyResource.discardThisResource();
                return this.doVerify();
            }
            if (!this.isConcurrentEditingIgnored()) {
                this.dirtyStateManager.discardDirtyState(this.delegatingClientAwareResource);
                return false;
            }
        }
        return true;
    }

    public boolean isEditingPossible(IDirtyStateEditorSupportClient client) {
        if (this.currentClient == null || this.currentClient != client) {
            throw new IllegalStateException("Was configured with another client or not configured at all.");
        }
        if (this.isDirty) {
            return true;
        }
        if (!this.doVerify()) {
            return false;
        }
        this.isDirty = true;
        return true;
    }

    protected boolean isConcurrentEditingIgnored() {
        return this.concurrentEditingWarningDialog.isConcurrentEditingIgnored(this.currentClient);
    }

    protected void initDirtyResource(IXtextDocument document) {
        this.dirtyResource.connect(document);
        this.delegatingClientAwareResource = new ClientAwareDirtyResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirtyStateSupport(IDirtyStateEditorSupportClient client) {
        if (this.currentClient == null) {
            return;
        }
        if (this.currentClient != client) {
            throw new IllegalStateException("Was configured with another client or not configured at all.");
        }
        client.removeVerifyListener(this);
        this.stateChangeEventBroker.removeListener(this);
        IDirtyStateManager iDirtyStateManager = this.dirtyStateManager;
        synchronized (iDirtyStateManager) {
            IXtextDocument document;
            if (this.dirtyResource.isInitialized()) {
                this.dirtyStateManager.discardDirtyState(this.delegatingClientAwareResource);
            }
            if ((document = client.getDocument()) == null) {
                document = this.dirtyResource.getUnderlyingDocument();
            }
            if (document != null) {
                this.dirtyResource.disconnect(document);
            }
        }
        this.delegatingClientAwareResource = null;
        this.currentClient = null;
    }

    public void markEditorClean(IDirtyStateEditorSupportClient client) {
        if (this.currentClient == null || this.currentClient != client) {
            throw new IllegalStateException("Was configured with another client or not configured at all.");
        }
        this.dirtyStateManager.discardDirtyState(this.delegatingClientAwareResource);
        this.isDirty = false;
        IResourceDescription cleanDescription = this.resourceDescriptions.getResourceDescription(this.delegatingClientAwareResource.getURI());
        if (cleanDescription != null) {
            this.dirtyResource.copyState(cleanDescription);
        }
    }

    public void descriptionsChanged(IResourceDescription.Event event) {
        if (!this.getDirtyResource().isInitialized()) {
            return;
        }
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            if (delta.getOld() != this.getDirtyResource().getDescription() && delta.getNew() != this.getDirtyResource().getDescription()) continue;
            return;
        }
        this.scheduleUpdateEditorJob(event);
    }

    public void scheduleUpdateEditorJob(IResourceDescription.Event event) {
        UpdateEditorStateJob job = this.updateEditorStateJob;
        if (job == null) {
            this.updateEditorStateJob = job = this.createUpdateEditorJob();
        }
        job.scheduleFor(event);
    }

    public void waitForUpdateEditorJob() throws InterruptedException {
        if (this.updateEditorStateJob != null) {
            this.updateEditorStateJob.join();
        }
    }

    protected UpdateEditorStateJob createUpdateEditorJob() {
        return new UpdateEditorStateJob(SCHEDULING_RULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceDirtyState(XtextResource resource) {
        if (resource == null || !this.dirtyResource.isInitialized()) {
            return;
        }
        ClientAwareDirtyResource clientAwareResource = this.delegatingClientAwareResource;
        if (this.isDirty || (!resource.isTrackingModification() || resource.isModified()) && clientAwareResource.isDirty() && this.dirtyStateManager.manageDirtyState(clientAwareResource)) {
            IDirtyStateManager iDirtyStateManager = this.dirtyStateManager;
            synchronized (iDirtyStateManager) {
                IResourceDescription newDescription;
                IResourceDescription.Manager resourceDescriptionManager = this.getResourceDescriptionManagerIfOwnLanguage(resource);
                if (resourceDescriptionManager != null && this.haveEObjectDescriptionsChanged(newDescription = resourceDescriptionManager.getResourceDescription((Resource)resource), resourceDescriptionManager)) {
                    this.dirtyResource.copyState(newDescription);
                    if (this.resoureStorageFacade != null && resource instanceof StorageAwareResource) {
                        StorageAwareResource storageAwareResource = (StorageAwareResource)resource;
                        class MyByteArrayOutputStream
                        extends ByteArrayOutputStream {
                            MyByteArrayOutputStream() {
                            }

                            @Override
                            public synchronized byte[] toByteArray() {
                                return this.buf;
                            }

                            public int length() {
                                return this.count;
                            }
                        }
                        final MyByteArrayOutputStream bout = new MyByteArrayOutputStream();
                        ResourceStorageWritable resourceOutputStream = this.resoureStorageFacade.createResourceStorageWritable((OutputStream)bout);
                        resourceOutputStream.writeResource(storageAwareResource);
                        this.dirtyResource.setResourceStorageLoadableProvider(new Provider<ResourceStorageLoadable>(){
                            {
                            }

                            public ResourceStorageLoadable get() {
                                return DirtyStateEditorSupport.this.resoureStorageFacade.createResourceStorageLoadable((InputStream)new ByteArrayInputStream(bout.toByteArray(), 0, bout.length()));
                            }
                        });
                    }
                    this.dirtyStateManager.announceDirtyStateChanged(clientAwareResource);
                }
            }
        }
    }

    public void modelChanged(XtextResource resource) {
        throw new IllegalStateException("DirtyStateEditorSupport should no longer be called as an IXtextModelListener");
    }

    public void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI resourceURI) {
        return (IResourceDescription.Manager)this.resourceServiceProviderRegistry.getResourceServiceProvider(resourceURI).get(DirtyStateResourceDescription.Manager.class);
    }

    protected IResourceDescription.Manager getResourceDescriptionManagerIfOwnLanguage(XtextResource resource) {
        String resourceLanguageName;
        IResourceServiceProvider rsp = this.resourceServiceProviderRegistry.getResourceServiceProvider(resource.getURI());
        if (rsp == null) {
            return null;
        }
        String uriLanguageName = ((LanguageInfo)rsp.get(LanguageInfo.class)).getLanguageName();
        if (!uriLanguageName.equals(resourceLanguageName = resource.getLanguageName())) {
            return null;
        }
        return this.getResourceDescriptionManager(resource.getURI());
    }

    @Deprecated
    public boolean haveEObjectDescriptionsChanged(IResourceDescription newDescription) {
        return this.haveEObjectDescriptionsChanged(newDescription, this.getResourceDescriptionManager(newDescription.getURI()));
    }

    public boolean haveEObjectDescriptionsChanged(IResourceDescription newDescription, IResourceDescription.Manager resourceDescriptionManager) {
        boolean haveEObjectDescriptionsChanged = resourceDescriptionManager.createDelta(this.dirtyResource.getDescription(), newDescription).haveEObjectDescriptionsChanged();
        return haveEObjectDescriptionsChanged;
    }

    protected Collection<Resource> collectAffectedResources(XtextResource resource, IResourceDescription.Event event) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)4);
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            this.processDelta(delta, (Resource)resource, result);
        }
        return result;
    }

    protected void processDelta(IResourceDescription.Delta delta, Resource context, List<Resource> result) {
        ResourceSet resourceSet = context.getResourceSet();
        Resource resourceInResourceSet = resourceSet.getResource(delta.getUri(), false);
        if (resourceInResourceSet != null && resourceInResourceSet != context) {
            result.add(resourceInResourceSet);
        }
    }

    protected boolean isReparseRequired(XtextResource resource, IResourceDescription.Event event) {
        IResourceDescription originalDescription;
        IResourceDescription.Manager resourceDescriptionManager = resource.getResourceServiceProvider().getResourceDescriptionManager();
        IResourceDescription description = resourceDescriptionManager.getResourceDescription((Resource)resource);
        if (resourceDescriptionManager.isAffected((Collection)event.getDeltas(), description, this.resourceDescriptions)) {
            return true;
        }
        if (!this.isDirty() && !this.dirtyStateManager.hasContent(resource.getURI()) && (originalDescription = this.resourceDescriptions.getResourceDescription(resource.getURI())) != null && this.descriptionUtils != null) {
            Set outgoingReferences = this.descriptionUtils.collectOutgoingReferences(originalDescription);
            for (IResourceDescription.Delta delta : event.getDeltas()) {
                if (!delta.haveEObjectDescriptionsChanged() || !outgoingReferences.contains(delta.getUri())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected ChangedResourceDescriptionDelta createDelta(IResourceDescription.Delta delta, IResourceDescription.Delta prev) {
        return new ChangedResourceDescriptionDelta(prev.getOld(), delta.getNew());
    }

    public IDirtyStateManager getDirtyStateManager() {
        return this.dirtyStateManager;
    }

    public void setDirtyStateManager(IDirtyStateManager dirtyStateManager) {
        this.dirtyStateManager = dirtyStateManager;
    }

    public IStateChangeEventBroker getStateChangeEventBroker() {
        return this.stateChangeEventBroker;
    }

    public void setStateChangeEventBroker(IStateChangeEventBroker stateChangeEventBroker) {
        this.stateChangeEventBroker = stateChangeEventBroker;
    }

    public void setConcurrentEditingWarningDialog(IConcurrentEditingCallback concurrentEditingWarningDialog) {
        this.concurrentEditingWarningDialog = concurrentEditingWarningDialog;
    }

    public IConcurrentEditingCallback getConcurrentEditingWarningDialog() {
        return this.concurrentEditingWarningDialog;
    }

    public void setDirtyResource(DocumentBasedDirtyResource dirtyResource) {
        this.dirtyResource = dirtyResource;
    }

    public DocumentBasedDirtyResource getDirtyResource() {
        return this.dirtyResource;
    }

    public void setResourceDescriptions(IResourceDescriptions resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }

    private class ClientAwareDirtyResource
    implements IDirtyResource.NormalizedURISupportExtension,
    IDirtyResource.ICurrentStateProvidingExtension,
    IDirtyResource.InitializationAware {
        private ClientAwareDirtyResource() {
        }

        @Override
        public String getContents() {
            return DirtyStateEditorSupport.this.dirtyResource.getContents();
        }

        @Override
        public String getActualContents() {
            return DirtyStateEditorSupport.this.dirtyResource.getActualContents();
        }

        @Override
        public IResourceDescription getDescription() {
            return DirtyStateEditorSupport.this.dirtyResource.getDescription();
        }

        @Override
        public URI getURI() {
            return DirtyStateEditorSupport.this.dirtyResource.getURI();
        }

        private boolean isDirty() {
            return DirtyStateEditorSupport.this.currentClient != null && DirtyStateEditorSupport.this.currentClient.isDirty();
        }

        private void discardThisResource() {
            DirtyStateEditorSupport.this.markEditorClean(DirtyStateEditorSupport.this.currentClient);
        }

        @Override
        public URI getNormalizedURI() {
            return DirtyStateEditorSupport.this.dirtyResource.getNormalizedURI();
        }

        @Override
        public ResourceStorageLoadable getResourceStorageLoadable() {
            return DirtyStateEditorSupport.this.dirtyResource.getResourceStorageLoadable();
        }

        @Override
        public boolean isInitialized() {
            return DirtyStateEditorSupport.this.dirtyResource.isInitialized();
        }

        @Override
        public IResourceDescription getDescriptionIfInitialized() {
            return DirtyStateEditorSupport.this.dirtyResource.getDescriptionIfInitialized();
        }

        @Override
        public String getActualContentsIfInitialized() {
            return DirtyStateEditorSupport.this.dirtyResource.getActualContentsIfInitialized();
        }

        @Override
        public String getContentsIfInitialized() {
            return DirtyStateEditorSupport.this.dirtyResource.getContentsIfInitialized();
        }
    }

    @ImplementedBy(value=InteractiveConcurrentEditingQuestion.class)
    public static interface IConcurrentEditingCallback {
        public boolean isConcurrentEditingIgnored(IDirtyStateEditorSupportClient var1);
    }

    public static interface IDirtyStateEditorSupportClient {
        public IXtextDocument getDocument();

        public boolean isDirty();

        public Shell getShell();

        public void addVerifyListener(VerifyListener var1);

        public void removeVerifyListener(VerifyListener var1);
    }

    public static interface IDirtyStateEditorSupportClientExtension {
        public void forceReconcile();
    }

    public static class InteractiveConcurrentEditingQuestion
    implements IConcurrentEditingCallback {
        @Override
        public boolean isConcurrentEditingIgnored(IDirtyStateEditorSupportClient client) {
            String title = Messages.DirtyStateEditorSupport_ConcurrentChangeDialog_Title;
            String message = Messages.DirtyStateEditorSupport_ConcurrentChangeDialog_Message;
            return MessageDialog.openQuestion((Shell)client.getShell(), (String)title, (String)message);
        }
    }

    protected class UpdateEditorStateJob
    extends Job {
        private AtomicInteger coarseGrainedChanges;
        private Queue<IResourceDescription.Delta> pendingChanges;

        protected UpdateEditorStateJob(ISchedulingRule rule) {
            this(rule, Messages.DirtyStateEditorSupport_JobName);
        }

        protected UpdateEditorStateJob(ISchedulingRule rule, String name) {
            super(name);
            this.setRule(rule);
            this.coarseGrainedChanges = new AtomicInteger();
            this.pendingChanges = new ConcurrentLinkedQueue<IResourceDescription.Delta>();
        }

        protected void scheduleFor(IResourceDescription.Event event) {
            this.cancel();
            if (event instanceof IResourceDescription.CoarseGrainedEvent) {
                this.coarseGrainedChanges.incrementAndGet();
            } else {
                this.pendingChanges.addAll((Collection<IResourceDescription.Delta>)event.getDeltas());
            }
            this.schedule(this.getDelay());
        }

        protected int getDelay() {
            return 500;
        }

        protected Pair<IResourceDescription.Event, Integer> mergePendingDeltas() {
            LinkedHashMap uriToDelta = Maps.newLinkedHashMap();
            Iterator iter = this.pendingChanges.iterator();
            int size = 0;
            while (iter.hasNext()) {
                IResourceDescription.Delta delta = (IResourceDescription.Delta)iter.next();
                URI uri = delta.getUri();
                IResourceDescription.Delta prev = (IResourceDescription.Delta)uriToDelta.get(uri);
                if (prev == null) {
                    uriToDelta.put(uri, delta);
                } else if (prev.getOld() != delta.getNew()) {
                    uriToDelta.put(uri, DirtyStateEditorSupport.this.createDelta(delta, prev));
                } else {
                    uriToDelta.remove(uri);
                }
                ++size;
            }
            ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(uriToDelta.values());
            return Tuples.create((Object)event, (Object)size);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            try {
                IDirtyStateEditorSupportClient myClient = DirtyStateEditorSupport.this.currentClient;
                if (myClient == null) {
                    return Status.OK_STATUS;
                }
                IXtextDocument document = myClient.getDocument();
                if (document == null) {
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int coarseGrainedChangesSeen = this.coarseGrainedChanges.get();
                final boolean[] isReparseRequired = new boolean[]{coarseGrainedChangesSeen > 0};
                final Pair<IResourceDescription.Event, Integer> event = this.mergePendingDeltas();
                Collection affectedResources = (Collection)document.readOnly((IUnitOfWork)new IUnitOfWork<Collection<Resource>, XtextResource>(){

                    public Collection<Resource> exec(XtextResource resource) throws Exception {
                        if (resource == null || resource.getResourceSet() == null) {
                            return null;
                        }
                        Collection<Resource> affectedResources = DirtyStateEditorSupport.this.collectAffectedResources(resource, (IResourceDescription.Event)event.getFirst());
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (!affectedResources.isEmpty()) {
                            return affectedResources;
                        }
                        if (!isReparseRequired[0]) {
                            isReparseRequired[0] = DirtyStateEditorSupport.this.isReparseRequired(resource, (IResourceDescription.Event)event.getFirst());
                        }
                        return affectedResources;
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.unloadAffectedResourcesAndReparseDocument(document, affectedResources, isReparseRequired[0]);
                int i = 0;
                while (i < (Integer)event.getSecond()) {
                    this.pendingChanges.poll();
                    ++i;
                }
                this.coarseGrainedChanges.addAndGet(-coarseGrainedChangesSeen);
                return Status.OK_STATUS;
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
            catch (OperationCanceledError e) {
                return Status.CANCEL_STATUS;
            }
            catch (Throwable e) {
                return new Status(4, "org.eclipse.xtext.ui", "Error updating dirty state editor", e);
            }
        }

        private void unloadAffectedResourcesAndReparseDocument(final IXtextDocument document, final Collection<Resource> affectedResources, boolean reparseRequired) {
            if ((affectedResources == null || affectedResources.isEmpty()) && !reparseRequired) {
                return;
            }
            Assert.isLegal((boolean)(document instanceof XtextDocument));
            XtextDocument xtextDocument = (XtextDocument)document;
            xtextDocument.internalModify(new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    if (resource == null || resource.getResourceSet() == null) {
                        return;
                    }
                    ResourceSet resourceSet = resource.getResourceSet();
                    if (affectedResources != null) {
                        for (Resource affectedResource : affectedResources) {
                            affectedResource.unload();
                            resourceSet.getResources().remove((Object)affectedResource);
                        }
                    }
                    if (DirtyStateEditorSupport.this.currentClient instanceof IDirtyStateEditorSupportClientExtension) {
                        ((IDirtyStateEditorSupportClientExtension)((Object)DirtyStateEditorSupport.this.currentClient)).forceReconcile();
                    } else {
                        resource.reparse(document.get());
                    }
                }
            });
        }
    }
}

