/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ObservableTypeComputationStateWithExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ObservableTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.MergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameter;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;
import org.eclipse.xtext.xtype.XComputedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkingCandidateWithTypeParameter<LinkingCandidate extends ILinkingCandidate<LinkingCandidate>>
extends AbstractLinkingCandidate<LinkingCandidate>
implements ObservableTypeExpectation.Observer {
    private final ListMultimap<JvmTypeParameter, BoundTypeArgument> typeParameterMapping = ArrayListMultimap.create((int)2, (int)2);

    protected AbstractLinkingCandidateWithTypeParameter(XExpression expression, IEObjectDescription description, AbstractTypeComputationState state) {
        super(expression, description, state);
    }

    @Override
    public void accept(ObservableTypeExpectation expectation, JvmTypeReference actual, ConformanceHint conformanceHint) {
        JvmTypeReference expectedType = expectation.getExpectedType();
        if (expectedType == null) {
            return;
        }
        if (expectedType instanceof XComputedTypeReference) {
            XComputedTypeReference computedTypeReference = (XComputedTypeReference)expectedType;
            if (computedTypeReference.getTypeProvider() instanceof UnboundTypeParameter) {
                UnboundTypeParameter unboundTypeParameter = (UnboundTypeParameter)computedTypeReference.getTypeProvider();
                JvmTypeReference wrappedActual = this.asWrapperType(actual);
                unboundTypeParameter.acceptHint(wrappedActual);
            }
        } else if (expectedType.getType() instanceof JvmTypeParameter) {
            if (!(actual instanceof JvmAnyTypeReference)) {
                JvmTypeReference wrappedActual = this.asWrapperType(actual);
                this.typeParameterMapping.put((Object)((JvmTypeParameter)expectedType.getType()), (Object)new BoundTypeArgument(wrappedActual, BoundTypeArgumentSource.INFERRED, new Object(), VarianceInfo.OUT, VarianceInfo.OUT));
            }
        } else {
            this.resolveAgainstActualType(expectedType, actual);
        }
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmTypeParameterDeclarator) {
            return ((JvmTypeParameterDeclarator)feature).getTypeParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public void apply() {
        JvmIdentifiableElement feature = this.getFeature();
        JvmTypeReference featureType = this.getDeclaredType(feature);
        this.getState().getResolvedTypes().acceptLinkingInformation(this.getExpression(), this);
        this.computeArgumentTypes(feature, featureType);
        List<ITypeExpectation> expectations = this.getState().getImmediateExpectations();
        for (ITypeExpectation expectation : expectations) {
            TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(this.getDeclaratorParameterMapping(), this.getState().getServices()){

                @Override
                public JvmTypeReference doVisitComputedTypeReference(XComputedTypeReference reference, Set<JvmTypeParameter> param) {
                    if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                        XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
                        result.setTypeProvider(reference.getTypeProvider());
                        return result;
                    }
                    return (JvmTypeReference)super.doVisitComputedTypeReference(reference, param);
                }

                @Override
                protected JvmTypeReference getUnmappedSubstitute(JvmParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
                    XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
                    result.setTypeProvider(new UnboundTypeParameter(AbstractLinkingCandidateWithTypeParameter.this.getExpression(), type, this.getServices()));
                    return result;
                }
            };
            substitutor.enhanceMapping(this.getFeatureTypeParameterMapping());
            JvmTypeReference substitute = ((TypeParameterSubstitutor)substitutor).substitute(featureType);
            this.deferredBindTypeArguments(expectation, substitute);
            expectation.acceptActualType(substitute, ConformanceHint.UNCHECKED);
        }
    }

    @Override
    protected void computeArgumentTypes(JvmIdentifiableElement feature, JvmTypeReference featureType) {
        int i;
        int declaredParameterCount = 0;
        int fixedArityParameterCount = 0;
        EList parameters = null;
        boolean varArgs = false;
        if (feature instanceof JvmExecutable) {
            JvmExecutable executable = (JvmExecutable)feature;
            declaredParameterCount = executable.getParameters().size();
            varArgs = executable.isVarArgs();
            fixedArityParameterCount = varArgs ? declaredParameterCount - 1 : declaredParameterCount;
            parameters = executable.getParameters();
        }
        List<XExpression> arguments = this.getArguments();
        int fixedArityArgumentCount = Math.min(fixedArityParameterCount, arguments.size());
        ArrayList stackedResolvedTypes = Lists.newArrayListWithCapacity((int)arguments.size());
        if (parameters != null) {
            i = 0;
            while (i < fixedArityArgumentCount) {
                JvmFormalParameter parameter = (JvmFormalParameter)parameters.get(i);
                JvmTypeReference parameterType = parameter.getParameterType();
                XExpression argument = arguments.get(i);
                LazyExpectation expectation = new LazyExpectation(parameterType);
                ObservableTypeComputationStateWithExpectation argumentState = new ObservableTypeComputationStateWithExpectation(this.getState().getResolvedTypes(), this.getState().getFeatureScopeSession(), this.getState().getResolver(), this.getState(), expectation, this);
                stackedResolvedTypes.add(this.resolveArgumentType(argument, parameterType, argumentState));
                ++i;
            }
            if (varArgs) {
                int lastParamIndex = declaredParameterCount - 1;
                JvmTypeReference lastParameterType = ((JvmFormalParameter)parameters.get(lastParamIndex)).getParameterType();
                if (!(lastParameterType instanceof JvmGenericArrayTypeReference)) {
                    throw new IllegalStateException("Unexpected var arg type: " + lastParameterType);
                }
                JvmTypeReference componentType = ((JvmGenericArrayTypeReference)lastParameterType).getComponentType();
                LazyExpectation expectation = new LazyExpectation(componentType);
                ObservableTypeComputationStateWithExpectation argumentState = null;
                argumentState = arguments.size() == declaredParameterCount ? new ObservableTypeComputationStateWithExpectation(this.getState().getResolvedTypes(), this.getState().getFeatureScopeSession(), this.getState().getResolver(), this.getState(), expectation, this) : new ObservableTypeComputationStateWithExpectation(this.getState().getResolvedTypes(), this.getState().getFeatureScopeSession(), this.getState().getResolver(), this.getState(), expectation, this);
                int i2 = fixedArityArgumentCount;
                while (i2 < arguments.size()) {
                    XExpression argument = arguments.get(i2);
                    stackedResolvedTypes.add(this.resolveArgumentType(argument, null, argumentState));
                    ++i2;
                }
            }
        }
        if (!varArgs) {
            i = fixedArityArgumentCount;
            while (i < arguments.size()) {
                XExpression argument = arguments.get(i);
                stackedResolvedTypes.add(this.resolveArgumentType(argument, null, this.getState().fork().withNonVoidExpectation()));
                ++i;
            }
        }
        for (StackedResolvedTypes pending : stackedResolvedTypes) {
            pending.mergeIntoParent();
        }
    }

    protected void resolveAgainstActualType(JvmTypeReference declaredType, JvmTypeReference actualType) {
        EList typeParameters;
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmTypeParameterDeclarator && !(typeParameters = ((JvmTypeParameterDeclarator)feature).getTypeParameters()).isEmpty()) {
            UnboundTypeParameterAwareTypeArgumentCollector implementation = new UnboundTypeParameterAwareTypeArgumentCollector((List<JvmTypeParameter>)typeParameters, this.getState().getServices());
            implementation.populateTypeParameterMapping(declaredType, actualType);
            this.typeParameterMapping.putAll(implementation.rawGetTypeParameterMapping());
        }
    }

    protected Map<JvmTypeParameter, JvmTypeReference> getFeatureTypeParameterMapping() {
        HashMap consolidatedMap = Maps.newHashMap();
        for (JvmTypeParameter typeParameter : this.typeParameterMapping.keySet()) {
            List boundTypeArguments = this.typeParameterMapping.get((Object)typeParameter);
            MergedBoundTypeArgument mergedTypeArguments = this.getState().getTypeArgumentMerger().merge(boundTypeArguments);
            if (mergedTypeArguments == null) continue;
            consolidatedMap.put(typeParameter, mergedTypeArguments.getTypeReference());
        }
        return consolidatedMap;
    }

    protected class LazyExpectation
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmTypeReference declaredType;
        private final UnboundTypeParameterPreservingSubstitutor substitutor;

        protected LazyExpectation(JvmTypeReference declaredType) {
            this.declaredType = declaredType;
            this.substitutor = new UnboundTypeParameterPreservingSubstitutor(AbstractLinkingCandidateWithTypeParameter.this.getDeclaratorParameterMapping(), AbstractLinkingCandidateWithTypeParameter.this.getState().getServices());
            this.substitutor.enhanceMapping(AbstractLinkingCandidateWithTypeParameter.this.getFeatureTypeParameterMapping());
        }

        protected JvmTypeReference doGetTypeReference() {
            JvmTypeReference substitute = this.substitutor.substitute(this.declaredType);
            return substitute;
        }
    }
}

