/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.util.LazyStringInputStream;

public class ExternalContentSupport
implements IExternalContentSupport {
    public void configureResourceSet(ResourceSet resourceSet, IExternalContentSupport.IExternalContentProvider contentProvider) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null");
        }
        if (contentProvider == null) {
            throw new IllegalArgumentException("contentProvider may not be null");
        }
        this.configureConverter(resourceSet.getURIConverter(), contentProvider);
    }

    public void configureConverter(URIConverter converter, IExternalContentSupport.IExternalContentProvider contentProvider) {
        EList uriHandlers = converter.getURIHandlers();
        ListIterator<ExternalContentAwareURIHandler> iter = uriHandlers.listIterator();
        while (iter.hasNext()) {
            ExternalContentAwareURIHandler transformed = new ExternalContentAwareURIHandler((URIHandler)iter.next(), contentProvider);
            iter.set(transformed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExternalContentAwareURIHandler
    implements URIHandler {
        private URIHandler delegate;
        private final IExternalContentSupport.IExternalContentProvider contentProvider;

        public ExternalContentAwareURIHandler(URIHandler delegate, IExternalContentSupport.IExternalContentProvider contentProvider) {
            this.delegate = delegate;
            this.contentProvider = contentProvider;
        }

        public boolean canHandle(URI uri) {
            return this.delegate.canHandle(uri);
        }

        public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
            return this.delegate.contentDescription(uri, options);
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            if (this.contentProvider.hasContent(uri)) {
                return new LazyStringInputStream(this.contentProvider.getContent(uri), Charsets.UTF_8);
            }
            return this.delegate.createInputStream(uri, options);
        }

        public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
            return this.delegate.createOutputStream(uri, options);
        }

        public void delete(URI uri, Map<?, ?> options) throws IOException {
            this.delegate.delete(uri, options);
        }

        public boolean exists(URI uri, Map<?, ?> options) {
            return this.contentProvider.hasContent(uri) || this.delegate.exists(uri, options);
        }

        public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
            return this.delegate.getAttributes(uri, options);
        }

        public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
            this.delegate.setAttributes(uri, attributes, options);
        }
    }
}

