/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.imports.ImportOrganizer;
import org.eclipse.xtext.xbase.ui.imports.Messages;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;

public class OrganizeImportsHandler
extends AbstractHandler {
    private static final Logger LOG = Logger.getLogger(OrganizeImportsHandler.class);
    @Inject
    private ImportOrganizer importOrganizer;
    @Inject
    private ReplaceConverter replaceConverter;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            IXtextDocument document = editor.getDocument();
            this.doOrganizeImports(document);
        }
        return null;
    }

    public void doOrganizeImports(IXtextDocument document) {
        List result = (List)document.priorityReadOnly((IUnitOfWork)new IUnitOfWork<List<ReplaceRegion>, XtextResource>(){

            public List<ReplaceRegion> exec(XtextResource state) throws Exception {
                return OrganizeImportsHandler.this.importOrganizer.getOrganizedImportChanges(state);
            }
        });
        if (result == null) {
            return;
        }
        try {
            DocumentRewriteSession session = null;
            if (document instanceof IDocumentExtension4) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            this.replaceConverter.convertToTextEdit(result).apply((IDocument)document);
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
        catch (BadLocationException e) {
            LOG.error((Object)Messages.OrganizeImportsHandler_organizeImportsErrorMessage, (Throwable)e);
        }
    }
}

