/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.tika.language.ProfilingWriter;

public class LanguageProfile {
    public static final int DEFAULT_NGRAM_LENGTH = 3;
    private final int length;
    private final Map<String, Counter> ngrams = new HashMap<String, Counter>();
    private long count = 0L;

    public LanguageProfile(int length) {
        this.length = length;
    }

    public LanguageProfile() {
        this(3);
    }

    public LanguageProfile(String content, int length) {
        this(length);
        ProfilingWriter writer = new ProfilingWriter(this);
        char[] ch = content.toCharArray();
        writer.write(ch, 0, ch.length);
    }

    public LanguageProfile(String content) {
        this(content, 3);
    }

    public long getCount() {
        return this.count;
    }

    public long getCount(String ngram) {
        Counter counter = this.ngrams.get(ngram);
        if (counter != null) {
            return counter.count;
        }
        return 0L;
    }

    public void add(String ngram) {
        this.add(ngram, 1L);
    }

    public void add(String ngram, long count) {
        if (this.length != ngram.length()) {
            throw new IllegalArgumentException("Unable to add an ngram of incorrect length: " + ngram.length() + " != " + this.length);
        }
        Counter counter = this.ngrams.get(ngram);
        if (counter == null) {
            counter = new Counter();
            this.ngrams.put(ngram, counter);
        }
        Counter counter2 = counter;
        counter2.count = counter2.count + count;
        this.count += count;
    }

    public double distance(LanguageProfile that) {
        if (this.length != that.length) {
            throw new IllegalArgumentException("Unable to calculage distance of language profiles with different ngram lengths: " + that.length + " != " + this.length);
        }
        double sumOfSquares = 0.0;
        double thisCount = Math.max((double)this.count, 1.0);
        double thatCount = Math.max((double)that.count, 1.0);
        HashSet<String> ngrams = new HashSet<String>();
        ngrams.addAll(this.ngrams.keySet());
        ngrams.addAll(that.ngrams.keySet());
        for (String ngram : ngrams) {
            double thisFrequency = (double)this.getCount(ngram) / thisCount;
            double thatFrequency = (double)that.getCount(ngram) / thatCount;
            double difference = thisFrequency - thatFrequency;
            sumOfSquares += difference * difference;
        }
        return Math.sqrt(sumOfSquares);
    }

    public String toString() {
        return this.ngrams.toString();
    }

    private static class Counter {
        private long count = 0L;

        private Counter() {
        }

        public String toString() {
            return Long.toString(this.count);
        }
    }
}

