/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;

public class DefaultParser
extends CompositeParser {
    private static final long serialVersionUID = 3612324825403757520L;
    private final transient ServiceLoader loader;

    private static List<Parser> getDefaultParsers(ServiceLoader loader) {
        List<Parser> parsers = loader.loadStaticServiceProviders(Parser.class);
        Collections.sort(parsers, new Comparator<Parser>(){

            @Override
            public int compare(Parser p1, Parser p2) {
                boolean t2;
                String n1 = p1.getClass().getName();
                String n2 = p2.getClass().getName();
                boolean t1 = n1.startsWith("org.apache.tika.");
                if (t1 == (t2 = n2.startsWith("org.apache.tika."))) {
                    return n1.compareTo(n2);
                }
                if (t1) {
                    return -1;
                }
                return 1;
            }
        });
        return parsers;
    }

    public DefaultParser(MediaTypeRegistry registry, ServiceLoader loader) {
        super(registry, DefaultParser.getDefaultParsers(loader));
        this.loader = loader;
    }

    public DefaultParser(MediaTypeRegistry registry, ClassLoader loader) {
        this(registry, new ServiceLoader(loader));
    }

    public DefaultParser(ClassLoader loader) {
        this(MediaTypeRegistry.getDefaultRegistry(), new ServiceLoader(loader));
    }

    public DefaultParser(MediaTypeRegistry registry) {
        this(registry, new ServiceLoader());
    }

    public DefaultParser() {
        this(MediaTypeRegistry.getDefaultRegistry());
    }

    @Override
    public Map<MediaType, Parser> getParsers(ParseContext context) {
        Map<MediaType, Parser> map = super.getParsers(context);
        if (this.loader != null) {
            MediaTypeRegistry registry = this.getMediaTypeRegistry();
            List<Parser> parsers = this.loader.loadDynamicServiceProviders(Parser.class);
            Collections.reverse(parsers);
            for (Parser parser : parsers) {
                for (MediaType type : parser.getSupportedTypes(context)) {
                    map.put(registry.normalize(type), parser);
                }
            }
        }
        return map;
    }
}

