/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.NoOpDocumentBuilder;

public class SourceBlocks
extends SourceBlock {
    private final List<SourceBlock> supportedBlocks;

    public SourceBlocks(SourceBlock ... blocks) {
        this(Arrays.asList((Object[])Objects.requireNonNull(blocks)));
    }

    SourceBlocks(List<SourceBlock> supportedBlocks) {
        this.supportedBlocks = ImmutableList.copyOf(supportedBlocks);
    }

    public void createContext(ProcessingContextBuilder contextBuilder, LineSequence lineSequence, Predicate<BlockContext> contextPredicate) {
        this.process(lineSequence, (LineSequence lineSequence1, SourceBlock sourceBlock) -> sourceBlock.createContext(contextBuilder, lineSequence1), contextPredicate);
    }

    @Override
    public void createContext(ProcessingContextBuilder contextBuilder, LineSequence lineSequence) {
        this.createContext(contextBuilder, lineSequence, (Predicate<BlockContext>)Predicates.alwaysTrue());
    }

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        this.process(context, builder, lineSequence, (Predicate<BlockContext>)Predicates.alwaysTrue());
    }

    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence, Predicate<BlockContext> predicate) {
        this.process(lineSequence, (LineSequence lineSequence1, SourceBlock sourceBlock) -> sourceBlock.process(context, builder, lineSequence1), predicate);
    }

    public List<SourceBlock> calculateSourceBlocks(ProcessingContext context, LineSequence lineSequence, Predicate<BlockContext> predicate) {
        ArrayList<SourceBlock> sourceBlocks = new ArrayList<SourceBlock>();
        NoOpDocumentBuilder builder = new NoOpDocumentBuilder();
        this.process(lineSequence, (LineSequence lineSequence1, SourceBlock sourceBlock) -> {
            sourceBlocks.add(sourceBlock);
            sourceBlock.process(context, (DocumentBuilder)builder, lineSequence1);
        }, predicate);
        return sourceBlocks;
    }

    private void process(LineSequence lineSequence, SourceBlockRunnable runnable, Predicate<BlockContext> predicate) {
        SourceBlock currentBlock = null;
        SourceBlock previousBlock = null;
        while (lineSequence.getCurrentLine() != null && predicate.apply((Object)new BlockContext(previousBlock = currentBlock, currentBlock = this.selectBlock(lineSequence), lineSequence))) {
            if (currentBlock != null) {
                runnable.run(lineSequence, currentBlock);
                continue;
            }
            lineSequence.advance();
        }
    }

    public SourceBlock selectBlock(LineSequence lineSequence) {
        for (SourceBlock candidate : this.supportedBlocks) {
            if (!candidate.canStart(lineSequence)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        return true;
    }

    private static interface SourceBlockRunnable {
        public void run(LineSequence var1, SourceBlock var2);
    }

    public static class BlockContext {
        private final SourceBlock currentBlock;
        private final LineSequence lineSequence;
        private final SourceBlock previousBlock;

        public BlockContext(SourceBlock previousBlock, SourceBlock currentBlock, LineSequence lineSequence) {
            this.previousBlock = previousBlock;
            this.currentBlock = currentBlock;
            this.lineSequence = lineSequence;
        }

        public SourceBlock getPreviousBlock() {
            return this.previousBlock;
        }

        public SourceBlock getCurrentBlock() {
            return this.currentBlock;
        }

        public LineSequence getLineSequence() {
            return this.lineSequence;
        }
    }
}

