/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.UrlEscapers;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Characters;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Link;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class AutoLinkSpan
extends SourceSpan {
    private static final Set<String> SCHEMES = ImmutableSet.of((Object)"coap", (Object)"doi", (Object)"javascript", (Object)"aaa", (Object)"aaas", (Object)"about", (Object[])new String[]{"acap", "cap", "cid", "crid", "data", "dav", "dict", "dns", "file", "ftp", "geo", "go", "gopher", "h323", "http", "https", "iax", "icap", "im", "imap", "info", "ipp", "iris", "iris.beep", "iris.xpc", "iris.xpcs", "iris.lwz", "ldap", "mailto", "mid", "msrp", "msrps", "mtqp", "mupdate", "news", "nfs", "ni", "nih", "nntp", "opaquelocktoken", "pop", "pres", "rtsp", "service", "session", "shttp", "sieve", "sip", "sips", "sms", "snmp", "soap.beep", "soap.beeps", "tag", "tel", "telnet", "tftp", "thismessage", "tn3270", "tip", "tv", "urn", "vemmi", "ws", "wss", "xcon", "xcon-userid", "xmlrpc.beep", "xmlrpc.beeps", "xmpp", "z39.50r", "z39.50s", "adiumxtra", "afp", "afs", "aim", "apt", "attachment", "aw", "beshare", "bitcoin", "bolo", "callto", "chrome", "chrome-extension", "com-eventbrite-attendee", "content", "cvs", "dlna-playsingle", "dlna-playcontainer", "dtn", "dvb", "ed2k", "facetime", "feed", "finger", "fish", "gg", "git", "gizmoproject", "gtalk", "hcp", "icon", "ipn", "irc", "irc6", "ircs", "itms", "jar", "jms", "keyparc", "lastfm", "ldaps", "magnet", "maps", "market,message", "mms", "ms-help", "msnim", "mumble", "mvn", "notes", "oid", "palm", "paparazzi", "platform", "proxy", "psyc", "query", "res", "resource", "rmi", "rsync", "rtmp", "secondlife", "sftp", "sgn", "skype", "smb", "soldat", "spotify", "ssh", "steam", "svn", "teamspeak", "things", "udp", "unreal", "ut2004", "ventrilo", "view-source", "webcal", "wtai", "wyciwyg", "xfire", "xri", "ymsgr"});
    private static final String EMAIL_DOMAIN_PART = "[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?";
    private static final String EMAIL_REGEX = "[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*";
    private final Pattern linkPattern = this.createLinkPattern();

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '<' && (matcher = cursor.matcher(this.linkPattern)).matches()) {
            String href;
            String link = href = matcher.group(1);
            String email = matcher.group(2);
            if (email != null) {
                link = "mailto:" + email;
            }
            int endOffset = cursor.getOffset(matcher.end(3));
            int linkLength = endOffset - cursor.getOffset();
            return Optional.of(new Link(cursor.getLineAtOffset(), cursor.getOffset(), linkLength, this.escapeUri(link), null, (List<Inline>)ImmutableList.of((Object)new Characters(cursor.getLineAtOffset(), cursor.getOffset() + 1, linkLength - 2, href))));
        }
        return Optional.empty();
    }

    private String escapeUri(String link) {
        return UrlEscapers.urlFragmentEscaper().escape(link).replace("%23", "#").replace("%25", "%");
    }

    private Pattern createLinkPattern() {
        String regex = "";
        for (String scheme : SCHEMES) {
            regex = regex.isEmpty() ? regex + "<((?:(?:" : regex + "|";
            regex = regex + scheme.replace(".", "\\.");
        }
        regex = regex + "):[^\\s>]+)|([a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*))(>).*";
        return Pattern.compile(regex, 34);
    }
}

