/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Characters;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Image;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineWithNestedContents;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineWithText;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Link;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.PotentialBracketDelimiter;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.ReferenceDefinition;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.EntityReferences;

public class PotentialBracketEndDelimiter
extends InlineWithText {
    private static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("(&([a-zA-Z][a-zA-Z0-9]{1,32}|#x[a-fA-F0-9]{1,8}|#[0-9]{1,8});)");
    static final String ESCAPABLE_CHARACTER_GROUP = "[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]";
    static final String ESCAPED_CHARS = "(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])";
    static final String CAPTURING_ESCAPED_CHARS = "\\\\([!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])";
    static final String PARENS_TITLE_PART = "(?:\\(((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\\)])*)\\))";
    static final String SINGLE_QUOTED_TITLE_PART = "(?:'((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^'])*)')";
    static final String QUOTED_TITLE_PART = "(?:\"((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\"])*)\")";
    static final String BRACKET_URI_PART = "<((?:[^<>\\\\\r\n]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*?)>";
    private static final String IN_PARENS = "\\((?:[^\\\\()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*\\)";
    static final String NOBRACKET_URI_PART = "((?:[^\\\\\\s()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|\\((?:[^\\\\()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*\\)|\\\\)+)";
    static final String URI_PART = "(?:<((?:[^<>\\\\\r\n]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*?)>|((?:[^\\\\\\s()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|\\((?:[^\\\\()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*\\)|\\\\)+))";
    static final String TITLE_PART = "(?:(?:\"((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\"])*)\")|(?:'((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^'])*)')|(?:\\(((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\\)])*)\\)))";
    final Pattern endPattern = Pattern.compile("\\(\\s*(?:<((?:[^<>\\\\\r\n]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*?)>|((?:[^\\\\\\s()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|\\((?:[^\\\\()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*\\)|\\\\)+))?(?:\\s+(?:(?:\"((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\"])*)\")|(?:'((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^'])*)')|(?:\\(((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\\)])*)\\))))?\\s*\\)(.*)", 32);
    final Pattern referenceLabelPattern = Pattern.compile("(\\s*\\[((?:[^\\]]|\\\\]){0,1000})]).*", 32);
    final Pattern referenceDefinitionEndPattern = Pattern.compile(":\\s*(?:<((?:[^<>\\\\\r\n]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*?)>|((?:[^\\\\\\s()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|\\((?:[^\\\\()]|(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-]))*\\)|\\\\)+))?(?:\\s+(?:(?:\"((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\"])*)\")|(?:'((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^'])*)')|(?:\\(((?:(?:\\\\[!\"\\\\#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~-])|[^\\)])*)\\))))?\\s*(.*)", 32);

    public PotentialBracketEndDelimiter(Line line, int offset) {
        super(line, offset, 1, "]");
    }

    @Override
    public void emit(DocumentBuilder builder) {
        builder.characters(this.text);
    }

    @Override
    public void apply(ProcessingContext context, List<Inline> inlines, Cursor cursor) {
        Optional<PotentialBracketDelimiter> previousDelimiter = this.findLastPotentialBracketDelimiter(inlines);
        if (previousDelimiter.isPresent()) {
            boolean referenceDefinition;
            PotentialBracketDelimiter openingDelimiter = previousDelimiter.get();
            int indexOfOpeningDelimiter = inlines.indexOf(openingDelimiter);
            boolean bl = referenceDefinition = cursor.hasNext() && cursor.getNext() == ':' && this.eligibleForReferenceDefinition(openingDelimiter, cursor);
            Matcher matcher = cursor.hasNext() ? cursor.matcher(1, referenceDefinition ? this.referenceDefinitionEndPattern : this.endPattern) : null;
            List<Inline> contents = InlineParser.secondPass(inlines.subList(indexOfOpeningDelimiter + 1, inlines.size()));
            if (!openingDelimiter.isLinkDelimiter() || !this.containsLink(contents)) {
                if (!cursor.hasNext() || !Objects.requireNonNull(matcher).matches()) {
                    ProcessingContext.NamedUriWithTitle uriWithTitle;
                    Matcher referenceLabelMatcher;
                    String referenceName = this.toReferenceName(this.referenceName(cursor, contents));
                    int size = 1;
                    if (cursor.hasNext() && (referenceLabelMatcher = cursor.matcher(1, this.referenceLabelPattern)).matches()) {
                        String label = referenceLabelMatcher.group(2);
                        if (!label.isEmpty()) {
                            referenceName = this.toReferenceName(label);
                        }
                        size = referenceLabelMatcher.end(1) - referenceLabelMatcher.start(1) + 1;
                    }
                    ProcessingContext.NamedUriWithTitle namedUriWithTitle = uriWithTitle = referenceName == null ? null : context.namedUriWithTitle(referenceName);
                    if (uriWithTitle != null) {
                        cursor.advance(size);
                        this.truncate(inlines, indexOfOpeningDelimiter);
                        int length = this.getOffset() - openingDelimiter.getOffset();
                        if (openingDelimiter.isLinkDelimiter()) {
                            inlines.add(new Link(openingDelimiter.getLine(), openingDelimiter.getOffset(), length, uriWithTitle.getUri(), uriWithTitle.getTitle(), contents));
                        } else {
                            inlines.add(new Image(openingDelimiter.getLine(), openingDelimiter.getOffset(), length, uriWithTitle.getUri(), uriWithTitle.getTitle(), contents));
                        }
                        return;
                    }
                } else {
                    String uri = this.linkUri(matcher);
                    String title = this.linkTitle(matcher);
                    if (!referenceDefinition || !Strings.isNullOrEmpty((String)uri) && !this.hasContentOnSameLine(matcher, cursor)) {
                        String referenceName = null;
                        if (referenceDefinition) {
                            referenceName = this.toReferenceName(this.referenceName(cursor, contents));
                        }
                        if (referenceDefinition && referenceName != null || !referenceDefinition) {
                            int closingLength = matcher.start(6) - matcher.start() + 1;
                            cursor.advance(closingLength);
                            int length = this.getOffset() - openingDelimiter.getOffset() + closingLength;
                            this.truncate(inlines, indexOfOpeningDelimiter);
                            if (referenceDefinition) {
                                this.truncatePrecedingWhitespace(inlines, 3);
                                inlines.add(new ReferenceDefinition(openingDelimiter.getLine(), openingDelimiter.getOffset(), length, uri, title, referenceName));
                            } else if (openingDelimiter.isImageDelimiter()) {
                                inlines.add(new Image(openingDelimiter.getLine(), openingDelimiter.getOffset(), length, uri, title, contents));
                            } else {
                                inlines.add(new Link(openingDelimiter.getLine(), openingDelimiter.getOffset(), length, uri, title, contents));
                            }
                            return;
                        }
                    }
                }
            }
            this.replaceDelimiter(inlines, indexOfOpeningDelimiter, openingDelimiter);
        }
        this.applyCharacters(context, inlines, cursor);
    }

    private String referenceName(Cursor cursor, List<Inline> contents) {
        if (contents.isEmpty()) {
            return "";
        }
        int start = cursor.toCursorOffset(contents.get(0).getOffset());
        int end = cursor.toCursorOffset(this.getOffset());
        return cursor.getText(start, end);
    }

    private boolean containsLink(List<Inline> contents) {
        for (Inline inline : contents) {
            if (inline instanceof Link) {
                return true;
            }
            if (!(inline instanceof InlineWithNestedContents) || !this.containsLink(((InlineWithNestedContents)inline).getContents())) continue;
            return true;
        }
        return false;
    }

    private void replaceDelimiter(List<Inline> inlines, int index, PotentialBracketDelimiter delimiter) {
        inlines.set(index, new Characters(delimiter.getLine(), delimiter.getOffset(), delimiter.getLength(), delimiter.getText()));
    }

    private boolean hasContentOnSameLine(Matcher matcher, Cursor cursor) {
        int indexOfContent = matcher.start(6);
        if (indexOfContent == -1 || matcher.end(6) == indexOfContent) {
            return false;
        }
        int startIndex = this.titleEndIndex(matcher);
        if (startIndex == 0 && (startIndex = matcher.end(3)) == -1) {
            startIndex = matcher.end(2);
        }
        if (startIndex > 0) {
            for (int x = startIndex; x < indexOfContent; ++x) {
                char c = cursor.getChar(x);
                if (c == '\n') {
                    return false;
                }
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void truncatePrecedingWhitespace(List<Inline> inlines, int length) {
        Characters characters;
        Inline last;
        if (!inlines.isEmpty() && (last = inlines.get(inlines.size() - 1)) instanceof Characters && (characters = (Characters)last).getText().length() <= length && CharMatcher.whitespace().matchesAllOf((CharSequence)characters.getText())) {
            inlines.remove(inlines.size() - 1);
        }
    }

    public void truncate(List<Inline> inlines, int indexOfOpeningDelimiter) {
        while (inlines.size() > indexOfOpeningDelimiter) {
            inlines.remove(indexOfOpeningDelimiter);
        }
    }

    boolean eligibleForReferenceDefinition(PotentialBracketDelimiter openingDelimiter, Cursor cursor) {
        boolean linkDelimiter = openingDelimiter.isLinkDelimiter();
        if (!linkDelimiter) {
            return false;
        }
        int cursorRelativeOffset = cursor.toCursorOffset(openingDelimiter.getOffset());
        for (int x = cursorRelativeOffset - 1; x >= 0; --x) {
            char c = cursor.getChar(x);
            if (c == '\n') {
                return true;
            }
            if (c != ' ') {
                return false;
            }
            if (cursorRelativeOffset - x != 4) continue;
            return false;
        }
        int cursorRelativeEndOffset = cursor.toCursorOffset(this.getOffset());
        for (int x = cursorRelativeOffset + 1; x < cursorRelativeEndOffset; ++x) {
            char c = cursor.getChar(x);
            if (c != '[' || this.precededByBackslashEscape(cursor, x)) continue;
            return false;
        }
        return true;
    }

    boolean precededByBackslashEscape(Cursor cursor, int originalOffset) {
        char c;
        int count = 0;
        for (int index = originalOffset - 1; index >= 0 && (c = cursor.getChar(index)) == '\\'; --index) {
            ++count;
        }
        return count % 2 == 1;
    }

    private void applyCharacters(ProcessingContext context, List<Inline> inlines, Cursor cursor) {
        new Characters(this.getLine(), this.getOffset(), this.getLength(), this.getText()).apply(context, inlines, cursor);
    }

    private String linkTitle(Matcher matcher) {
        String title = matcher.group(3);
        if (title == null && (title = matcher.group(4)) == null && (title = matcher.group(5)) == null) {
            title = "";
        }
        String titleWithoutBackslashEscapes = this.unescapeBackslashEscapes(title);
        return this.replaceHtmlEntities(titleWithoutBackslashEscapes, null);
    }

    private int titleEndIndex(Matcher matcher) {
        int index = matcher.end(3);
        if (index == -1 && (index = matcher.end(4)) == -1) {
            index = matcher.end(5);
        }
        return index + 1;
    }

    private String linkUri(Matcher matcher) {
        String uriWithEscapes = matcher.group(1);
        if (uriWithEscapes == null) {
            uriWithEscapes = matcher.group(2);
        }
        uriWithEscapes = (String)MoreObjects.firstNonNull((Object)uriWithEscapes, (Object)"");
        return this.normalizeUri(uriWithEscapes);
    }

    private String normalizeUri(String uriWithEscapes) {
        String uriWithoutBackslashEscapes = this.unescapeBackslashEscapes(uriWithEscapes);
        try {
            String uriWithoutHtmlEntities = this.replaceHtmlEntities(uriWithoutBackslashEscapes, UrlEscapers.urlFormParameterEscaper());
            String decoded = URLDecoder.decode(uriWithoutHtmlEntities, StandardCharsets.UTF_8.name());
            Escaper escaper = UrlEscapers.urlFragmentEscaper();
            int indexOfHash = decoded.indexOf(35);
            if (indexOfHash != -1) {
                String uri = escaper.escape(decoded.substring(0, indexOfHash)) + "#";
                if (indexOfHash + 1 < decoded.length()) {
                    uri = uri + escaper.escape(decoded.substring(indexOfHash + 1));
                }
                return uri;
            }
            return escaper.escape(decoded);
        }
        catch (Exception e) {
            return uriWithoutBackslashEscapes;
        }
    }

    String replaceHtmlEntities(String text, Escaper escaper) {
        Object replaced = "";
        int lastEnd = 0;
        Matcher matcher = HTML_ENTITY_PATTERN.matcher(text);
        while (matcher.find()) {
            if (lastEnd < matcher.start(1)) {
                replaced = (String)replaced + text.substring(lastEnd, matcher.start(1));
            }
            String entity = matcher.group(2);
            String entityTextEquivalent = EntityReferences.instance().equivalentString(entity);
            replaced = (String)replaced + (entityTextEquivalent == null ? matcher.group(1) : (escaper == null ? entityTextEquivalent : escaper.escape(entityTextEquivalent)));
            lastEnd = matcher.end(1);
        }
        if (lastEnd < text.length()) {
            replaced = (String)replaced + text.substring(lastEnd, text.length());
        }
        return replaced;
    }

    String toReferenceName(String stringWithBackslashEscapes) {
        String referenceName = stringWithBackslashEscapes.replaceAll("(?s)\\\\(\\[|\\])", "$1").replaceAll("\\s+", " ");
        if (CharMatcher.whitespace().matchesAllOf((CharSequence)referenceName)) {
            return null;
        }
        return referenceName;
    }

    String unescapeBackslashEscapes(String stringWithBackslashEscapes) {
        return stringWithBackslashEscapes.replaceAll(CAPTURING_ESCAPED_CHARS, "$1");
    }

    private Optional<PotentialBracketDelimiter> findLastPotentialBracketDelimiter(List<Inline> inlines) {
        for (int x = inlines.size() - 1; x >= 0; --x) {
            Inline inline = inlines.get(x);
            if (!(inline instanceof PotentialBracketDelimiter)) continue;
            PotentialBracketDelimiter delimiter = (PotentialBracketDelimiter)inline;
            return Optional.of(delimiter);
        }
        return Optional.empty();
    }
}

