/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.swt.graphics.Image;

public class UsageMonitorImages {
    private static ImageRegistry imageRegistry;
    private static final String T_ELCL = "elcl16";
    private static final String T_EVIEW = "eview16";
    private static final URL baseURL;
    public static final ImageDescriptor REFRESH;
    public static final ImageDescriptor SYNCHED;
    public static final ImageDescriptor REMOVE;
    public static final ImageDescriptor MONITOR;
    public static final ImageDescriptor ZIP_FILE;

    static {
        baseURL = UiUsageMonitorPlugin.getDefault().getBundle().getEntry("/icons/");
        REFRESH = UsageMonitorImages.create(T_ELCL, "refresh.gif");
        SYNCHED = UsageMonitorImages.create(T_ELCL, "synched.gif");
        REMOVE = UsageMonitorImages.create(T_ELCL, "remove.gif");
        MONITOR = UsageMonitorImages.create(T_EVIEW, "monitor.gif");
        ZIP_FILE = UsageMonitorImages.create(T_ELCL, "import-zip.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)UsageMonitorImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = UsageMonitorImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

