/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.sandbox.search.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class SearchResult
extends PlatformObject {
    private final File file;

    public SearchResult(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public IResource getResource() {
        IFile resource = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.file.isFile()) {
            resource = workspace.getRoot().getFileForLocation((IPath)new Path(this.file.getAbsolutePath()));
        } else if (this.file.isDirectory()) {
            resource = workspace.getRoot().getContainerForLocation((IPath)new Path(this.file.getAbsolutePath()));
        }
        return resource;
    }

    public Object getAdapter(Class adapter) {
        IResource resource;
        if (IResource.class.isAssignableFrom(adapter) && (resource = this.getResource()) != null && adapter.isAssignableFrom(resource.getClass())) {
            return resource;
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.file.toString();
    }
}

