/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.web.tasks.Messages;
import org.eclipse.mylyn.internal.web.tasks.NamedPattern;
import org.eclipse.mylyn.internal.web.tasks.Util;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.tasks.ui.TaskRepositoryLocationUiFactory;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class WebRepositoryConnector
extends AbstractRepositoryConnector {
    public static final String REPOSITORY_TYPE = "web";
    public static final String PROPERTY_TASK_CREATION_URL = "taskCreationUrl";
    public static final String PROPERTY_TASK_URL = "taskUrl";
    public static final String PROPERTY_QUERY_URL = "queryUrl";
    public static final String PROPERTY_QUERY_METHOD = "queryMethod";
    public static final String PROPERTY_QUERY_REGEXP = "queryPattern";
    public static final String PROPERTY_LOGIN_FORM_URL = "loginFormUrl";
    public static final String PROPERTY_LOGIN_TOKEN_REGEXP = "loginTokenPattern";
    public static final String PROPERTY_LOGIN_REQUEST_METHOD = "loginRequestMethod";
    public static final String PROPERTY_LOGIN_REQUEST_URL = "loginRequestUrl";
    public static final String PARAM_PREFIX = "param_";
    public static final String PARAM_SERVER_URL = "serverUrl";
    public static final String PARAM_USER_ID = "userId";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_LOGIN_TOKEN = "loginToken";
    public static final String REQUEST_POST = "POST";
    public static final String REQUEST_GET = "GET";
    private static final String COMPLETED_STATUSES = "completed|fixed|resolved|invalid|verified|deleted|closed|done";
    public static final String KEY_TASK_PREFIX = "taskPrefix";
    public static final String KEY_QUERY_TEMPLATE = "UrlTemplate";
    public static final String KEY_QUERY_PATTERN = "Regexp";
    private static final String USER_AGENT = "WebTemplatesConnector";
    private static final Date DEFAULT_DATE = new Date(0L);

    public String getConnectorKind() {
        return REPOSITORY_TYPE;
    }

    public String getLabel() {
        return Messages.WebRepositoryConnector_Web_Template_Advanced_;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return repository.hasProperty(PROPERTY_TASK_CREATION_URL);
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return repository.hasProperty(PROPERTY_TASK_URL);
    }

    public boolean canSynchronizeTask(TaskRepository taskRepository, ITask task) {
        return false;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        String taskPrefix = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
        TaskData taskData = WebRepositoryConnector.createTaskData(repository, taskId);
        TaskMapper mapper = new TaskMapper(taskData, true);
        mapper.setCreationDate(DEFAULT_DATE);
        mapper.setTaskUrl(String.valueOf(taskPrefix) + taskId);
        mapper.setValue(KEY_TASK_PREFIX, taskPrefix);
        mapper.setSummary(taskId);
        try {
            String pageTitle = WebUtil.getTitleFromUrl((AbstractWebLocation)new WebLocation(String.valueOf(taskPrefix) + taskId), (IProgressMonitor)monitor);
            if (pageTitle != null) {
                mapper.setSummary(pageTitle);
            }
        }
        catch (IOException iOException) {}
        taskData.getRoot().getMappedAttribute("task.common.summary").getMetaData().putValue("forced", Boolean.TRUE.toString());
        return taskData;
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        for (TaskRepository repository : repositoryManager.getRepositories(this.getConnectorKind())) {
            String taskUrl = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            if (taskUrl == null || taskUrl.equals("") || !url.startsWith(taskUrl)) continue;
            return repository.getRepositoryUrl();
        }
        for (IRepositoryQuery query : TasksUiInternal.getTaskList().getQueries()) {
            String queryUrl;
            TaskRepository repository = repositoryManager.getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            if (repository == null || (queryUrl = WebRepositoryConnector.evaluateParams(query.getAttribute(KEY_TASK_PREFIX), WebRepositoryConnector.getQueryParams(query), repository)) == null || queryUrl.equals("") || !url.startsWith(queryUrl)) continue;
            return query.getRepositoryUrl();
        }
        return null;
    }

    public static Map<String, String> getQueryParams(IRepositoryQuery query) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Map attributes = query.getAttributes();
        for (String name : attributes.keySet()) {
            if (!name.startsWith(PARAM_PREFIX)) continue;
            params.put(name, (String)attributes.get(name));
        }
        return params;
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        for (TaskRepository repository : repositoryManager.getRepositories(this.getConnectorKind())) {
            String start = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            if (start == null || !url.startsWith(start)) continue;
            return url.substring(start.length());
        }
        return null;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        TaskRepository repository = repositoryManager.getRepository(this.getConnectorKind(), repositoryUrl);
        if (repository != null) {
            String prefix = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            return String.valueOf(prefix) + taskId;
        }
        return null;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession session, IProgressMonitor monitor) {
        Map<String, String> queryParameters = WebRepositoryConnector.getQueryParams(query);
        String queryUrl = WebRepositoryConnector.evaluateParams(query.getUrl(), queryParameters, repository);
        try {
            String content = WebRepositoryConnector.fetchResource(queryUrl, queryParameters, repository);
            String taskPrefixAttribute = query.getAttribute(KEY_TASK_PREFIX);
            if (!Util.isPresent(taskPrefixAttribute)) {
                return WebRepositoryConnector.performRssQuery(content, monitor, resultCollector, repository);
            }
            String taskPrefix = WebRepositoryConnector.evaluateParams(taskPrefixAttribute, queryParameters, repository);
            String queryPattern = WebRepositoryConnector.evaluateParams(query.getAttribute(KEY_QUERY_PATTERN), queryParameters, repository);
            return WebRepositoryConnector.performQuery(content, queryPattern, taskPrefix, monitor, resultCollector, repository);
        }
        catch (IOException e) {
            String msg = e.getMessage() == null ? e.toString() : e.getMessage();
            return new Status(4, "org.eclipse.mylyn.tasks.web", 4, String.valueOf(Messages.WebRepositoryConnector_Could_not_fetch_resource) + queryUrl + "\n" + msg, (Throwable)e);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData taskData) {
        this.preProcessTaskData(task, taskData);
        TaskMapper mapper = new TaskMapper(taskData);
        if (Util.isPresent(mapper.getValue(KEY_TASK_PREFIX))) {
            task.setAttribute(KEY_TASK_PREFIX, mapper.getValue(KEY_TASK_PREFIX));
            task.setTaskKey(task.getTaskId());
        } else {
            task.setTaskKey(null);
        }
        mapper.applyTo(task);
    }

    private void preProcessTaskData(ITask task, TaskData taskData) {
        TaskAttribute summaryAttribute;
        if (task.getSummary() != null && task.getSummary().length() > 0 && (summaryAttribute = taskData.getRoot().getMappedAttribute("task.common.summary")) != null && Boolean.parseBoolean(summaryAttribute.getMetaData().getValue("forced"))) {
            summaryAttribute.setValue(task.getSummary());
        }
    }

    public static IStatus performQuery(String resource, String regexp, String taskPrefix, IProgressMonitor monitor, TaskDataCollector resultCollector, TaskRepository repository) {
        NamedPattern p = new NamedPattern(regexp, 234);
        Matcher matcher = p.matcher(resource);
        if (!matcher.find()) {
            return Status.OK_STATUS;
        }
        boolean isCorrect = true;
        do {
            String description;
            String id;
            if (p.getGroups().isEmpty()) {
                if (matcher.groupCount() < 2) {
                    isCorrect = false;
                }
                if (matcher.groupCount() < 1) continue;
                id = matcher.group(1);
                description = matcher.groupCount() > 1 ? WebRepositoryConnector.cleanup(matcher.group(2), repository) : null;
                description = WebRepositoryConnector.unescapeHtml(description);
                TaskData data = WebRepositoryConnector.createTaskData(repository, id);
                TaskMapper mapper = new TaskMapper(data, true);
                mapper.setCreationDate(DEFAULT_DATE);
                mapper.setTaskUrl(String.valueOf(taskPrefix) + id);
                mapper.setSummary(description);
                mapper.setValue(KEY_TASK_PREFIX, taskPrefix);
                resultCollector.accept(data);
                continue;
            }
            id = p.group("Id", matcher);
            description = p.group("Description", matcher);
            if (id == null || description == null) {
                isCorrect = false;
            }
            if (id == null) continue;
            description = WebRepositoryConnector.unescapeHtml(description);
            String owner = WebRepositoryConnector.unescapeHtml(WebRepositoryConnector.cleanup(p.group("Owner", matcher), repository));
            String type = WebRepositoryConnector.unescapeHtml(WebRepositoryConnector.cleanup(p.group("Type", matcher), repository));
            TaskData data = WebRepositoryConnector.createTaskData(repository, id);
            TaskMapper mapper = new TaskMapper(data, true);
            mapper.setCreationDate(DEFAULT_DATE);
            mapper.setTaskUrl(String.valueOf(taskPrefix) + id);
            mapper.setSummary(description);
            mapper.setValue(KEY_TASK_PREFIX, taskPrefix);
            mapper.setOwner(owner);
            mapper.setTaskKind(type);
            String status = p.group("Status", matcher);
            if (status != null && COMPLETED_STATUSES.contains(status.toLowerCase())) {
                mapper.setCompletionDate(DEFAULT_DATE);
            }
            resultCollector.accept(data);
        } while (matcher.find() && !monitor.isCanceled());
        if (isCorrect) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.mylyn.tasks.web", 4, Messages.WebRepositoryConnector_Require_two_matching_groups, null);
    }

    private static TaskData createTaskData(TaskRepository taskRepository, String id) {
        TaskData data = new TaskData(new TaskAttributeMapper(taskRepository), REPOSITORY_TYPE, taskRepository.getRepositoryUrl(), id);
        data.setPartial(true);
        return data;
    }

    private static String unescapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml((String)text);
    }

    private static String cleanup(String text, TaskRepository repository) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("<!--.+?-->", "");
        String[] tokens = text.split(" |\\t|\\n|\\r");
        StringBuilder sb = new StringBuilder();
        String sep = "";
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.length() > 0) {
                sb.append(sep).append(token);
                sep = " ";
            }
            ++n2;
        }
        return sb.toString();
    }

    public static IStatus performRssQuery(String content, IProgressMonitor monitor, TaskDataCollector resultCollector, TaskRepository repository) {
        SyndFeedInput input = new SyndFeedInput();
        try {
            SyndFeed feed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(content.getBytes())));
            SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm");
            for (SyndEntry entry : feed.getEntries()) {
                String entryUri;
                Date date;
                String author = entry.getAuthor();
                if (author == null) {
                    DCModule module = (DCModule)entry.getModule("http://purl.org/dc/elements/1.1/");
                    author = module.getCreator();
                }
                if ((date = entry.getUpdatedDate()) == null) {
                    date = entry.getPublishedDate();
                }
                if (date == null) {
                    DCModule module = (DCModule)entry.getModule("http://purl.org/dc/elements/1.1/");
                    date = module.getDate();
                }
                if ((entryUri = entry.getLink()) == null) {
                    entryUri = entry.getUri();
                }
                String entrTitle = entry.getTitle();
                TaskData data = WebRepositoryConnector.createTaskData(repository, entryUri.replaceAll("-", "%2D"));
                TaskMapper schema = new TaskMapper(data, true);
                schema.setSummary(String.valueOf(date == null ? "" : String.valueOf(df.format(date)) + " - ") + entrTitle);
                schema.setCreationDate(date);
                schema.setOwner(author);
                schema.setTaskUrl(entryUri);
                resultCollector.accept(data);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? e.toString() : e.getMessage();
            return new Status(4, "org.eclipse.mylyn.tasks.web", 4, String.valueOf(Messages.WebRepositoryConnector_Failed_to_parse_RSS_feed) + "\"" + msg + "\"", (Throwable)e);
        }
    }

    public static String fetchResource(String url, Map<String, String> params, TaskRepository repository) throws IOException {
        HttpClient client = new HttpClient();
        WebUtil.configureHttpClient((HttpClient)client, (String)USER_AGENT);
        AbstractWebLocation location = new TaskRepositoryLocationUiFactory().createWebLocation(repository);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, null);
        WebRepositoryConnector.loginRequestIfNeeded(client, hostConfiguration, params, repository);
        GetMethod method = new GetMethod(url);
        return WebRepositoryConnector.requestResource(url, client, hostConfiguration, (HttpMethod)method);
    }

    private static void loginRequestIfNeeded(HttpClient client, HostConfiguration hostConfiguration, Map<String, String> params, TaskRepository repository) throws HttpException, IOException {
        Pattern p;
        Matcher m;
        GetMethod method;
        String loginFormPage;
        if (repository.getCredentials(AuthenticationType.REPOSITORY) == null || !Util.isPresent(repository.getProperty(PROPERTY_LOGIN_REQUEST_URL))) {
            return;
        }
        String loginFormUrl = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_LOGIN_FORM_URL), params, repository);
        String loginToken = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_LOGIN_TOKEN_REGEXP), params, repository);
        if ((Util.isPresent(loginFormUrl) || Util.isPresent(loginToken)) && (loginFormPage = WebRepositoryConnector.requestResource(loginFormUrl, client, hostConfiguration, (HttpMethod)(method = new GetMethod(loginFormUrl)))) != null && (m = (p = Pattern.compile(loginToken)).matcher(loginFormPage)).find()) {
            params.put("param_loginToken", m.group(1));
        }
        String loginRequestUrl = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_LOGIN_REQUEST_URL), params, repository);
        WebRepositoryConnector.requestResource(loginRequestUrl, client, hostConfiguration, WebRepositoryConnector.getLoginMethod(params, repository));
    }

    public static HttpMethod getLoginMethod(Map<String, String> params, TaskRepository repository) {
        String[] requestParams;
        String requestMethod = repository.getProperty(PROPERTY_LOGIN_REQUEST_METHOD);
        String requestTemplate = repository.getProperty(PROPERTY_LOGIN_REQUEST_URL);
        String requestUrl = WebRepositoryConnector.evaluateParams(requestTemplate, params, repository);
        if (REQUEST_GET.equals(requestMethod)) {
            return new GetMethod(requestUrl);
        }
        int n = requestUrl.indexOf(63);
        if (n == -1) {
            return new PostMethod(requestUrl);
        }
        PostMethod postMethod = new PostMethod(requestUrl.substring(0, n));
        n = requestTemplate.indexOf(63);
        String[] stringArray = requestParams = requestTemplate.substring(n + 1).split("&");
        int n2 = requestParams.length;
        int n3 = 0;
        while (n3 < n2) {
            String requestParam = stringArray[n3];
            String[] nv = requestParam.split("=");
            if (nv.length == 1) {
                postMethod.addParameter(nv[0], "");
            } else {
                String value = WebRepositoryConnector.evaluateParams(nv[1], WebRepositoryConnector.getParams(repository, params), false);
                postMethod.addParameter(nv[0], value);
            }
            ++n3;
        }
        return postMethod;
    }

    private static String requestResource(String url, HttpClient client, HostConfiguration hostConfiguration, HttpMethod method) throws IOException, HttpException {
        String refreshUrl = null;
        try {
            client.executeMethod(hostConfiguration, method);
            refreshUrl = WebRepositoryConnector.getRefreshUrl(url, method);
            if (refreshUrl == null) {
                String string = method.getResponseBodyAsString();
                return string;
            }
        }
        finally {
            method.releaseConnection();
        }
        method = new GetMethod(refreshUrl);
        try {
            client.executeMethod(hostConfiguration, method);
            String string = method.getResponseBodyAsString();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    private static String getRefreshUrl(String url, HttpMethod method) {
        int requestPath;
        Header refreshHeader = method.getResponseHeader("Refresh");
        if (refreshHeader == null) {
            return null;
        }
        String value = refreshHeader.getValue();
        int n = value.indexOf(";url=");
        if (n == -1) {
            return null;
        }
        if ((value = value.substring(n + 5)).charAt(0) == '/') {
            int colonSlashSlash = url.indexOf("://");
            requestPath = url.indexOf(47, colonSlashSlash + 3);
        } else {
            requestPath = url.lastIndexOf(47);
        }
        String refreshUrl = requestPath == -1 ? String.valueOf(url) + "/" + value : String.valueOf(url.substring(0, requestPath + 1)) + value;
        return refreshUrl;
    }

    public static String evaluateParams(String value, Map<String, String> params, TaskRepository repository) {
        return WebRepositoryConnector.evaluateParams(value, WebRepositoryConnector.getParams(repository, params), true);
    }

    public static String evaluateParams(String value, TaskRepository repository) {
        return WebRepositoryConnector.evaluateParams(value, WebRepositoryConnector.getParams(repository, null), true);
    }

    private static String evaluateParams(String value, Map<String, String> params, boolean encode) {
        if (value == null || value.indexOf("${") == -1) {
            return value;
        }
        int n = 0;
        int n1 = value.indexOf("${");
        StringBuilder evaluatedValue = new StringBuilder(value.length());
        while (n1 > -1) {
            evaluatedValue.append(value.substring(n, n1));
            int n2 = value.indexOf("}", n1);
            if (n2 > -1) {
                String key = value.substring(n1 + 2, n2);
                if (PARAM_SERVER_URL.equals(key) || PARAM_USER_ID.equals(key) || PARAM_PASSWORD.equals(key)) {
                    evaluatedValue.append(WebRepositoryConnector.evaluateParams(params.get(key), params, false));
                } else {
                    String val = WebRepositoryConnector.evaluateParams(params.get(PARAM_PREFIX + key), params, false);
                    evaluatedValue.append(encode ? WebRepositoryConnector.encode(val) : val);
                }
            }
            n = n2 + 1;
            n1 = value.indexOf("${", n2);
        }
        if (n > -1) {
            evaluatedValue.append(value.substring(n));
        }
        return evaluatedValue.toString();
    }

    private static Map<String, String> getParams(TaskRepository repository, Map<String, String> params) {
        LinkedHashMap<String, String> mergedParams = new LinkedHashMap<String, String>(repository.getProperties());
        mergedParams.put(PARAM_SERVER_URL, repository.getRepositoryUrl());
        AuthenticationCredentials credentials = repository.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            mergedParams.put(PARAM_USER_ID, credentials.getUserName());
            mergedParams.put(PARAM_PASSWORD, credentials.getPassword());
        }
        if (params != null) {
            mergedParams.putAll(params);
        }
        return mergedParams;
    }

    private static String encode(String value) {
        try {
            return new URLCodec().encode(value);
        }
        catch (EncoderException encoderException) {
            return value;
        }
    }

    public static List<String> getTemplateVariables(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> vars = new ArrayList<String>();
        Matcher m = Pattern.compile("\\$\\{(.+?)\\}").matcher(value);
        while (m.find()) {
            vars.add(m.group(1));
        }
        return vars;
    }

    public boolean hasLocalCompletionState(TaskRepository taskRepository, ITask task) {
        return true;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        this.preProcessTaskData(task, taskData);
        return new TaskMapper(taskData).hasChanges(task);
    }
}

