/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.function;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractMathSingleValueFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;

public class SquareRootFunction
extends AbstractMathSingleValueFunction {
    public SquareRootFunction() {
    }

    public SquareRootFunction(FunctionValue value) {
        super(value);
    }

    public SquareRootFunction(List<FunctionValue> values) {
        super(values);
        BigDecimal converted;
        if (!this.values.isEmpty() && (converted = this.convertValue(((FunctionValue)this.values.get(0)).getValue())).signum() < 0) {
            throw new FunctionException("#NUM!", Messages.getString("FormulaParser.error.negativeValue"));
        }
    }

    @Override
    public void addFunctionValue(FunctionValue value) {
        BigDecimal converted = this.convertValue(value.getValue());
        if (converted.signum() < 0) {
            throw new FunctionException("#NUM!", Messages.getString("FormulaParser.error.negativeValue"));
        }
        super.addFunctionValue(value);
    }

    @Override
    public BigDecimal getValue() {
        BigDecimal value = this.convertValue(this.getSingleValue().getValue());
        BigDecimal x = BigDecimal.valueOf(Math.sqrt(value.doubleValue()));
        return x.add(BigDecimal.valueOf(value.subtract(x.multiply(x)).doubleValue() / (x.doubleValue() * 2.0)));
    }

    public String toString() {
        if (this.values.isEmpty()) {
            return "\u00b2";
        }
        return String.valueOf(this.getSingleValue()) + "\u00b2";
    }
}

