/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.questionnaire;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.ui.Questionnaire;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.questionnaire.GearShell;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;

public class QuestionnaireImpl
extends Questionnaire {
    protected void doPerform(Shell parentShell, boolean force) {
        this.performOutsideUIThread(parentShell, force);
    }

    private void performOutsideUIThread(final Shell parentShell, boolean force) {
        RecorderTransaction transaction = RecorderTransaction.open();
        try {
            User user;
            SetupTaskContainer rootObject = transaction.getRootObject();
            if (rootObject instanceof User && ((user = (User)rootObject).getQuestionnaireDate() == null || force)) {
                final HashMap preferences = new HashMap();
                UIUtil.syncExec((Runnable)new Runnable(){

                    public void run() {
                        GearShell shell = new GearShell(parentShell);
                        Map result = (Map)shell.openModal();
                        if (result != null) {
                            preferences.putAll(result);
                        }
                    }
                });
                URI uri = PreferencesFactory.eINSTANCE.createURI("RECORDER_PREFERENCE_KEY");
                if (preferences.containsKey(uri)) {
                    boolean enabled = Boolean.parseBoolean((String)preferences.remove(uri));
                    user.setPreferenceRecorderDefault(enabled);
                }
                if (!preferences.isEmpty()) {
                    boolean inIDE = !SetupUIPlugin.isInstallerProduct();
                    for (Map.Entry entry : preferences.entrySet()) {
                        String path = PreferencesFactory.eINSTANCE.convertURI((URI)entry.getKey());
                        transaction.setPolicy(path, true);
                        if (!inIDE) continue;
                        PreferencesUtil.PreferenceProperty property = new PreferencesUtil.PreferenceProperty(path);
                        property.set((String)entry.getValue());
                    }
                    transaction.setPreferences(preferences);
                }
                user.setQuestionnaireDate(new Date());
                transaction.setForceDirty(true);
                transaction.commit();
            }
        }
        finally {
            transaction.close();
        }
    }
}

