/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

public final class SynchronizedCounter {
    private int count;

    public synchronized void countUp() {
        ++this.count;
        this.notifyAll();
    }

    public synchronized void countDown() {
        --this.count;
        this.notifyAll();
    }

    public synchronized int getCount() {
        return this.count;
    }

    public synchronized boolean isZero() {
        return this.count == 0;
    }

    public synchronized boolean awaitZero() {
        while (this.count != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public synchronized boolean awaitChange() {
        int oldCount = this.count;
        while (this.count == oldCount) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Counter[" + this.count + "]";
    }
}

