/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.AgentManagerElement;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.ui.AgentAnalyzerDialog;
import org.eclipse.oomph.p2.internal.ui.P2ContentProvider;
import org.eclipse.oomph.p2.internal.ui.P2LabelProvider;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.P2ViewerSorter;
import org.eclipse.oomph.p2.internal.ui.ProfileDetailsDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class AgentManagerComposite
extends Composite {
    private static final OomphPlugin.Preference PREF_SHOW_PROFILES = P2UIPlugin.INSTANCE.getConfigurationPreference("showProfiles");
    private TreeViewer treeViewer;
    private Object selectedElement;
    private Button refreshButton;
    private Button newAgentButton;
    private Button newPoolButton;
    private Button deleteButton;
    private Button analyzeButton;
    private Button showProfilesButton;

    public AgentManagerComposite(Composite parent, int style, final Object selection) {
        super(parent, style);
        this.setLayout((Layout)UIUtil.createGridLayout((int)2));
        final P2ContentProvider contentProvider = new P2ContentProvider();
        this.treeViewer = new TreeViewer((Composite)this, 2048);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new P2LabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new P2ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AgentManagerComposite.this.selectedElement = ((IStructuredSelection)AgentManagerComposite.this.treeViewer.getSelection()).getFirstElement();
                AgentManagerComposite.this.elementChanged(AgentManagerComposite.this.selectedElement);
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (AgentManagerComposite.this.selectedElement instanceof Profile) {
                    ProfileDetailsDialog dialog = new ProfileDetailsDialog(AgentManagerComposite.this.getShell(), (Profile)AgentManagerComposite.this.selectedElement);
                    dialog.open();
                } else {
                    AgentManagerComposite.this.treeViewer.setExpandedState(AgentManagerComposite.this.selectedElement, !AgentManagerComposite.this.treeViewer.getExpandedState(AgentManagerComposite.this.selectedElement));
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && AgentManagerComposite.this.deleteButton.isEnabled()) {
                    AgentManagerComposite.this.deletePressed();
                }
            }
        });
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)buttonLayout);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonComposite.setBounds(0, 0, 64, 64);
        this.refreshButton = new Button(buttonComposite, 0);
        this.refreshButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refreshButton.setText("Refresh");
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(AgentManagerComposite.this.getShell());
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            P2Util.getAgentManager().refreshAgents(monitor);
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    P2UIPlugin.INSTANCE.log(ex);
                }
                catch (InterruptedException interruptedException) {}
                AgentManagerComposite.this.treeViewer.refresh();
            }
        });
        this.newAgentButton = new Button(buttonComposite, 0);
        this.newAgentButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newAgentButton.setText("New Agent...");
        this.newAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = AgentManagerComposite.this.openDirectoryDialog("Select the location of the new agent.", PropertiesUtil.USER_HOME);
                if (path != null) {
                    Agent agent = P2Util.getAgentManager().addAgent(new File(path));
                    BundlePool bundlePool = agent.addBundlePool(new File(path, "pool"));
                    AgentManagerComposite.this.refreshFor(bundlePool);
                }
            }
        });
        this.newPoolButton = new Button(buttonComposite, 0);
        this.newPoolButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newPoolButton.setText("New Bundle Pool...");
        this.newPoolButton.setEnabled(false);
        this.newPoolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Agent selectedAgent = (Agent)AgentManagerComposite.this.selectedElement;
                String path = AgentManagerComposite.this.openDirectoryDialog("Select the location of the new pool.", selectedAgent.getLocation().getAbsolutePath());
                if (path != null) {
                    BundlePool bundlePool = selectedAgent.addBundlePool(new File(path));
                    AgentManagerComposite.this.refreshFor(bundlePool);
                }
            }
        });
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.deleteButton.setText("Delete...");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentManagerComposite.this.deletePressed();
            }
        });
        this.analyzeButton = new Button(buttonComposite, 0);
        this.analyzeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.analyzeButton.setText("Analyze...");
        this.analyzeButton.setEnabled(false);
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzerDialog dialog = new AgentAnalyzerDialog(AgentManagerComposite.this.getShell(), (Agent)AgentManagerComposite.this.selectedElement);
                dialog.open();
                AgentManagerComposite.this.treeViewer.refresh();
            }
        });
        this.showProfilesButton = new Button(buttonComposite, 32);
        this.showProfilesButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.showProfilesButton.setText("Show Profiles");
        this.showProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean showProfiles = AgentManagerComposite.this.showProfilesButton.getSelection();
                PREF_SHOW_PROFILES.set(showProfiles);
                contentProvider.setShowProfiles(showProfiles);
                AgentManagerComposite.this.treeViewer.refresh();
                if (AgentManagerComposite.this.selectedElement instanceof BundlePool) {
                    AgentManagerComposite.this.treeViewer.setExpandedState(AgentManagerComposite.this.selectedElement, true);
                }
                AgentManagerComposite.this.profilesShown(showProfiles);
            }
        });
        if (PREF_SHOW_PROFILES.get(false)) {
            this.showProfilesButton.setSelection(true);
            contentProvider.setShowProfiles(true);
            this.profilesShown(true);
        }
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                final AgentManager agentManager = P2Util.getAgentManager();
                BusyIndicator.showWhile((Display)AgentManagerComposite.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        AgentManagerComposite.this.treeViewer.setInput((Object)agentManager);
                        AgentManagerComposite.this.treeViewer.expandAll();
                    }
                });
                if (selection == null) {
                    Collection agents = agentManager.getAgents();
                    if (!agents.isEmpty()) {
                        AgentManagerComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(agents.iterator().next()));
                    }
                } else {
                    AgentManagerComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(selection));
                }
            }
        });
    }

    public boolean setFocus() {
        return this.treeViewer.getTree().setFocus();
    }

    public Object getSelectedElement() {
        return this.selectedElement;
    }

    public void setEnabled(boolean enabled) {
        this.treeViewer.getTree().setEnabled(enabled);
        this.refreshButton.setEnabled(enabled);
        this.newAgentButton.setEnabled(enabled);
        this.showProfilesButton.setEnabled(enabled);
        this.elementChanged(this.selectedElement);
        super.setEnabled(enabled);
    }

    protected void checkSubclass() {
    }

    private void deletePressed() {
        AgentManagerElementImpl agentManagerElement = (AgentManagerElementImpl)this.selectedElement;
        String type = agentManagerElement.getElementType();
        String message = "Are you sure to delete " + type + " " + agentManagerElement + "?";
        if (!(agentManagerElement instanceof Profile)) {
            message = String.valueOf(message) + "\n\nThe physical " + type + " files will remain on disk even if you answer Yes.";
        }
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Bundle Pool Management", (String)message)) {
            try {
                ITreeContentProvider contentProvider;
                Object parent;
                Object newSelection = null;
                IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element != null && (parent = (contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(element)) != null) {
                    newSelection = parent;
                    Object[] elements = contentProvider.getChildren(parent);
                    this.treeViewer.getComparator().sort((Viewer)this.treeViewer, elements);
                    List<Object> children = Arrays.asList(elements);
                    int index = children.indexOf(element);
                    if (index != -1) {
                        if (index + 1 < children.size()) {
                            newSelection = children.get(index + 1);
                        } else if (index > 0) {
                            newSelection = children.get(index - 1);
                        }
                    }
                }
                agentManagerElement.delete();
                this.treeViewer.refresh();
                if (newSelection != null) {
                    this.treeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
                }
            }
            catch (Exception ex) {
                P2UIPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void elementChanged(Object element) {
        this.newPoolButton.setEnabled(element instanceof Agent);
        this.deleteButton.setEnabled(element instanceof AgentManagerElement && !((AgentManagerElement)element).isUsed());
        this.analyzeButton.setEnabled(element instanceof Agent);
    }

    protected void profilesShown(boolean profilesShown) {
    }

    private String openDirectoryDialog(String message, String path) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText("Bundle Pool Management");
        dialog.setMessage(message);
        dialog.setFilterPath(path);
        return dialog.open();
    }

    private void refreshFor(BundlePool bundlePool) {
        this.treeViewer.refresh();
        this.treeViewer.setExpandedState((Object)bundlePool.getAgent(), true);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)bundlePool));
        this.treeViewer.getTree().setFocus();
    }
}

