/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.provider.BaseItemProviderAdapterFactory;
import org.eclipse.oomph.internal.base.BasePlugin;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphPropertySheetPage;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.presentation.SetupActionBarContributor;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.provider.SetupItemProviderAdapterFactory;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    private static final URI LEGACY_MODELS = URI.createURI((String)("platform:/plugin/" + BasePlugin.INSTANCE.getSymbolicName() + "/model/legacy"));
    private static final URI LEGACY_EXAMPLE_URI = URI.createURI((String)"file:/example.setup");
    private static final Object VARIABLE_GROUP_IMAGE = SetupEditorPlugin.INSTANCE.getImage("full/obj16/VariableGroup");
    private static final Object UNDECLARED_VARIABLE_GROUP_IMAGE;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected OutlinePreviewPage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == SetupEditor.this.contentOutlinePage) {
                    SetupEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)SetupEditor.this);
                    SetupEditor.this.setCurrentViewer((Viewer)SetupEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (SetupEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    SetupEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)SetupEditor.this);
                    SetupEditor.this.handleActivate();
                }
            } else if (p == SetupEditor.this) {
                SetupEditor.this.handleActivate();
                SetupEditor.this.setCurrentViewer((Viewer)SetupEditor.this.selectionViewer);
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPage activePage;
            if (SetupEditor.this.getSite().getWorkbenchWindow() == window && (activePage = window.getActivePage()) != null) {
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart instanceof ContentOutline) {
                    if (((ContentOutline)activePart).getCurrentPage() == SetupEditor.this.contentOutlinePage) {
                        SetupEditor.this.handleActivate();
                    }
                } else if (activePart instanceof PropertySheet) {
                    if (SetupEditor.this.propertySheetPages.contains(((PropertySheet)activePart).getCurrentPage())) {
                        SetupEditor.this.handleActivate();
                    }
                } else if (activePart == SetupEditor.this) {
                    SetupEditor.this.handleActivate();
                }
            }
        }
    };
    protected boolean isHandlingActivate;
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = SetupEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            SetupEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            SetupEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!SetupEditor.this.updateProblemIndication) return;
                        SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                SetupEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            SetupEditor.this.resourceToDiagnosticMap.remove(target);
            if (SetupEditor.this.updateProblemIndication) {
                SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SetupEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).SetupEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else {
                                    if ((delta.getFlags() & 0x20000) != 0) {
                                        DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resource, (Diagnostic)(this).SetupEditor.this.markerHelper.getMarkerDiagnostics((Object)resource, (IFile)delta.getResource()));
                                    }
                                    if ((delta.getFlags() & 0x100) != 0 && !(this).SetupEditor.this.savedResources.remove(resource)) {
                                        this.changedResources.add(resource);
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).SetupEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!SetupEditor.this.isDirty()) {
                                SetupEditor.this.getSite().getPage().closeEditor((IEditorPart)SetupEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).SetupEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (SetupEditor.this.getSite().getPage().getActiveEditor() == SetupEditor.this) {
                                SetupEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                SetupEditorPlugin.INSTANCE.log(exception);
            }
        }
    };
    private ResourceMirror resourceMirror;
    private final ItemProvider loadingResourceInput = new ItemProvider(Collections.singleton(new ItemProvider("Loading resource...")));
    private final ItemProvider loadingResourceSetInput = new ItemProvider(Collections.singleton(new ItemProvider("Loading resource set...")));
    private DelegatingDialogSettings dialogSettings = new DelegatingDialogSettings();
    private BaseEditUtil.IconReflectiveItemProvider reflectiveItemProvider;

    static {
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(VARIABLE_GROUP_IMAGE);
        images.add(EMFEditUIPlugin.INSTANCE.getImage("full/ovr16/error_ovr.gif"));
        ComposedImage composedImage = new ComposedImage(images){

            public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
                result.add(new ComposedImage.Point());
                ComposedImage.Point overlay = new ComposedImage.Point();
                overlay.y = 7;
                result.add(overlay);
                return result;
            }
        };
        UNDECLARED_VARIABLE_GROUP_IMAGE = ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
    }

    public SetupEditor() {
        this.initializeEditingDomain();
    }

    protected void handleActivateGen() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleActivate() {
        if (!this.isHandlingActivate && this.resourceMirror == null) {
            this.isHandlingActivate = true;
            try {
                ArrayList<Resource> changedResources;
                ArrayList<Resource> removedResources;
                ResourceSet resourceSet = this.editingDomain.getResourceSet();
                URIConverter uriConverter = resourceSet.getURIConverter();
                final HashSet<IFile> files = new HashSet<IFile>();
                for (Resource resource : resourceSet.getResources()) {
                    Map attributes;
                    Long timeStamp;
                    if (!resource.isLoaded()) continue;
                    URI uri = resource.getURI();
                    URI normalizedURI = uriConverter.normalize(uri);
                    if (normalizedURI.isPlatformResource()) {
                        files.add(EcorePlugin.getWorkspaceRoot().getFile((IPath)new Path(normalizedURI.toPlatformString(true))));
                        continue;
                    }
                    if (!normalizedURI.isFile() || (timeStamp = (Long)(attributes = uriConverter.getAttributes(normalizedURI, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")))).get("timeStamp")) == null || timeStamp.longValue() == resource.getTimeStamp()) continue;
                    this.changedResources.add(resource);
                }
                if (!files.isEmpty()) {
                    final AtomicBoolean needsRefresh = new AtomicBoolean();
                    IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            for (IFile file : files) {
                                if (file.isSynchronized(1)) continue;
                                needsRefresh.set(true);
                                file.refreshLocal(1, monitor);
                            }
                        }
                    };
                    try {
                        EcorePlugin.getWorkspaceRoot().getWorkspace().run(operation, null);
                    }
                    catch (Exception exception) {
                        SetupEditorPlugin.INSTANCE.log(exception);
                    }
                    if (needsRefresh.get()) {
                        return;
                    }
                }
                if (!this.removedResources.isEmpty() && !(removedResources = new ArrayList<Resource>(this.removedResources)).remove(resourceSet.getResources().get(0))) {
                    for (Resource resource : removedResources) {
                        this.removedResources.remove(resource);
                        resource.unload();
                    }
                }
                if (!this.changedResources.isEmpty() && !(changedResources = new ArrayList<Resource>(this.changedResources)).remove(resourceSet.getResources().get(0))) {
                    this.updateProblemIndication = false;
                    for (Resource resource : changedResources) {
                        this.changedResources.remove(resource);
                        if (!resource.isLoaded()) continue;
                        resource.unload();
                        try {
                            resource.load(Collections.EMPTY_MAP);
                        }
                        catch (IOException exception) {
                            if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                        }
                    }
                    if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                        this.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                    this.updateProblemIndication = true;
                    this.updateProblemIndication();
                }
                this.handleActivateGen();
            }
            finally {
                this.isHandlingActivate = false;
            }
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndicationGen() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.oomph.setup.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    SetupEditorPlugin.INSTANCE.log(exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        SetupEditorPlugin.INSTANCE.log(exception);
                    }
                }
            }
        }
    }

    protected void updateProblemIndication() {
        Object input;
        if (!this.resourceToDiagnosticMap.isEmpty() && ((input = this.selectionViewer.getInput()) instanceof Resource || input == this.loadingResourceInput)) {
            SetupActionBarContributor.ToggleViewerInputAction toggleViewerInputAction = this.getActionBarContributor().getToggleViewerInputAction();
            toggleViewerInputAction.setActiveWorkbenchPart((IWorkbenchPart)this);
            toggleViewerInputAction.run();
            toggleViewerInputAction.setActiveWorkbenchPart((IWorkbenchPart)this);
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)SetupEditor.getString("_UI_FileConflict_label"), (String)SetupEditor.getString("_WARN_FileConflict"));
    }

    protected void initializeEditingDomainGen() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SetupItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new BaseItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                SetupEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SetupEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            SetupEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).SetupEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void initializeEditingDomain() {
        this.initializeEditingDomainGen();
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){

            public Adapter createResourceAdapter() {
                final 8 resourceItemProviderAdapterFactory = this;
                return new ResourceItemProvider((AdapterFactory)resourceItemProviderAdapterFactory){
                    private List<DelegatingWrapperItemProvider> children;

                    protected boolean isWrappingNeeded(Object object) {
                        return true;
                    }

                    protected Command createCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
                        return UnexecutableCommand.INSTANCE;
                    }

                    public Collection<?> getChildren(Object object) {
                        Resource resource = (Resource)object;
                        ArrayList contents = new ArrayList(resource.getContents());
                        ResourceSet resourceSet = resource.getResourceSet();
                        if (resourceSet != null && resourceSet.getResources().get(0) != resource) {
                            if (this.children == null) {
                                this.children = new ArrayList<DelegatingWrapperItemProvider>();
                                int index = 0;
                                for (Object child : contents) {
                                    this.children.add(new DelegatingWrapperItemProvider(child, (Object)resource, null, index++, (AdapterFactory)resourceItemProviderAdapterFactory));
                                }
                            }
                            return this.children;
                        }
                        return contents;
                    }

                    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
                        if (this.itemPropertyDescriptors == null) {
                            super.getPropertyDescriptors(object);
                            this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)resourceItemProviderAdapterFactory, "Resolved URI", "The resolved URI of the resource", null, false){

                                public Object getFeature(Object object) {
                                    return "resolvedURI";
                                }

                                public Object getPropertyValue(Object object) {
                                    Resource resource = (Resource)object;
                                    URI uri = resource.getURI();
                                    ResourceSet resourceSet = resource.getResourceSet();
                                    if (resourceSet != null) {
                                        uri = resourceSet.getURIConverter().normalize(uri);
                                    }
                                    uri = SetupContext.resolveUser((URI)uri);
                                    return uri;
                                }
                            });
                        }
                        return this.itemPropertyDescriptors;
                    }

                    public void dispose() {
                        super.dispose();
                        if (this.children != null) {
                            for (IDisposable iDisposable : this.children) {
                                iDisposable.dispose();
                            }
                        }
                    }
                };
            }
        });
        this.reflectiveItemProvider = BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
        HashMap<Resource, Boolean> readOnlyMap = new HashMap<Resource, Boolean>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Boolean get(Object key) {
                return !SetupEditor.this.editingDomain.getResourceSet().getResources().contains(key) ? Boolean.TRUE : (Boolean)super.get(key);
            }
        };
        List delegates = OomphTransferDelegate.merge((Collection)OomphTransferDelegate.DELEGATES, (OomphTransferDelegate[])new OomphTransferDelegate[]{new OomphTransferDelegate.FileTransferDelegate(){

            protected void gather(EditingDomain domain, URI uri) {
                super.gather(domain, SetupContext.resolveUser((URI)uri));
            }
        }, new OomphTransferDelegate.URLTransferDelegate(){

            protected void gather(EditingDomain domain, URI uri) {
                super.gather(domain, SetupContext.resolveUser((URI)uri));
            }
        }});
        this.editingDomain = new OomphEditingDomain((AdapterFactory)this.adapterFactory, this.editingDomain.getCommandStack(), (Map)readOnlyMap, delegates);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        SetupCoreUtil.configureResourceSet((ResourceSet)resourceSet);
        URIConverter uriConverter = resourceSet.getURIConverter();
        Map uriMap = uriConverter.getURIMap();
        HashMap<URI, URI> workspaceMappings = new HashMap<URI, URI>();
        for (URI uri : uriMap.values()) {
            if (!uri.isFile() || uri.isRelative()) continue;
            try {
                URI redirectedWorkspaceURI;
                IContainer[] iContainerArray;
                java.net.URI locationURI = new java.net.URI(uri.toString());
                if (uri.hasTrailingPathSeparator()) {
                    iContainerArray = EcorePlugin.getWorkspaceRoot().findContainersForLocationURI(locationURI);
                    if (iContainerArray.length == 0) continue;
                    IContainer container = iContainerArray[0];
                    redirectedWorkspaceURI = URI.createPlatformResourceURI((String)container.getFullPath().toString(), (boolean)true).appendSegment("");
                    workspaceMappings.put(uri, redirectedWorkspaceURI);
                    continue;
                }
                iContainerArray = EcorePlugin.getWorkspaceRoot().findFilesForLocationURI(locationURI);
                if (iContainerArray.length == 0) continue;
                IContainer file = iContainerArray[0];
                redirectedWorkspaceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                workspaceMappings.put(uri, redirectedWorkspaceURI);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        uriMap.putAll(workspaceMappings);
        this.editingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (SetupEditor.this.contentOutlinePage != null) {
                    SetupEditor.this.contentOutlinePage.update(2);
                }
            }
        });
    }

    public BaseEditUtil.IconReflectiveItemProvider getReflectiveItemProvider() {
        return this.reflectiveItemProvider;
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewerGen(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (SetupEditor.this.currentViewer != null) {
                        SetupEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        if (this.currentViewer == this.selectionViewer) {
            for (Object object : collection) {
                if (!(object instanceof Resource)) continue;
                this.toggleInput(true);
                break;
            }
        }
        this.setSelectionToViewerGen(collection);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        SetupEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        ((OomphEditingDomain)this.editingDomain).registerDragAndDrop(viewer);
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        final ResourceSet resourceSet = this.editingDomain.getResourceSet();
        this.resourceMirror.perform((Object)resourceURI);
        final Resource mainResource = resourceSet.getResource(resourceURI, false);
        EList contents = mainResource.getContents();
        EObject rootObject = null;
        if (!contents.isEmpty() && !((rootObject = (EObject)contents.get(0)) instanceof Index)) {
            this.resourceMirror.perform((Object)SetupContext.INDEX_SETUP_URI);
        }
        try {
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
        }
        catch (RuntimeException runtimeException) {}
        for (Resource resource : resourceSet.getResources()) {
            Diagnostic diagnostic = this.analyzeResourceProblems(resource, null);
            if (diagnostic.getSeverity() == 0) continue;
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        if (!this.resourceMirror.isCanceled() && rootObject != null) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    EPackage ePackage = ((EObject)mainResource.getContents().get(0)).eClass().getEPackage();
                    URI ePackageResourceURI = ePackage.eResource().getURI();
                    if (ePackageResourceURI.isHierarchical() && ePackageResourceURI.trimSegments(1).equals(LEGACY_MODELS)) {
                        ArrayList migratedContents = new ArrayList();
                        try {
                            SetupCoreUtil.migrate((Resource)mainResource, migratedContents);
                            CompoundCommand command = new CompoundCommand(1, "Replace with Migrated Contents");
                            command.append((Command)new RemoveCommand((EditingDomain)SetupEditor.this.editingDomain, mainResource.getContents(), new ArrayList(mainResource.getContents())));
                            command.append((Command)new AddCommand((EditingDomain)SetupEditor.this.editingDomain, mainResource.getContents(), migratedContents));
                            SetupEditor.this.editingDomain.getCommandStack().execute((Command)command);
                        }
                        catch (RuntimeException ex) {
                            CompoundCommand command = new CompoundCommand(1, "Add Partially Migrated Contents");
                            command.append((Command)new AddCommand((EditingDomain)SetupEditor.this.editingDomain, mainResource.getContents(), migratedContents));
                            SetupEditor.this.editingDomain.getCommandStack().execute((Command)command);
                            SetupEditorPlugin.INSTANCE.log(ex);
                        }
                        EcoreUtil.resolveAll((Resource)mainResource);
                        for (Resource resource : resourceSet.getResources()) {
                            URI uri = resource.getURI();
                            if (!"bogus".equals(uri.scheme()) && !LEGACY_EXAMPLE_URI.equals(uri)) continue;
                            resource.getErrors().clear();
                            resource.getWarnings().clear();
                        }
                    }
                }
            });
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "org.eclipse.oomph.setup.editor", 0, SetupEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.oomph.setup.editor", 0, SetupEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        Tree tree = new Tree(this.getContainer(), 2);
        this.selectionViewer = new TreeViewer(tree);
        this.setCurrentViewer((Viewer)this.selectionViewer);
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object getParent(Object object) {
                Resource.Internal resource;
                if (object instanceof InternalEObject && (resource = ((InternalEObject)object).eDirectResource()) != null) {
                    return resource;
                }
                return super.getParent(object);
            }
        });
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new SetupLabelProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer), (ILabelDecorator)new DiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, (IDialogSettings)this.dialogSettings)){

            public String getText(Object element) {
                SetupTask setupTask;
                EList restrictions;
                String text = super.getText(element);
                if (element instanceof SetupTask && !(restrictions = (setupTask = (SetupTask)element).getRestrictions()).isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    for (Scope restriction : restrictions) {
                        String label;
                        if (builder.length() != 0) {
                            builder.append(", ");
                        }
                        if (StringUtil.isEmpty((String)(label = restriction.getLabel()))) {
                            label = restriction.getName();
                        }
                        builder.append(label);
                    }
                    String string = builder.toString();
                    string = text.contains(string) ? "" : ": " + string;
                    text = String.valueOf(text) + "  [restricted" + string + "]";
                }
                return text;
            }
        });
        this.selectionViewer.setInput((Object)this.loadingResourceInput);
        this.getViewer().getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    SetupEditor.this.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException ex) {
                    SetupEditorPlugin.INSTANCE.log(ex);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
        int pageIndex = this.addPage((Control)tree);
        this.setPageText(pageIndex, SetupEditor.getString("_UI_SelectionPage_label"));
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SetupEditor.this.getPageCount() > 0) {
                    SetupEditor.this.setActivePage(0);
                }
            }
        });
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    SetupEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.doLoad();
    }

    protected void doLoad() {
        final Display display = this.getSite().getShell().getDisplay();
        final Tree tree = this.selectionViewer.getTree();
        Job job = new Job("Loading Model"){

            public boolean belongsTo(Object family) {
                return family == SetupEditorSupport.FAMILY_MODEL_LOAD;
            }

            protected IStatus run(IProgressMonitor monitor) {
                final ResourceSet resourceSet = SetupEditor.this.editingDomain.getResourceSet();
                final ResourceMirror resourceMirror = new ResourceMirror(resourceSet){

                    protected void run(String taskName, IProgressMonitor monitor) {
                        SetupEditor.this.resourceMirror = this;
                        SetupEditor.this.createModel();
                        SetupEditor.this.dialogSettings.setLiveValidation(true);
                        SetupEditor.this.resourceMirror = null;
                    }
                };
                resourceMirror.begin(monitor);
                display.asyncExec(new Runnable(){

                    public void run() {
                        try {
                            boolean canceled;
                            tree.setRedraw(false);
                            SetupEditor.this.markReadOnlyResources();
                            Resource resource = (Resource)resourceSet.getResources().get(0);
                            EList contents = resource.getContents();
                            EObject rootObject = contents.isEmpty() ? null : (EObject)contents.get(0);
                            (this).SetupEditor.this.selectionViewer.setInput((this).SetupEditor.this.selectionViewer.getInput() == SetupEditor.this.loadingResourceInput ? resource : resourceSet);
                            if (rootObject != null) {
                                (this).SetupEditor.this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)rootObject), true);
                            }
                            if (!(canceled = resourceMirror.isCanceled())) {
                                if (rootObject instanceof Project) {
                                    EList streams = ((Project)rootObject).getStreams();
                                    if (streams.isEmpty()) {
                                        (this).SetupEditor.this.selectionViewer.expandToLevel((Object)rootObject, 1);
                                    } else {
                                        for (Stream branch : streams) {
                                            (this).SetupEditor.this.selectionViewer.expandToLevel((Object)branch, 1);
                                        }
                                    }
                                } else if (rootObject != null) {
                                    (this).SetupEditor.this.selectionViewer.expandToLevel((Object)rootObject, 1);
                                }
                                if ((this).SetupEditor.this.contentOutlinePage != null) {
                                    (this).SetupEditor.this.contentOutlinePage.update(2);
                                }
                                SetupEditor.this.getActionBarContributor().scheduleValidation();
                            }
                            SetupEditor.this.updateProblemIndication();
                        }
                        finally {
                            if (!tree.isDisposed()) {
                                tree.setRedraw(true);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        IProgressService progressService = this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        progressService.showInDialog(null, job);
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, SetupEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new OutlinePreviewPage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SetupEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        OomphPropertySheetPage propertySheetPage = new OomphPropertySheetPage(this.editingDomain, ExtendedPropertySheetPage.Decoration.LIVE, this.dialogSettings){
            {
                this.setSorter(new PropertySheetSorter(){

                    public void sort(IPropertySheetEntry[] entries) {
                    }
                });
            }

            public void setSelectionToViewer(List<?> selection) {
                SetupEditor.this.setSelectionToViewer(selection);
                SetupEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                SetupEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.contentOutlinePage != null && this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList<Object> selectionList = new ArrayList<Object>();
            selectionList.addAll(this.contentOutlinePage.getOriginals(selectedElement));
            while (selectedElements.hasNext()) {
                selectionList.addAll(this.contentOutlinePage.getOriginals(selectedElements.next()));
            }
            TreeViewer oldSectionViewer = this.selectionViewer;
            this.selectionViewer = null;
            oldSectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            this.selectionViewer = oldSectionViewer;
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    protected void doRevert() {
        Object input = this.selectionViewer.getInput();
        this.selectionViewer.setInput((Object)(input instanceof Resource ? this.loadingResourceInput : this.loadingResourceSetInput));
        this.dialogSettings.setLiveValidation(false);
        EList resources = this.editingDomain.getResourceSet().getResources();
        for (Resource resource : resources) {
            resource.unload();
        }
        resources.clear();
        this.resourceToDiagnosticMap.clear();
        this.editingDomain.getCommandStack().flush();
        this.doLoad();
    }

    public void doSaveGen(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                EList resources = SetupEditor.this.editingDomain.getResourceSet().getResources();
                int i = 0;
                while (i < resources.size()) {
                    Resource resource = (Resource)resources.get(i);
                    if ((first || !resource.getContents().isEmpty() || SetupEditor.this.isPersisted(resource)) && !SetupEditor.this.editingDomain.isReadOnly(resource)) {
                        try {
                            long timeStamp = resource.getTimeStamp();
                            resource.save(saveOptions);
                            if (resource.getTimeStamp() != timeStamp) {
                                SetupEditor.this.savedResources.add(resource);
                            }
                        }
                        catch (Exception exception) {
                            SetupEditor.this.resourceToDiagnosticMap.put(resource, SetupEditor.this.analyzeResourceProblems(resource, exception));
                        }
                        first = false;
                    }
                    ++i;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            SetupEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        EList resources = this.editingDomain.getResourceSet().getResources();
        int i = 1;
        while (i < resources.size()) {
            Resource resource = (Resource)resources.get(i);
            if (resource.getContents().isEmpty() && !resource.getErrors().isEmpty()) {
                this.resourceToDiagnosticMap.remove(resource);
                resources.remove(i);
                resource.unload();
                continue;
            }
            ++i;
        }
        this.markReadOnlyResources();
        this.doSaveGen(progressMonitor);
        this.getActionBarContributor().scheduleValidation();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    public void toggleInput() {
        this.toggleInput(false);
    }

    private void toggleInput(boolean forceResourceSet) {
        ISelection selection = this.selectionViewer.getSelection();
        Object[] expandedElements = this.selectionViewer.getExpandedElements();
        Object input = this.selectionViewer.getInput();
        if (input instanceof ResourceSet) {
            if (forceResourceSet) {
                return;
            }
            Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            this.selectionViewer.setInput((Object)resource);
        } else if (input instanceof Resource) {
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
        } else if (input == this.loadingResourceInput) {
            if (forceResourceSet) {
                return;
            }
            this.selectionViewer.setInput((Object)this.loadingResourceSetInput);
        } else if (input == this.loadingResourceSetInput) {
            this.selectionViewer.setInput((Object)this.loadingResourceInput);
        }
        this.selectionViewer.setExpandedElements(expandedElements);
        this.selectionViewer.setSelection(selection);
    }

    protected void markReadOnlyResources() {
        EList resources = this.editingDomain.getResourceSet().getResources();
        Map resourceToReadOnlyMap = this.editingDomain.getResourceToReadOnlyMap();
        resourceToReadOnlyMap.remove(resources.get(0));
        int i = 1;
        int size = resources.size();
        while (i < size) {
            resourceToReadOnlyMap.put((Resource)resources.get(i), Boolean.TRUE);
            ++i;
        }
    }

    public void initGen(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        final IResourceChangeListener delegateResourceChangeListener = this.resourceChangeListener;
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (SetupEditor.this.resourceMirror == null) {
                    delegateResourceChangeListener.resourceChanged(event);
                }
            }
        };
        site.getWorkbenchWindow().getWorkbench().addWindowListener(this.windowListener);
        this.initGen(site, editorInput);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(SetupEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(SetupEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(SetupEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return SetupEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return SetupEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public SetupActionBarContributor getActionBarContributor() {
        return (SetupActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getWorkbench().removeWindowListener(this.windowListener);
        this.disposeGen();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public static class DelegatingDialogSettings
    implements IDialogSettings {
        private final IDialogSettings dialogSettings = SetupEditorPlugin.INSTANCE.getDialogSettings();
        private boolean liveValidation;

        public void setLiveValidation(boolean liveValidation) {
            this.liveValidation = liveValidation;
        }

        public IDialogSettings addNewSection(String name) {
            return this.dialogSettings.addNewSection(name);
        }

        public void addSection(IDialogSettings section) {
            this.dialogSettings.addSection(section);
        }

        public String get(String key) {
            return this.dialogSettings.get(key);
        }

        public String[] getArray(String key) {
            return this.dialogSettings.getArray(key);
        }

        public boolean getBoolean(String key) {
            if ("liveValidator".equals(key) && !this.liveValidation) {
                return false;
            }
            return this.dialogSettings.getBoolean(key);
        }

        public double getDouble(String key) throws NumberFormatException {
            return this.dialogSettings.getDouble(key);
        }

        public float getFloat(String key) throws NumberFormatException {
            return this.dialogSettings.getFloat(key);
        }

        public int getInt(String key) throws NumberFormatException {
            return this.dialogSettings.getInt(key);
        }

        public long getLong(String key) throws NumberFormatException {
            return this.dialogSettings.getLong(key);
        }

        public String getName() {
            return this.dialogSettings.getName();
        }

        public IDialogSettings getSection(String sectionName) {
            return this.dialogSettings.getSection(sectionName);
        }

        public IDialogSettings[] getSections() {
            return this.dialogSettings.getSections();
        }

        public void load(Reader reader) throws IOException {
            this.dialogSettings.load(reader);
        }

        public void load(String fileName) throws IOException {
            this.dialogSettings.load(fileName);
        }

        public void put(String key, String[] value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, double value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, float value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, int value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, long value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, String value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, boolean value) {
            this.dialogSettings.put(key, value);
        }

        public void save(Writer writer) throws IOException {
            this.dialogSettings.save(writer);
        }

        public void save(String fileName) throws IOException {
            this.dialogSettings.save(fileName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OutlinePreviewPage
    extends ContentOutlinePage {
        private ILabelProvider labelProvider;
        private Trigger trigger;
        private Map<Object, Set<Object>> copyMap = new HashMap<Object, Set<Object>>();
        private Map<Object, Set<Object>> inverseCopyMap = new HashMap<Object, Set<Object>>();
        private Map<Object, Object> parents = new HashMap<Object, Object>();
        private AdapterFactoryEditingDomain.EditingDomainProvider editingDomainProvider;

        OutlinePreviewPage() {
            this.editingDomainProvider = new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)SetupEditor.this.editingDomain);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            SetupEditor.this.contentOutlineViewer = this.getTreeViewer();
            SetupEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            SetupEditor.this.contentOutlineViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer != null) {
                        ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer.getControl().setFocus();
                        SetupEditor.this.setSelection(((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer.getSelection());
                    }
                }
            });
            SetupEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)SetupEditor.this.adapterFactory){

                public boolean hasChildren(Object object) {
                    return object instanceof VariableTask && OutlinePreviewPage.this.parents.get(object) instanceof VariableContainer || super.hasChildren(object);
                }

                public Object[] getChildren(Object object) {
                    if (object instanceof VariableTask && OutlinePreviewPage.this.parents.get(object) instanceof VariableContainer) {
                        Resource resource = (Resource)((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.editingDomain.getResourceSet().getResources().get(0);
                        SetupTaskPerformer setupTaskPerformer = ((VariableContainer)((Object)OutlinePreviewPage.this.parents.get(object))).getSetupTaskPerformer();
                        VariableTask contextVariableTask = (VariableTask)object;
                        String name = contextVariableTask.getName();
                        ArrayList<EObject> variableUsages = new ArrayList<EObject>();
                        block0: for (Object o : OutlinePreviewPage.this.copyMap.keySet()) {
                            EObject eObject;
                            if (!(o instanceof EObject) || (eObject = (EObject)o).eResource() != resource) continue;
                            block1: for (EAttribute attribute : eObject.eClass().getEAllAttributes()) {
                                Set variables;
                                if (!attribute.isChangeable() || attribute.getEAttributeType().getInstanceClassName() != "java.lang.String" || attribute == SetupPackage.Literals.VARIABLE_TASK__NAME) continue;
                                if (attribute.isMany()) {
                                    List values = (List)eObject.eGet((EStructuralFeature)attribute);
                                    for (String value : values) {
                                        Set variables2 = setupTaskPerformer.getVariables(value);
                                        if (!variables2.contains(name)) continue;
                                        variableUsages.add(eObject);
                                        continue block1;
                                    }
                                    continue;
                                }
                                String value = (String)eObject.eGet((EStructuralFeature)attribute);
                                if (value == null || !(variables = setupTaskPerformer.getVariables(value)).contains(name)) continue;
                                variableUsages.add(eObject);
                                continue block0;
                            }
                        }
                        variableUsages.addAll((Collection<EObject>)contextVariableTask.getChoices());
                        for (EObject eObject : variableUsages) {
                            OutlinePreviewPage.this.parents.put(eObject, object);
                        }
                        return variableUsages.toArray();
                    }
                    return super.getChildren(object);
                }

                public Object getParent(Object object) {
                    Object parent = OutlinePreviewPage.this.parents.get(object);
                    return parent != null ? parent : super.getParent(object);
                }
            });
            final Font font = SetupEditor.this.contentOutlineViewer.getControl().getFont();
            this.labelProvider = new SetupLabelProvider((AdapterFactory)SetupEditor.this.adapterFactory, (Viewer)SetupEditor.this.contentOutlineViewer){

                public Font getFont(Object object) {
                    SetupTask setupTask;
                    Resource resource;
                    Font result = super.getFont(object);
                    if (object instanceof SetupTask && ((resource = (setupTask = (SetupTask)object).eResource()) == null || !((Resource)((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.editingDomain.getResourceSet().getResources().get(0)).getURI().equals(resource.getURI()))) {
                        result = ExtendedFontRegistry.INSTANCE.getFont(result != null ? result : font, (Object)IItemFontProvider.ITALIC_FONT);
                    }
                    return result;
                }
            };
            SetupEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            SetupEditor.this.createContextMenuFor((StructuredViewer)SetupEditor.this.contentOutlineViewer);
            SetupEditor.this.selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer != null && !selection.isEmpty()) {
                        ArrayList<Object> selectionList = new ArrayList<Object>();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            this.collectSelection(selectionList, object);
                            ++n2;
                        }
                        if (!selectionList.isEmpty()) {
                            ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage = null;
                            OutlinePreviewPage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection(selectionList));
                            ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage = OutlinePreviewPage.this;
                        }
                    }
                }

                private void collectSelection(List<Object> selection, Object object) {
                    if (object instanceof CompoundTask) {
                        for (SetupTask setupTask : ((CompoundTask)object).getSetupTasks()) {
                            this.collectSelection(selection, setupTask);
                        }
                    } else {
                        Set<Object> copies = ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage.getCopies(object);
                        if (copies != null) {
                            selection.addAll(copies);
                        }
                    }
                }
            });
            SetupEditor.this.contentOutlineViewer.expandToLevel(2);
        }

        public Set<Object> getOriginals(Object object) {
            Set<Object> result = this.inverseCopyMap.get(object);
            return result == null ? Collections.singleton(object) : result;
        }

        public Set<Object> getCopies(Object object) {
            return this.copyMap.get(object);
        }

        public void update(int expandLevel) {
            if (this.labelProvider != null) {
                this.copyMap.clear();
                try {
                    Project project;
                    ResourceSet resourceSet = SetupEditor.this.editingDomain.getResourceSet();
                    EList resources = resourceSet.getResources();
                    if (!resources.isEmpty() && (project = (Project)EcoreUtil.getObjectByType((Collection)((Resource)resources.get(0)).getContents(), (EClassifier)SetupPackage.Literals.PROJECT)) != null) {
                        ItemProvider input = this.getTriggeredTasks(project);
                        this.getTreeViewer().setInput((Object)input);
                    }
                }
                catch (Exception ex) {
                    SetupEditorPlugin.INSTANCE.log(ex);
                }
                for (Map.Entry<Object, Set<Object>> entry : this.copyMap.entrySet()) {
                    Set<Object> values = entry.getValue();
                    for (Object value : values) {
                        Set<Object> eObjects = this.inverseCopyMap.get(value);
                        if (eObjects == null) {
                            eObjects = new HashSet<Object>();
                            this.inverseCopyMap.put(value, eObjects);
                        }
                        eObjects.add(entry.getKey());
                    }
                }
                this.getTreeViewer().expandToLevel(expandLevel);
            }
        }

        private List<String> sortStrings(Collection<? extends String> strings) {
            BasicEList pairs = new BasicEList();
            for (String string : strings) {
                pairs.add((Object)new Pair((Object)SegmentSequence.create((String)".", (String)string), (Object)string));
            }
            Pair[] pairArray = (Pair[])pairs.toArray((Object[])new Pair[pairs.size()]);
            return this.sort(pairArray);
        }

        private List<VariableTask> sortVariables(Collection<? extends VariableTask> variables) {
            BasicEList pairs = new BasicEList();
            for (VariableTask variableTask : variables) {
                pairs.add((Object)new Pair((Object)SegmentSequence.create((String)".", (String)variableTask.getName()), (Object)variableTask));
            }
            Pair[] pairArray = (Pair[])pairs.toArray((Object[])new Pair[pairs.size()]);
            return this.sort(pairArray);
        }

        private <T> List<T> sort(Pair<SegmentSequence, T>[] pairs) {
            Arrays.sort(pairs, new Comparator<Pair<SegmentSequence, T>>(){
                private final Comparator<String> comparator = CommonPlugin.INSTANCE.getComparator();

                @Override
                public int compare(Pair<SegmentSequence, T> o1, Pair<SegmentSequence, T> o2) {
                    SegmentSequence s1 = (SegmentSequence)o1.getElement1();
                    SegmentSequence s2 = (SegmentSequence)o2.getElement1();
                    if (s1 == null) {
                        if (s2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    int length1 = s1.segmentCount();
                    int length2 = s2.segmentCount();
                    int length = Math.min(length1, length2);
                    int i = 0;
                    while (i < length) {
                        String e2;
                        String e1 = s1.segment(i);
                        int result = this.comparator.compare(e1, e2 = s2.segment(i));
                        if (result != 0) {
                            return result;
                        }
                        ++i;
                    }
                    return length1 - length2;
                }
            });
            ArrayList<Object> result = new ArrayList<Object>(pairs.length);
            Pair<SegmentSequence, T>[] pairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<SegmentSequence, T> pair = pairArray[n2];
                result.add(pair.getElement2());
                ++n2;
            }
            return result;
        }

        private ItemProvider getTriggeredTasks(Project project) {
            ItemProvider projectItem = new ItemProvider(this.labelProvider.getText((Object)project), (Object)this.labelProvider.getImage((Object)project));
            EList projectItemChildren = projectItem.getChildren();
            EList streams = project.getStreams();
            for (Stream stream : streams) {
                EObject rootContainer;
                ItemProvider branchItem = new ItemProvider(this.labelProvider.getText((Object)stream), (Object)this.labelProvider.getImage((Object)stream));
                projectItemChildren.add((Object)branchItem);
                ProductVersion version = null;
                ProjectCatalog projectCatalog = project.getProjectCatalog();
                if (projectCatalog != null && (rootContainer = EcoreUtil.getRootContainer((EObject)projectCatalog)) instanceof Index) {
                    Iterator index = (Index)rootContainer;
                    block1: for (ProductCatalog productCatalog : index.getProductCatalogs()) {
                        for (Product product : productCatalog.getProducts()) {
                            ProductVersion productVersion;
                            Iterator iterator = product.getVersions().iterator();
                            if (!iterator.hasNext()) continue;
                            version = productVersion = (ProductVersion)iterator.next();
                            break block1;
                        }
                    }
                }
                if (version != null) {
                    for (SetupTask setupTask : version.getProduct().getSetupTasks()) {
                        VariableTask variable;
                        if (!(setupTask instanceof VariableTask) || !"installation.location".equals((variable = (VariableTask)setupTask).getName())) continue;
                        EcoreUtil.delete((EObject)variable);
                        break;
                    }
                    version.getSetupTasks().clear();
                    SetupContext setupContext = SetupContext.create(version, (Stream)stream);
                    URIConverter uriConverter = SetupEditor.this.getEditingDomain().getResourceSet().getURIConverter();
                    SetupTaskPerformer setupTaskPerformer = new SetupTaskPerformer(uriConverter, SetupPrompter.CANCEL, this.trigger, setupContext, stream);
                    setupTaskPerformer.redirectTriggeredSetupTasks();
                    ArrayList triggeredSetupTasks = new ArrayList(setupTaskPerformer.getTriggeredSetupTasks());
                    if (!triggeredSetupTasks.isEmpty()) {
                        for (EObject eObject : setupTaskPerformer.getCopyMap().values()) {
                            Resource.Internal resource = ((InternalEObject)eObject).eDirectResource();
                            if (resource == null || resource.eAdapters().contains((Object)this.editingDomainProvider)) continue;
                            resource.eAdapters().add((Object)this.editingDomainProvider);
                        }
                        VariableContainer undeclaredVariablesItem = new VariableContainer(setupTaskPerformer, "Undeclared Variables", UNDECLARED_VARIABLE_GROUP_IMAGE);
                        EList undeclaredVariablesItemChildren = undeclaredVariablesItem.getChildren();
                        Set undeclaredVariables = setupTaskPerformer.getUndeclaredVariables();
                        for (String key : this.sortStrings(undeclaredVariables)) {
                            VariableTask contextVariableTask = SetupFactory.eINSTANCE.createVariableTask();
                            contextVariableTask.setName(key);
                            undeclaredVariablesItemChildren.add((Object)contextVariableTask);
                            this.parents.put(contextVariableTask, (Object)undeclaredVariablesItem);
                        }
                        if (!undeclaredVariablesItemChildren.isEmpty()) {
                            branchItem.getChildren().add((Object)undeclaredVariablesItem);
                        }
                        VariableContainer unresolvedVariablesItem = new VariableContainer(setupTaskPerformer, "Unresolved Variables", VARIABLE_GROUP_IMAGE);
                        EList unresolvedVariablesItemChildren = unresolvedVariablesItem.getChildren();
                        List unresolvedVariables = setupTaskPerformer.getUnresolvedVariables();
                        for (VariableTask contextVariableTask : this.sortVariables(unresolvedVariables)) {
                            unresolvedVariablesItemChildren.add((Object)contextVariableTask);
                            this.parents.put(contextVariableTask, (Object)unresolvedVariablesItem);
                        }
                        if (!unresolvedVariablesItemChildren.isEmpty()) {
                            branchItem.getChildren().add((Object)unresolvedVariablesItem);
                        }
                        VariableContainer resolvedVariablesItem = new VariableContainer(setupTaskPerformer, "Resolved Variables", VARIABLE_GROUP_IMAGE);
                        EList resolvedVariablesItemChildren = resolvedVariablesItem.getChildren();
                        List resolvedVariables = setupTaskPerformer.getResolvedVariables();
                        for (VariableTask variableTask : this.sortVariables(resolvedVariables)) {
                            resolvedVariablesItemChildren.add((Object)variableTask);
                            this.parents.put(variableTask, (Object)resolvedVariablesItem);
                        }
                        if (!resolvedVariablesItemChildren.isEmpty()) {
                            branchItem.getChildren().add((Object)resolvedVariablesItem);
                        }
                        branchItem.getChildren().addAll(triggeredSetupTasks);
                        for (SetupTask setupTask : triggeredSetupTasks) {
                            this.parents.put(setupTask, branchItem);
                        }
                        for (Map.Entry entry : setupTaskPerformer.getCopyMap().entrySet()) {
                            this.add(this.copyMap, entry.getKey(), entry.getValue());
                        }
                        this.add(this.copyMap, stream, branchItem);
                    }
                }
                this.add(this.copyMap, project, projectItem);
            }
            for (Project subproject : project.getProjects()) {
                projectItemChildren.add((Object)this.getTriggeredTasks(subproject));
            }
            return projectItem;
        }

        private <K, V> void add(Map<K, Set<V>> map, K key, V value) {
            Set<V> set = map.get(key);
            if (set == null) {
                set = new HashSet<V>();
                map.put(key, set);
            }
            set.add(value);
        }

        public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
            super.makeContributions(menuManager, toolBarManager, statusLineManager);
            SetupEditor.this.contentOutlineStatusLineManager = statusLineManager;
        }

        public void setActionBars(IActionBars actionBars) {
            super.setActionBars(actionBars);
            actionBars.getToolBarManager().add((IAction)new Action("Show tasks for all triggers", 8){
                {
                    this.setChecked(true);
                    this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage("AllTrigger")));
                }

                public void run() {
                    OutlinePreviewPage.this.trigger = null;
                    OutlinePreviewPage.this.update(2);
                }
            });
            for (final Trigger trigger : Trigger.VALUES) {
                String label = trigger.getLiteral().toLowerCase();
                actionBars.getToolBarManager().add((IAction)new Action("Show tasks for the " + label + " trigger", 8, label){
                    {
                        super($anonymous0, $anonymous1);
                        this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage(String.valueOf(StringUtil.cap((String)string)) + "Trigger")));
                    }

                    public void run() {
                        OutlinePreviewPage.this.trigger = trigger;
                        super.run();
                        OutlinePreviewPage.this.update(2);
                    }
                });
            }
            SetupEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
        }

        private class VariableContainer
        extends ItemProvider {
            private SetupTaskPerformer setupTaskPerformer;

            public VariableContainer(SetupTaskPerformer setupTaskPerformer, String text, Object image) {
                super(text, image);
                this.setupTaskPerformer = setupTaskPerformer;
            }

            public SetupTaskPerformer getSetupTaskPerformer() {
                return this.setupTaskPerformer;
            }
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

