/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.junit;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.junit.JUnitPackage;
import org.eclipse.oomph.junit.ProblemType;
import org.eclipse.oomph.junit.PropertiesType;
import org.eclipse.oomph.junit.TestCaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite
extends MinimalEObjectImpl.Container {
    protected PropertiesType properties;
    protected EList<TestCaseType> testCases;
    protected static final String SYSTEM_OUT_EDEFAULT = null;
    protected String systemOut = SYSTEM_OUT_EDEFAULT;
    protected static final String SYSTEM_ERR_EDEFAULT = null;
    protected String systemErr = SYSTEM_ERR_EDEFAULT;
    protected static final int ERRORS_EDEFAULT = 0;
    protected int errors = 0;
    protected boolean errorsESet;
    protected static final int FAILURES_EDEFAULT = 0;
    protected int failures = 0;
    protected boolean failuresESet;
    protected static final String HOST_NAME_EDEFAULT = null;
    protected String hostName = HOST_NAME_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final int TESTS_EDEFAULT = 0;
    protected int tests = 0;
    protected boolean testsESet;
    protected static final double TIME_EDEFAULT = 0.0;
    protected double time = 0.0;
    protected static final long TIMESTAMP_EDEFAULT = 0L;
    protected long timestamp = 0L;
    protected boolean timestampESet;

    protected TestSuite() {
    }

    public void summarize() {
        int count = 0;
        int errorCount = 0;
        int failureCount = 0;
        double totalTime = 0.0;
        for (TestCaseType testCase : this.getTestCases()) {
            ProblemType failure;
            ++count;
            ProblemType error = testCase.getError();
            if (error != null) {
                ++errorCount;
            }
            if ((failure = testCase.getFailure()) != null) {
                ++failureCount;
            }
            double time = testCase.getTime();
            totalTime += time;
        }
        this.setTests(count);
        this.setErrors(errorCount);
        this.setFailures(failureCount);
        this.setTime(totalTime);
    }

    protected EClass eStaticClass() {
        return JUnitPackage.Literals.TEST_SUITE;
    }

    public PropertiesType getProperties() {
        return this.properties;
    }

    public NotificationChain basicSetProperties(PropertiesType newProperties, NotificationChain msgs) {
        PropertiesType oldProperties = this.properties;
        this.properties = newProperties;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldProperties, (Object)newProperties);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setProperties(PropertiesType newProperties) {
        if (newProperties != this.properties) {
            NotificationChain msgs = null;
            if (this.properties != null) {
                msgs = this.properties.eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newProperties != null) {
                msgs = newProperties.eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetProperties(newProperties, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newProperties, (Object)newProperties));
        }
    }

    public EList<TestCaseType> getTestCases() {
        if (this.testCases == null) {
            this.testCases = new EObjectContainmentEList(TestCaseType.class, (InternalEObject)this, 1);
        }
        return this.testCases;
    }

    public String getSystemOut() {
        return this.systemOut;
    }

    public void setSystemOut(String newSystemOut) {
        String oldSystemOut = this.systemOut;
        this.systemOut = newSystemOut;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSystemOut, (Object)this.systemOut));
        }
    }

    public String getSystemErr() {
        return this.systemErr;
    }

    public void setSystemErr(String newSystemErr) {
        String oldSystemErr = this.systemErr;
        this.systemErr = newSystemErr;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldSystemErr, (Object)this.systemErr));
        }
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int newErrors) {
        int oldErrors = this.errors;
        this.errors = newErrors;
        boolean oldErrorsESet = this.errorsESet;
        this.errorsESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldErrors, this.errors, !oldErrorsESet));
        }
    }

    public void unsetErrors() {
        int oldErrors = this.errors;
        boolean oldErrorsESet = this.errorsESet;
        this.errors = 0;
        this.errorsESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 4, oldErrors, 0, oldErrorsESet));
        }
    }

    public boolean isSetErrors() {
        return this.errorsESet;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int newFailures) {
        int oldFailures = this.failures;
        this.failures = newFailures;
        boolean oldFailuresESet = this.failuresESet;
        this.failuresESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldFailures, this.failures, !oldFailuresESet));
        }
    }

    public void unsetFailures() {
        int oldFailures = this.failures;
        boolean oldFailuresESet = this.failuresESet;
        this.failures = 0;
        this.failuresESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, oldFailures, 0, oldFailuresESet));
        }
    }

    public boolean isSetFailures() {
        return this.failuresESet;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String newHostName) {
        String oldHostName = this.hostName;
        this.hostName = newHostName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldHostName, (Object)this.hostName));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldName, (Object)this.name));
        }
    }

    public int getTests() {
        return this.tests;
    }

    public void setTests(int newTests) {
        int oldTests = this.tests;
        this.tests = newTests;
        boolean oldTestsESet = this.testsESet;
        this.testsESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldTests, this.tests, !oldTestsESet));
        }
    }

    public void unsetTests() {
        int oldTests = this.tests;
        boolean oldTestsESet = this.testsESet;
        this.tests = 0;
        this.testsESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 8, oldTests, 0, oldTestsESet));
        }
    }

    public boolean isSetTests() {
        return this.testsESet;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double newTime) {
        double oldTime = this.time;
        this.time = newTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldTime, this.time));
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long newTimestamp) {
        long oldTimestamp = this.timestamp;
        this.timestamp = newTimestamp;
        boolean oldTimestampESet = this.timestampESet;
        this.timestampESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldTimestamp, this.timestamp, !oldTimestampESet));
        }
    }

    public void unsetTimestamp() {
        long oldTimestamp = this.timestamp;
        boolean oldTimestampESet = this.timestampESet;
        this.timestamp = 0L;
        this.timestampESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 10, oldTimestamp, 0L, oldTimestampESet));
        }
    }

    public boolean isSetTimestamp() {
        return this.timestampESet;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetProperties(null, msgs);
            }
            case 1: {
                return ((InternalEList)this.getTestCases()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getProperties();
            }
            case 1: {
                return this.getTestCases();
            }
            case 2: {
                return this.getSystemOut();
            }
            case 3: {
                return this.getSystemErr();
            }
            case 4: {
                return this.getErrors();
            }
            case 5: {
                return this.getFailures();
            }
            case 6: {
                return this.getHostName();
            }
            case 7: {
                return this.getName();
            }
            case 8: {
                return this.getTests();
            }
            case 9: {
                return this.getTime();
            }
            case 10: {
                return this.getTimestamp();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setProperties((PropertiesType)((Object)newValue));
                return;
            }
            case 1: {
                this.getTestCases().clear();
                this.getTestCases().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setSystemOut((String)newValue);
                return;
            }
            case 3: {
                this.setSystemErr((String)newValue);
                return;
            }
            case 4: {
                this.setErrors((Integer)newValue);
                return;
            }
            case 5: {
                this.setFailures((Integer)newValue);
                return;
            }
            case 6: {
                this.setHostName((String)newValue);
                return;
            }
            case 7: {
                this.setName((String)newValue);
                return;
            }
            case 8: {
                this.setTests((Integer)newValue);
                return;
            }
            case 9: {
                this.setTime((Double)newValue);
                return;
            }
            case 10: {
                this.setTimestamp((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setProperties(null);
                return;
            }
            case 1: {
                this.getTestCases().clear();
                return;
            }
            case 2: {
                this.setSystemOut(SYSTEM_OUT_EDEFAULT);
                return;
            }
            case 3: {
                this.setSystemErr(SYSTEM_ERR_EDEFAULT);
                return;
            }
            case 4: {
                this.unsetErrors();
                return;
            }
            case 5: {
                this.unsetFailures();
                return;
            }
            case 6: {
                this.setHostName(HOST_NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 8: {
                this.unsetTests();
                return;
            }
            case 9: {
                this.setTime(0.0);
                return;
            }
            case 10: {
                this.unsetTimestamp();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.properties != null;
            }
            case 1: {
                return this.testCases != null && !this.testCases.isEmpty();
            }
            case 2: {
                return SYSTEM_OUT_EDEFAULT == null ? this.systemOut != null : !SYSTEM_OUT_EDEFAULT.equals(this.systemOut);
            }
            case 3: {
                return SYSTEM_ERR_EDEFAULT == null ? this.systemErr != null : !SYSTEM_ERR_EDEFAULT.equals(this.systemErr);
            }
            case 4: {
                return this.isSetErrors();
            }
            case 5: {
                return this.isSetFailures();
            }
            case 6: {
                return HOST_NAME_EDEFAULT == null ? this.hostName != null : !HOST_NAME_EDEFAULT.equals(this.hostName);
            }
            case 7: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 8: {
                return this.isSetTests();
            }
            case 9: {
                return this.time != 0.0;
            }
            case 10: {
                return this.isSetTimestamp();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (systemOut: ");
        result.append(this.systemOut);
        result.append(", systemErr: ");
        result.append(this.systemErr);
        result.append(", errors: ");
        if (this.errorsESet) {
            result.append(this.errors);
        } else {
            result.append("<unset>");
        }
        result.append(", failures: ");
        if (this.failuresESet) {
            result.append(this.failures);
        } else {
            result.append("<unset>");
        }
        result.append(", hostName: ");
        result.append(this.hostName);
        result.append(", name: ");
        result.append(this.name);
        result.append(", tests: ");
        if (this.testsESet) {
            result.append(this.tests);
        } else {
            result.append("<unset>");
        }
        result.append(", time: ");
        result.append(this.time);
        result.append(", timestamp: ");
        if (this.timestampESet) {
            result.append(this.timestamp);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

