/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.AbstractWorkingSet;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;

public class AggregateWorkingSet
extends AbstractWorkingSet
implements IAggregateWorkingSet,
IPropertyChangeListener {
    private IWorkingSet[] components;
    private boolean inElementConstruction = false;

    public AggregateWorkingSet(String name, String label, IWorkingSet[] components) {
        super(name, label);
        IWorkingSet[] componentCopy = new IWorkingSet[components.length];
        System.arraycopy(components, 0, componentCopy, 0, components.length);
        this.internalSetComponents(componentCopy);
        this.constructElements(false);
    }

    public AggregateWorkingSet(String name, String label, IMemento memento) {
        super(name, label);
        String uniqueId;
        this.workingSetMemento = memento;
        if (this.workingSetMemento != null && (uniqueId = this.workingSetMemento.getString("id")) != null) {
            this.setUniqueId(uniqueId);
        }
    }

    void setComponents(IWorkingSet[] components) {
        this.internalSetComponents(components);
        this.constructElements(true);
    }

    private void internalSetComponents(IWorkingSet[] components) {
        this.components = components;
    }

    private void constructElements(boolean fireEvent) {
        if (this.inElementConstruction) {
            String msg = NLS.bind((String)WorkbenchMessages.ProblemCyclicDependency, (Object)this.getName());
            WorkbenchPlugin.log(msg);
            throw new IllegalStateException(msg);
        }
        this.inElementConstruction = true;
        try {
            LinkedHashSet<IAdaptable> elements = new LinkedHashSet<IAdaptable>();
            IWorkingSet[] localComponents = this.getComponentsInternal();
            int i = 0;
            while (i < localComponents.length) {
                IWorkingSet workingSet = localComponents[i];
                try {
                    IAdaptable[] componentElements = workingSet.getElements();
                    elements.addAll(Arrays.asList(componentElements));
                }
                catch (IllegalStateException illegalStateException) {
                    IWorkingSet[] tmp = new IWorkingSet[this.components.length - 1];
                    if (i > 0) {
                        System.arraycopy(this.components, 0, tmp, 0, i);
                    }
                    if (this.components.length - i - 1 > 0) {
                        System.arraycopy(this.components, i + 1, tmp, i, this.components.length - i - 1);
                    }
                    this.components = tmp;
                    this.workingSetMemento = null;
                    this.fireWorkingSetChanged("workingSetContentChange", null);
                }
                ++i;
            }
            this.internalSetElements(elements.toArray(new IAdaptable[elements.size()]));
            if (fireEvent) {
                this.fireWorkingSetChanged("workingSetContentChange", null);
            }
        }
        finally {
            this.inElementConstruction = false;
        }
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_WORKING_SETS");
    }

    @Override
    public void setElements(IAdaptable[] elements) {
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void saveState(IMemento memento) {
        if (this.workingSetMemento != null) {
            memento.putMemento(this.workingSetMemento);
        } else {
            memento.putString("name", this.getName());
            memento.putString("label", this.getLabel());
            memento.putString("id", this.getUniqueId());
            memento.putString("aggregate", Boolean.TRUE.toString());
            IWorkingSet[] iWorkingSetArray = this.getComponentsInternal();
            int n = iWorkingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                memento.createChild("workingSet", workingSet.getName());
                ++n2;
            }
        }
    }

    @Override
    public void connect(IWorkingSetManager manager) {
        manager.addPropertyChangeListener(this);
        super.connect(manager);
    }

    @Override
    public void disconnect() {
        IWorkingSetManager connectedManager = this.getManager();
        if (connectedManager != null) {
            connectedManager.removePropertyChangeListener(this);
        }
        super.disconnect();
    }

    @Override
    public IWorkingSet[] getComponents() {
        IWorkingSet[] localComponents = this.getComponentsInternal();
        IWorkingSet[] copiedArray = new IWorkingSet[localComponents.length];
        System.arraycopy(localComponents, 0, copiedArray, 0, localComponents.length);
        return copiedArray;
    }

    private IWorkingSet[] getComponentsInternal() {
        if (this.components == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.components;
    }

    public void propertyChange(PropertyChangeEvent event) {
        block4: {
            IWorkingSet[] localComponents;
            String property;
            block5: {
                property = event.getProperty();
                if (!property.equals("workingSetRemove")) break block5;
                Object[] localComponents2 = this.getComponentsInternal();
                int i = 0;
                while (i < localComponents2.length) {
                    IWorkingSet set = localComponents2[i];
                    if (set.equals(event.getOldValue())) {
                        Object[] newComponents = new IWorkingSet[localComponents2.length - 1];
                        Util.arrayCopyWithRemoval(localComponents2, newComponents, i);
                        this.setComponents((IWorkingSet[])newComponents);
                    }
                    ++i;
                }
                break block4;
            }
            if (!property.equals("workingSetContentChange")) break block4;
            IWorkingSet[] iWorkingSetArray = localComponents = this.getComponentsInternal();
            int n = localComponents.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet set = iWorkingSetArray[n2];
                if (set.equals(event.getNewValue())) {
                    this.constructElements(true);
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    void restoreWorkingSet() {
        IWorkingSetManager manager = this.getManager();
        if (manager == null) {
            throw new IllegalStateException();
        }
        IMemento[] workingSetReferences = this.workingSetMemento.getChildren("workingSet");
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>(workingSetReferences.length);
        IMemento[] iMementoArray = workingSetReferences;
        int n = workingSetReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            String setId = memento.getID();
            IWorkingSet set = manager.getWorkingSet(setId);
            if (set != null) {
                list.add(set);
            }
            ++n2;
        }
        this.internalSetComponents(list.toArray(new IWorkingSet[list.size()]));
        this.constructElements(false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AggregateWorkingSet) {
            AggregateWorkingSet workingSet = (AggregateWorkingSet)object;
            return Objects.equals(workingSet.getName(), this.getName()) && Arrays.equals(workingSet.getComponentsInternal(), this.getComponentsInternal());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() & Arrays.hashCode(this.getComponentsInternal());
    }

    @Override
    public boolean isSelfUpdating() {
        IWorkingSet[] localComponents = this.getComponentsInternal();
        if (localComponents == null || localComponents.length == 0) {
            return false;
        }
        IWorkingSet[] iWorkingSetArray = localComponents;
        int n = localComponents.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet localComponent = iWorkingSetArray[n2];
            if (!localComponent.isSelfUpdating()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isAggregateWorkingSet() {
        return true;
    }

    @Override
    public IAdaptable[] adaptElements(IAdaptable[] objects) {
        return new IAdaptable[0];
    }

    public String toString() {
        return "AWS [name=" + this.getName() + ", components=" + Arrays.toString(this.getComponentsInternal()) + "]";
    }
}

