/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.ReadOnlyVec;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;
    private BigInteger correction = BigInteger.ZERO;

    public ObjectiveFunction(IVecInt vars, IVec<BigInteger> coeffs) {
        this.vars = new ReadOnlyVecInt(vars);
        this.coeffs = new ReadOnlyVec(coeffs);
    }

    public BigInteger calculateDegree(RandomAccessModel lazyModel) {
        BigInteger tempDegree = BigInteger.ZERO;
        int i = 0;
        while (i < this.vars.size()) {
            BigInteger coeff = (BigInteger)this.coeffs.get(i);
            if (this.varInModel(this.vars.get(i), lazyModel)) {
                tempDegree = tempDegree.add(coeff);
            } else if (coeff.signum() < 0 && !this.varInModel(-this.vars.get(i), lazyModel)) {
                tempDegree = tempDegree.add(coeff);
            }
            ++i;
        }
        return tempDegree;
    }

    public BigInteger calculateDegreeImplicant(ISolver solver) {
        BigInteger tempDegree = BigInteger.ZERO;
        int i = 0;
        while (i < this.vars.size()) {
            BigInteger coeff = (BigInteger)this.coeffs.get(i);
            if (solver.primeImplicant(this.vars.get(i))) {
                tempDegree = tempDegree.add(coeff);
            } else if (coeff.signum() < 0 && !solver.primeImplicant(-this.vars.get(i))) {
                tempDegree = tempDegree.add(coeff);
            }
            ++i;
        }
        return tempDegree;
    }

    private boolean varInModel(int var, RandomAccessModel lazyModel) {
        if (var > 0) {
            return lazyModel.model(var);
        }
        return !lazyModel.model(-var);
    }

    public IVec<BigInteger> getCoeffs() {
        return this.coeffs;
    }

    public IVecInt getVars() {
        return this.vars;
    }

    public void setCorrection(BigInteger correction) {
        this.correction = correction;
    }

    public BigInteger getCorrection() {
        return this.correction;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        IVecInt lits = this.getVars();
        IVec<BigInteger> coefs = this.getCoeffs();
        int i = 0;
        while (i < lits.size()) {
            BigInteger coef = (BigInteger)coefs.get(i);
            int lit = lits.get(i);
            if (lit < 0) {
                lit = -lit;
                coef = coef.negate();
            }
            stb.append(String.valueOf(coef.signum() < 0 ? "" : "+") + coef + " x" + lit + " ");
            ++i;
        }
        return stb.toString();
    }

    public BigInteger minValue() {
        BigInteger tempDegree = BigInteger.ZERO;
        int i = 0;
        while (i < this.vars.size()) {
            BigInteger coeff = (BigInteger)this.coeffs.get(i);
            if (coeff.signum() < 0) {
                tempDegree = tempDegree.add(coeff);
            }
            ++i;
        }
        return tempDegree;
    }

    public int hashCode() {
        return this.coeffs.hashCode() / 3 + this.vars.hashCode() / 3 + this.correction.hashCode() / 3;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectiveFunction) {
            ObjectiveFunction of = (ObjectiveFunction)obj;
            return of.correction.equals(this.correction) && of.coeffs.equals(this.coeffs) && of.vars.equals(this.vars);
        }
        return false;
    }
}

