/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.intro.config;

import java.util.Map;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IntroElement;

public abstract class IntroConfigurer {
    public static final String TB_ADDITIONS = "additions";
    protected Map<String, String> themeProperties;
    protected IIntroSite site;
    private IntroModelRoot model;

    public void init(IIntroSite site, Map<String, String> themeProperties) {
        this.themeProperties = themeProperties;
        this.site = site;
    }

    public final void bind(IntroModelRoot model) {
        this.model = model;
        if (model != null && model.getTheme() != null) {
            this.themeProperties = model.getTheme().getProperties();
        }
    }

    protected String getThemeProperty(String name) {
        if (this.themeProperties == null) {
            return null;
        }
        String value = this.themeProperties.get(name);
        if (value != null && this.model != null) {
            value = this.model.resolveVariables(value);
        }
        return value;
    }

    public abstract String getVariable(String var1);

    public abstract IntroElement[] getGroupChildren(String var1, String var2);

    public IntroElement[] getLaunchBarShortcuts() {
        return new IntroElement[0];
    }

    public abstract String resolvePath(String var1, String var2);

    public String getMixinStyle(String pageId, String extensionId) {
        return null;
    }

    protected boolean isStartPage(String pageId) {
        return pageId.equals(this.model.getStartPageId());
    }
}

