/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerUtil;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.URISchemeDialog;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URISchemeUtil {
    private static final OomphPlugin.Preference PREF_WEB_LINKS = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("web-links");
    private static final IOperatingSystemRegistration OPERATING_SYSTEM_REGISTRATION = (IOperatingSystemRegistration)ReflectUtil.invokeMethod((String)"getInstance", IOperatingSystemRegistration.class);
    private static final String INSTALLER_SCHEME = PropertiesUtil.getProperty((String)"oomph.setup.installer.uri.scheme.installer", (String)"eclipse+installer");
    private static final String MARKETPLACE_SCHEME = PropertiesUtil.getProperty((String)"oomph.setup.installer.uri.scheme.mpc", (String)"?");
    private static final String FAKE_ECLIPSE_HOME = PropertiesUtil.getProperty((String)"oomph.setup.installer.uri.scheme.eclipse.home", null);
    private static final Collection<IScheme> SCHEMES;

    static {
        ArrayList<IScheme> schemes = new ArrayList<IScheme>();
        String[] stringArray = new String[]{INSTALLER_SCHEME, MARKETPLACE_SCHEME};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String scheme = stringArray[n2];
            if (URI.validScheme((String)scheme)) {
                schemes.add(new IScheme(){

                    public String getName() {
                        return scheme;
                    }

                    public String getDescription() {
                        return scheme;
                    }
                });
            }
            ++n2;
        }
        SCHEMES = schemes;
    }

    private URISchemeUtil() {
    }

    public static URI getResourceURI(String argument) {
        try {
            File file = new File(argument);
            if (file.isFile() && file.canRead()) {
                return URI.createFileURI((String)IOUtil.getCanonicalFile((File)file).toString());
            }
        }
        catch (Throwable file) {
            // empty catch block
        }
        URI uri = URI.createURI((String)argument);
        String scheme = uri.scheme();
        if (scheme == null || OS.INSTANCE.isWin() && scheme.length() == 1) {
            uri = URI.createFileURI((String)IOUtil.getCanonicalFile((File)new File(argument)).toString());
        }
        if (INSTALLER_SCHEME.equals(uri.scheme()) && uri.opaquePart() != null) {
            uri = URI.createURI((String)uri.opaquePart()).appendQuery(uri.query()).appendFragment(uri.fragment());
        }
        return uri;
    }

    public static String getSelfLauncher() {
        Runnable restore = URISchemeUtil.setEclipseHome(FAKE_ECLIPSE_HOME);
        String eclipseLauncher = OPERATING_SYSTEM_REGISTRATION.getEclipseLauncher();
        if (restore != null) {
            restore.run();
        }
        return StringUtil.isEmpty((String)eclipseLauncher) || eclipseLauncher.startsWith("file:") ? "" : eclipseLauncher;
    }

    private static Runnable setEclipseHome(String eclipseHome) {
        if (!StringUtil.isEmpty((String)eclipseHome)) {
            final String originalHomeLocation = System.getProperty("eclipse.home.location");
            System.setProperty("eclipse.home.location", eclipseHome);
            return new Runnable(){

                public void run() {
                    System.setProperty("eclipse.home.location", originalHomeLocation);
                }
            };
        }
        return null;
    }

    public static void registerDefault() {
        boolean isSet;
        boolean bl = isSet = PREF_WEB_LINKS.get(null) != null;
        if (!isSet && URISchemeUtil.canRegister()) {
            Map<String, String> conflictingRegistrations = URISchemeUtil.getConflictingRegistrations();
            for (IScheme scheme : SCHEMES) {
                String schemeName = scheme.getName();
                if (conflictingRegistrations.containsKey(schemeName)) continue;
                URISchemeUtil.setRegistrations(Collections.singletonMap(schemeName, URISchemeUtil.getSelfLauncher()));
            }
        }
    }

    private static boolean canRegister() {
        try {
            OPERATING_SYSTEM_REGISTRATION.getSchemesInformation(SCHEMES);
        }
        catch (Exception ex) {
            return false;
        }
        return !StringUtil.isEmpty((String)URISchemeUtil.getSelfLauncher()) && !KeepInstallerUtil.canKeepInstaller();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRegistered() {
        String eclipseLauncher = URISchemeUtil.getSelfLauncher();
        if (StringUtil.isEmpty((String)eclipseLauncher)) {
            return false;
        }
        try {
            ISchemeInformation schemeInformation;
            String handlerInstanceLocation;
            List schemesInformation = OPERATING_SYSTEM_REGISTRATION.getSchemesInformation(SCHEMES);
            Iterator iterator = schemesInformation.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!eclipseLauncher.equals(handlerInstanceLocation = (schemeInformation = (ISchemeInformation)iterator.next()).getHandlerInstanceLocation()));
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void setRegistrations(Map<String, String> newRegistrations) {
        Map<String, String> existingRegistrations = URISchemeUtil.getRegistrations();
        block6: for (Map.Entry<String, String> entry : newRegistrations.entrySet()) {
            String schemeRegistration = entry.getKey();
            String existingLauncher = existingRegistrations.get(schemeRegistration);
            String newLauncher = entry.getValue();
            if (newLauncher.equals(existingLauncher)) continue;
            for (IScheme scheme : SCHEMES) {
                if (!scheme.getName().equals(schemeRegistration)) continue;
                try {
                    Runnable restore;
                    block14: {
                        if (OS.INSTANCE.isMac()) {
                            restore = URISchemeUtil.setEclipseHome(existingLauncher);
                            try {
                                try {
                                    OPERATING_SYSTEM_REGISTRATION.handleSchemes(Collections.emptyList(), Collections.singleton(scheme));
                                }
                                catch (Exception ex) {
                                    SetupInstallerPlugin.INSTANCE.log(ex);
                                    if (restore != null) {
                                        restore.run();
                                    }
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                if (restore != null) {
                                    restore.run();
                                }
                                throw throwable;
                            }
                            if (restore != null) {
                                restore.run();
                            }
                        } else {
                            OPERATING_SYSTEM_REGISTRATION.handleSchemes(Collections.emptyList(), Collections.singleton(scheme));
                        }
                    }
                    if (StringUtil.isEmpty((String)newLauncher)) continue block6;
                    restore = URISchemeUtil.setEclipseHome(FAKE_ECLIPSE_HOME);
                    OPERATING_SYSTEM_REGISTRATION.handleSchemes(Collections.singleton(scheme), Collections.emptyList());
                    if (restore == null) continue block6;
                    restore.run();
                }
                catch (Exception ex) {
                    SetupInstallerPlugin.INSTANCE.log(ex);
                }
                continue block6;
            }
        }
    }

    public static void setRegistered(boolean registered) {
        String eclipseLauncher = URISchemeUtil.getSelfLauncher();
        if (!StringUtil.isEmpty((String)eclipseLauncher)) {
            try {
                if (!registered) {
                    Set<String> selfRegistrations = URISchemeUtil.getSelfRegistrations();
                    for (IScheme scheme : SCHEMES) {
                        if (!selfRegistrations.contains(scheme.getName())) continue;
                        OPERATING_SYSTEM_REGISTRATION.handleSchemes(Collections.emptyList(), Collections.singleton(scheme));
                    }
                }
                if (registered) {
                    OPERATING_SYSTEM_REGISTRATION.handleSchemes(SCHEMES, Collections.emptyList());
                }
                PREF_WEB_LINKS.set(registered);
            }
            catch (Exception ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
    }

    public static RegistrationConfirmation manageRegistrations(Shell shell) {
        if (KeepInstallerUtil.isTransientInstaller()) {
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.URISchemeUtil_title, (String)Messages.URISchemeUtil_description)) {
                return RegistrationConfirmation.KEEP_INSTALLER;
            }
            return RegistrationConfirmation.CANCEL;
        }
        URISchemeDialog uriSchemeDialog = new URISchemeDialog(shell);
        if (uriSchemeDialog.open() == 1) {
            return RegistrationConfirmation.CANCEL;
        }
        return RegistrationConfirmation.DONE;
    }

    public static RegistrationConfirmation confirmRegistration(Shell shell) {
        if (KeepInstallerUtil.isTransientInstaller()) {
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.URISchemeUtil_title, (String)Messages.URISchemeUtil_description)) {
                return RegistrationConfirmation.KEEP_INSTALLER;
            }
            return RegistrationConfirmation.CANCEL;
        }
        Map<String, String> conflictingRegistrations = URISchemeUtil.getConflictingRegistrations();
        if (!conflictingRegistrations.isEmpty()) {
            URISchemeDialog uriSchemeDialog = new URISchemeDialog(shell);
            if (uriSchemeDialog.open() == 1) {
                return RegistrationConfirmation.CANCEL;
            }
            return RegistrationConfirmation.DONE;
        }
        return RegistrationConfirmation.OK;
    }

    public static Map<String, String> getConflictingRegistrations() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List schemesInformation = OPERATING_SYSTEM_REGISTRATION.getSchemesInformation(SCHEMES);
            String eclipseLauncher = URISchemeUtil.getSelfLauncher();
            for (ISchemeInformation schemeInformation : schemesInformation) {
                String handlerInstanceLocation = schemeInformation.getHandlerInstanceLocation();
                if (StringUtil.isEmpty((String)handlerInstanceLocation) || handlerInstanceLocation.equals(eclipseLauncher)) continue;
                result.put(schemeInformation.getName(), handlerInstanceLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Set<String> getSelfRegistrations() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String eclipseLauncher = URISchemeUtil.getSelfLauncher();
        if (!StringUtil.isEmpty((String)eclipseLauncher)) {
            try {
                List schemesInformation = OPERATING_SYSTEM_REGISTRATION.getSchemesInformation(SCHEMES);
                for (ISchemeInformation schemeInformation : schemesInformation) {
                    String handlerInstanceLocation = schemeInformation.getHandlerInstanceLocation();
                    if (!eclipseLauncher.equals(handlerInstanceLocation)) continue;
                    result.add(schemeInformation.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Map<String, String> getRegistrations() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List schemesInformation = OPERATING_SYSTEM_REGISTRATION.getSchemesInformation(SCHEMES);
            for (ISchemeInformation schemeInformation : schemesInformation) {
                String handlerInstanceLocation = schemeInformation.getHandlerInstanceLocation();
                result.put(schemeInformation.getName(), handlerInstanceLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RegistrationConfirmation {
        KEEP_INSTALLER,
        OK,
        CANCEL,
        DONE;

    }
}

