/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.targlets.TargletContainer;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.ui.Messages;
import org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin;
import org.eclipse.oomph.targlets.presentation.TargletEditor;
import org.eclipse.oomph.targlets.provider.TargletItemProviderAdapterFactory;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.ui.editor.targetdefinition.LocationsSection;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationsGroup;
import org.eclipse.pde.ui.target.ITargetLocationHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;

public class TargletContainerUI
implements ITargetLocationHandler,
IAdapterFactory {
    private static final Object[] NO_CHILDREN = new Object[0];
    static final Class<?>[] ADAPTERS = new Class[]{ITreeContentProvider.class, ILabelProvider.class, ITargetLocationHandler.class};
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AdapterFactoryContentProvider contentProvider;
    private final AdapterFactoryLabelProvider labelProvider;
    private ContainerContentProvider containerContentProvider;
    private ContainerLabelProvider containerLabelProvider;

    public TargletContainerUI() {
        this.adapterFactory.addAdapterFactory((AdapterFactory)new TargletItemProviderAdapterFactory(true));
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    }

    public Class<?>[] getAdapterList() {
        return ADAPTERS;
    }

    public Object getAdapter(Object object, Class adapterType) {
        if (object instanceof ITargletContainer) {
            if (adapterType == ITreeContentProvider.class) {
                if (this.containerContentProvider == null) {
                    this.containerContentProvider = new ContainerContentProvider();
                }
                return this.containerContentProvider;
            }
            if (adapterType == ILabelProvider.class) {
                if (this.containerLabelProvider == null) {
                    this.containerLabelProvider = new ContainerLabelProvider();
                }
                this.fixComparator();
                return this.containerLabelProvider;
            }
            if (adapterType == ITargetLocationHandler.class) {
                return this;
            }
        }
        return null;
    }

    public boolean canEdit(ITargetDefinition target, TreePath treePath) {
        return treePath.getFirstSegment() instanceof ITargletContainer;
    }

    public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
        IEditorPart activeEditor;
        String editorID;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final Display display = window.getShell().getDisplay();
        UIUtil.asyncExec((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    WizardDialog wizardDialog;
                    IWizard wizard;
                    Shell activeShell = display.getActiveShell();
                    Object data = activeShell.getData();
                    if (data instanceof WizardDialog && (wizard = (IWizard)ReflectUtil.getValue((String)"wizard", (Object)(wizardDialog = (WizardDialog)data))) != null) {
                        wizard.performFinish();
                        wizardDialog.close();
                    }
                }
                catch (Throwable ex) {
                    TargletsUIPlugin.INSTANCE.log(ex);
                }
            }
        });
        UIUtil.asyncExec((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Shell activeShell = display.getActiveShell();
                    Object data = activeShell.getData();
                    if (data instanceof PreferenceDialog) {
                        PreferenceDialog preferenceDialog = (PreferenceDialog)data;
                        ReflectUtil.invokeMethod((String)"okPressed", (Object)preferenceDialog);
                    }
                }
                catch (Throwable ex) {
                    TargletsUIPlugin.INSTANCE.log(ex);
                }
            }
        });
        IWorkbenchPage page = window.getActivePage();
        String id = ((ITargletContainer)treePath.getFirstSegment()).getID();
        if (TargletContainerDescriptorManager.getContainer((String)id) == null && "org.eclipse.pde.ui.targetEditor".equals(editorID = (activeEditor = page.getActiveEditor()).getSite().getId())) {
            UIUtil.asyncExec((Display)display, () -> {
                try {
                    activeEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable ex) {
                    TargletsUIPlugin.INSTANCE.log(ex);
                }
            });
        }
        TargletEditor.open((IWorkbenchPage)page, (String)id);
        return null;
    }

    public boolean canUpdate(ITargetDefinition target, TreePath treePath) {
        return treePath.getFirstSegment() instanceof ITargletContainer;
    }

    public IStatus update(ITargetDefinition target, TreePath[] treePaths, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)treePaths.length).detectCancelation();
        MultiStatus rootStatus = new MultiStatus(TargletsCorePlugin.INSTANCE.getSymbolicName(), 0, org.eclipse.oomph.targlets.internal.core.Messages.TargletContainer_ResolutionProblems, null);
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            IStatus status = ((ITargletContainer)treePath.getFirstSegment()).resolve(target, (IProgressMonitor)progress.newChild());
            if (!status.isOK()) {
                rootStatus.add(status);
            }
            ++n2;
        }
        return rootStatus;
    }

    public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)targetLocations.length).detectCancelation();
        MultiStatus rootStatus = new MultiStatus(TargletsCorePlugin.INSTANCE.getSymbolicName(), 0, org.eclipse.oomph.targlets.internal.core.Messages.TargletContainer_ResolutionProblems, null);
        ITargetLocation[] iTargetLocationArray = targetLocations;
        int n = targetLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation location = iTargetLocationArray[n2];
            IStatus status = ((ITargletContainer)location).resolve(target, (IProgressMonitor)progress.newChild());
            if (!status.isOK()) {
                rootStatus.add(status);
            }
            ++n2;
        }
        return rootStatus;
    }

    private void fixComparator() {
        try {
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof TargetEditor) {
                IFormPage activePageInstance = ((TargetEditor)activeEditor).getActivePageInstance();
                IManagedForm managedForm = activePageInstance.getManagedForm();
                IFormPart[] iFormPartArray = managedForm.getParts();
                int n = iFormPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control;
                    TargetLocationsGroup group;
                    TreeViewer treeViewer;
                    ViewerComparator comparator;
                    IFormPart formPart = iFormPartArray[n2];
                    if (formPart instanceof LocationsSection && (comparator = (treeViewer = (TreeViewer)ReflectUtil.getValue((String)"fTreeViewer", (Object)(group = (TargetLocationsGroup)ReflectUtil.getValue((String)"fContainerGroup", (Object)formPart)))).getComparator()) != null && (control = treeViewer.getControl()).getData("oomph.fixed.comparator") == null) {
                        control.setData("oomph.fixed.comparator", (Object)Boolean.TRUE);
                        UIUtil.asyncExec((Control)control, () -> treeViewer.setComparator((ViewerComparator)new FixedViewerComparator(comparator)));
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ContainerContentProvider
    implements ITreeContentProvider {
        private StatusWrapper missingIUInfo;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ITargletContainer) {
                ITargletContainerDescriptor.UpdateProblem updateProblem;
                Object[] composedTargets;
                ITargletContainer location = (ITargletContainer)element;
                ArrayList<Object> children = new ArrayList<Object>();
                TargletContainer targletContainer = TargletFactory.eINSTANCE.createTargletContainer();
                targletContainer.getComposedTargets().addAll((Collection)location.getComposedTargets());
                Object[] objectArray = composedTargets = TargletContainerUI.this.contentProvider.getChildren((Object)targletContainer);
                int n = composedTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    children.add(new Wrapper(object));
                    ++n2;
                }
                for (Object targlet : location.getTarglets()) {
                    children.add(new Wrapper(targlet));
                }
                ITargletContainerDescriptor descriptor = location.getDescriptor();
                if (descriptor != null && (updateProblem = descriptor.getUpdateProblem()) != null) {
                    IStatus status = updateProblem.toStatus();
                    children.add(new StatusWrapper(status));
                    if (descriptor.getWorkingDigest() != null) {
                        children.add(new StatusWrapper(Messages.TargletContainerUI_status_contentAvailableFromLastWorkingProfile));
                    }
                    try {
                        if (updateProblem instanceof ITargletContainerDescriptor.UpdateProblem.MissingIU) {
                            if (this.missingIUInfo == null) {
                                ITargletContainerDescriptor.UpdateProblem.MissingIU missingIU = (ITargletContainerDescriptor.UpdateProblem.MissingIU)updateProblem;
                                VersionRange range = new VersionRange(missingIU.getRange());
                                HashSet<P2Index.Repository> repositories = new HashSet<P2Index.Repository>();
                                Map simpleResult = P2Index.INSTANCE.lookupCapabilities(missingIU.getNamespace(), missingIU.getName());
                                this.collectRepositories(simpleResult, range, repositories);
                                Map composedResult = P2Index.INSTANCE.generateCapabilitiesFromComposedRepositories(simpleResult);
                                this.collectRepositories(composedResult, range, repositories);
                                String missingIUDescription = String.valueOf(missingIU.getNamespace()) + "/" + missingIU.getName() + " " + missingIU.getRange();
                                this.missingIUInfo = new StatusWrapper(repositories.size() == 1 ? NLS.bind((String)Messages.TargletContainerUI_status_foundRepository, (Object)missingIUDescription) : NLS.bind((String)Messages.TargletContainerUI_status_foundRepositories, (Object)repositories.size(), (Object)missingIUDescription));
                                for (P2Index.Repository repository : repositories) {
                                    this.missingIUInfo.addChild(new StatusWrapper(repository.getLocation() + "  (" + (repository.isComposed() ? Messages.TargletContainerUI_status_composed : Messages.TargletContainerUI_status_simple) + ": " + repository.getCapabilityCount() + ")"));
                                }
                            }
                            children.add(this.missingIUInfo);
                        }
                    }
                    catch (Exception ex) {
                        TargletsUIPlugin.INSTANCE.log(ex);
                    }
                }
                return children.toArray(new Object[children.size()]);
            }
            return NO_CHILDREN;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        private void collectRepositories(Map<P2Index.Repository, Set<Version>> result, VersionRange range, Set<P2Index.Repository> repositories) {
            block0: for (Map.Entry<P2Index.Repository, Set<Version>> entry : result.entrySet()) {
                for (Version version : entry.getValue()) {
                    if (!range.isIncluded(version)) continue;
                    repositories.add(entry.getKey());
                    continue block0;
                }
            }
        }
    }

    private static class ContainerLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ITargletContainer) {
                ITargletContainerDescriptor.UpdateProblem updateProblem;
                ITargletContainer location = (ITargletContainer)element;
                String key = "targlet_container";
                ITargletContainerDescriptor descriptor = location.getDescriptor();
                if (descriptor != null && (updateProblem = descriptor.getUpdateProblem()) != null) {
                    key = String.valueOf(key) + "_problem";
                }
                return TargletsUIPlugin.INSTANCE.getSWTImage(key);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ITargletContainer) {
                return ((ITargletContainer)element).toString();
            }
            return super.getText(element);
        }
    }

    private static class FixedViewerComparator
    extends ViewerComparator {
        private final ViewerComparator delegate;

        public FixedViewerComparator(ViewerComparator delegate) {
            this.delegate = delegate;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if ((e1 instanceof EObject || e1 instanceof Wrapper || e1 instanceof StatusWrapper || e1 instanceof ITargletContainerDescriptor.UpdateProblem) && (e2 instanceof EObject || e2 instanceof Wrapper || e2 instanceof StatusWrapper || e1 instanceof ITargletContainerDescriptor.UpdateProblem)) {
                return 0;
            }
            return this.delegate.compare(viewer, e1, e2);
        }
    }

    private static final class StatusWrapper
    implements ITreeContentProvider,
    ILabelProvider {
        private final int severity;
        private final String message;
        private final List<StatusWrapper> children = new ArrayList<StatusWrapper>();

        public StatusWrapper(int severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public StatusWrapper(IStatus delegate) {
            this(delegate.getSeverity(), delegate.getMessage());
            IStatus[] iStatusArray = delegate.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.children.add(new StatusWrapper(child));
                ++n2;
            }
        }

        public StatusWrapper(String message) {
            this(1, message);
        }

        public void addChild(StatusWrapper child) {
            this.children.add(child);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return this.children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !this.children.isEmpty();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return UIUtil.getStatusImage((int)this.severity);
        }

        public String getText(Object element) {
            return this.message;
        }

        public String toString() {
            return this.message;
        }
    }

    private final class Wrapper
    implements ITreeContentProvider,
    ILabelProvider {
        private final Object wrappedObject;

        public Wrapper(Object wrappedObject) {
            this.wrappedObject = wrappedObject;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            TargletContainerUI.this.contentProvider.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getElements(Object object) {
            return this.getChildren(this.wrappedObject);
        }

        public Object[] getChildren(Object object) {
            Object[] children = TargletContainerUI.this.contentProvider.getChildren(this.wrappedObject);
            int i = 0;
            while (i < children.length) {
                children[i] = new Wrapper(children[i]);
                ++i;
            }
            return children;
        }

        public boolean hasChildren(Object object) {
            return TargletContainerUI.this.contentProvider.hasChildren(this.wrappedObject);
        }

        public Object getParent(Object object) {
            return TargletContainerUI.this.contentProvider.getParent(this.wrappedObject);
        }

        public void addListener(ILabelProviderListener listener) {
            TargletContainerUI.this.labelProvider.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            TargletContainerUI.this.labelProvider.removeListener(listener);
        }

        public void dispose() {
            TargletContainerUI.this.labelProvider.dispose();
        }

        public boolean isLabelProperty(Object object, String id) {
            return TargletContainerUI.this.labelProvider.isLabelProperty(this.wrappedObject, id);
        }

        public Image getImage(Object object) {
            return TargletContainerUI.this.labelProvider.getImage(this.wrappedObject);
        }

        public String getText(Object object) {
            return TargletContainerUI.this.labelProvider.getText(this.wrappedObject);
        }
    }
}

