/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;

public abstract class NAry
extends Expression {
    public final Expression[] operands;

    protected NAry(Expression[] operands) {
        this.operands = operands;
    }

    @Override
    public boolean accept(IExpressionVisitor visitor) {
        if (super.accept(visitor)) {
            Expression[] expressionArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                Expression operand = expressionArray[n2];
                if (!operand.accept(visitor)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Expression e) {
        int cmp = super.compareTo(e);
        if (cmp == 0) {
            cmp = NAry.compare(this.operands, ((NAry)e).operands);
        }
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && NAry.equals(this.operands, ((NAry)o).operands);
    }

    @Override
    public abstract String getOperator();

    public int hashCode() {
        return NAry.hashCode(this.operands);
    }

    @Override
    public void toString(StringBuffer bld, Variable rootVariable) {
        NAry.appendOperand(bld, rootVariable, this.operands[0], this.getPriority());
        int idx = 1;
        while (idx < this.operands.length) {
            bld.append(' ');
            bld.append(this.getOperator());
            bld.append(' ');
            NAry.appendOperand(bld, rootVariable, this.operands[idx], this.getPriority());
            ++idx;
        }
    }

    @Override
    int countAccessToEverything() {
        int cnt = 0;
        Expression[] expressionArray = this.operands;
        int n = this.operands.length;
        int n2 = 0;
        while (n2 < n) {
            Expression operand = expressionArray[n2];
            cnt += operand.countAccessToEverything();
            ++n2;
        }
        return cnt;
    }
}

