/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.transport.ecf;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Credentials;
import org.eclipse.equinox.internal.p2.repository.DownloadPauseResumeEvent;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.FileInfo;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.transport.ecf.Activator;
import org.eclipse.equinox.internal.p2.transport.ecf.FileInfoReader;
import org.eclipse.equinox.internal.p2.transport.ecf.FileReader;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryStatus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.osgi.util.NLS;

public class RepositoryTransport
extends Transport {
    public static final String TIMEOUT_RETRY = "org.eclipse.equinox.p2.transport.ecf.retry";
    private static Map<URI, Integer> socketExceptionRetry = null;
    private IProvisioningAgent agent = null;

    public RepositoryTransport() {
        this(null);
    }

    public RepositoryTransport(IProvisioningAgent agent) {
        this.agent = agent;
    }

    public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
        boolean promptUser = false;
        boolean useJREHttp = false;
        UIServices.AuthenticationInfo loginDetails = null;
        int i = RepositoryPreferences.getLoginRetryCount();
        while (i > 0) {
            block19: {
                FileReader reader = null;
                try {
                    loginDetails = Credentials.forLocation((URI)toDownload, (boolean)promptUser, loginDetails);
                    IConnectContext context = loginDetails == null ? null : ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
                    reader = new FileReader(this.agent, context);
                    ProvisioningListener listener = null;
                    IProvisioningEventBus eventBus = null;
                    try {
                        if (this.agent != null && (eventBus = (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.class)) != null) {
                            FileReader fileReader = reader;
                            listener = event -> {
                                if (event instanceof DownloadPauseResumeEvent) {
                                    if (((DownloadPauseResumeEvent)event).getType() == 1) {
                                        fileReader.pause();
                                    } else if (((DownloadPauseResumeEvent)event).getType() == 2) {
                                        fileReader.resume();
                                    }
                                }
                            };
                            eventBus.addListener(listener);
                        }
                        reader.readInto(toDownload, target, -1L, monitor);
                    }
                    finally {
                        if (eventBus != null) {
                            eventBus.removeListener(listener);
                        }
                    }
                    IStatus result = reader.getResult();
                    if (result == null) {
                        String msg = NLS.bind((String)Messages.RepositoryTransport_failedReadRepo, (Object)toDownload);
                        DownloadStatus ds = new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1002, msg, null);
                        return RepositoryTransport.statusOn(target, ds, reader);
                    }
                    if (result.getSeverity() == 8) {
                        throw new OperationCanceledException();
                    }
                    if (!result.isOK()) {
                        throw new CoreException(result);
                    }
                    DownloadStatus status = new DownloadStatus(0, "org.eclipse.equinox.p2.transport.ecf", Status.OK_STATUS.getMessage());
                    return RepositoryTransport.statusOn(target, status, reader);
                }
                catch (UserCancelledException userCancelledException) {
                    RepositoryTransport.statusOn(target, new DownloadStatus(8, "org.eclipse.equinox.p2.transport.ecf", 1, "", null), reader);
                    throw new OperationCanceledException();
                }
                catch (OperationCanceledException e) {
                    RepositoryTransport.statusOn(target, new DownloadStatus(8, "org.eclipse.equinox.p2.transport.ecf", 1, "", null), reader);
                    throw e;
                }
                catch (CoreException e) {
                    if (e.getStatus().getException() == null) {
                        return RepositoryTransport.statusOn(target, RepositoryTransport.forException(e, toDownload), reader);
                    }
                    return RepositoryTransport.statusOn(target, RepositoryTransport.forStatus(e.getStatus(), toDownload), reader);
                }
                catch (FileNotFoundException e) {
                    return RepositoryTransport.statusOn(target, RepositoryTransport.forException(e, toDownload), reader);
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    promptUser = true;
                }
                catch (Credentials.LoginCanceledException loginCanceledException) {
                    DownloadStatus status = new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1007, NLS.bind((String)Messages.UnableToRead_0_UserCanceled, (Object)toDownload), null);
                    return RepositoryTransport.statusOn(target, status, null);
                }
                catch (JREHttpClientRequiredException jREHttpClientRequiredException) {
                    if (useJREHttp) break block19;
                    useJREHttp = true;
                    ++i;
                    Activator.getDefault().useJREHttpClient();
                }
            }
            --i;
        }
        DownloadStatus status = new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1007, NLS.bind((String)Messages.UnableToRead_0_TooManyAttempts, (Object)toDownload), null);
        return RepositoryTransport.statusOn(target, status, null);
    }

    public InputStream stream(URI toDownload, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        boolean promptUser = false;
        boolean useJREHttp = false;
        UIServices.AuthenticationInfo loginDetails = null;
        int i = RepositoryPreferences.getLoginRetryCount();
        while (i > 0) {
            block8: {
                FileReader reader = null;
                try {
                    loginDetails = Credentials.forLocation((URI)toDownload, (boolean)promptUser, loginDetails);
                    IConnectContext context = loginDetails == null ? null : ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
                    reader = new FileReader(this.agent, context);
                    return reader.read(toDownload, monitor);
                }
                catch (UserCancelledException userCancelledException) {
                    throw new OperationCanceledException();
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    promptUser = true;
                }
                catch (CoreException e) {
                    if (e.getStatus().getException() == null) {
                        throw new CoreException((IStatus)RepositoryTransport.forException(e, toDownload));
                    }
                    throw new CoreException((IStatus)RepositoryTransport.forStatus(e.getStatus(), toDownload));
                }
                catch (Credentials.LoginCanceledException loginCanceledException) {
                    throw new AuthenticationFailedException();
                }
                catch (JREHttpClientRequiredException jREHttpClientRequiredException) {
                    if (useJREHttp) break block8;
                    useJREHttp = true;
                    ++i;
                    Activator.getDefault().useJREHttpClient();
                }
            }
            --i;
        }
        throw new AuthenticationFailedException();
    }

    private static DownloadStatus statusOn(OutputStream target, DownloadStatus status, FileReader reader) {
        FileInfo fi;
        if (reader != null && (fi = reader.getLastFileInfo()) != null) {
            status.setFileSize(fi.getSize());
            status.setLastModified(fi.getLastModified());
            status.setTransferRate(fi.getAverageSpeed());
        }
        if (target instanceof IStateful) {
            ((IStateful)target).setStatus((IStatus)status);
        }
        return status;
    }

    public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        boolean promptUser = false;
        boolean useJREHttp = false;
        UIServices.AuthenticationInfo loginDetails = null;
        int i = RepositoryPreferences.getLoginRetryCount();
        while (i > 0) {
            block8: {
                try {
                    loginDetails = Credentials.forLocation((URI)toDownload, (boolean)promptUser, loginDetails);
                    IConnectContext context = loginDetails == null ? null : ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
                    FileInfoReader reader = new FileInfoReader(context);
                    return reader.getLastModified(toDownload, monitor);
                }
                catch (UserCancelledException userCancelledException) {
                    throw new OperationCanceledException();
                }
                catch (CoreException e) {
                    if (e.getStatus().getException() == null) {
                        throw new CoreException((IStatus)RepositoryTransport.forException(e, toDownload));
                    }
                    throw new CoreException((IStatus)RepositoryTransport.forStatus(e.getStatus(), toDownload));
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    promptUser = true;
                }
                catch (Credentials.LoginCanceledException loginCanceledException) {
                    throw new AuthenticationFailedException();
                }
                catch (JREHttpClientRequiredException jREHttpClientRequiredException) {
                    if (useJREHttp) break block8;
                    useJREHttp = true;
                    ++i;
                    Activator.getDefault().useJREHttpClient();
                }
            }
            --i;
        }
        throw new AuthenticationFailedException();
    }

    private static boolean isForgiveableException(Throwable t) {
        if (t instanceof SocketTimeoutException) {
            return true;
        }
        if (t instanceof SocketException) {
            return true;
        }
        return t instanceof IncomingFileTransferException && ((IncomingFileTransferException)t).getErrorCode() == 503;
    }

    public static DownloadStatus forStatus(IStatus original, URI toDownload) {
        Throwable t = original.getException();
        if (RepositoryTransport.isForgiveableException(t) && original.getCode() == 13) {
            return new DownloadStatus(original.getSeverity(), "org.eclipse.equinox.p2.transport.ecf", original.getCode(), original.getMessage(), t);
        }
        return RepositoryTransport.forException(t, toDownload);
    }

    public static DownloadStatus forException(Throwable t, URI toDownload) {
        int retry;
        if (RepositoryTransport.isForgiveableException(t) && (retry = Integer.getInteger(TIMEOUT_RETRY, 0).intValue()) > 0) {
            Integer retryCount = null;
            if (socketExceptionRetry == null) {
                socketExceptionRetry = new HashMap<URI, Integer>();
                retryCount = 1;
            } else {
                Integer alreadyRetryCount = socketExceptionRetry.get(toDownload);
                if (alreadyRetryCount == null) {
                    retryCount = 1;
                } else if (alreadyRetryCount < retry) {
                    retryCount = alreadyRetryCount + 1;
                }
            }
            if (retryCount != null && retryCount <= retry) {
                socketExceptionRetry.put(toDownload, retryCount);
                return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 13, NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{toDownload.toString(), t.getMessage(), retryCount.toString()}), t);
            }
        }
        if (t instanceof FileNotFoundException || t instanceof IncomingFileTransferException && ((IncomingFileTransferException)t).getErrorCode() == 404) {
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1200, NLS.bind((String)Messages.artifact_not_found, (Object)toDownload), t);
        }
        if (t instanceof ConnectException) {
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1002, NLS.bind((String)Messages.TransportErrorTranslator_UnableToConnectToRepository_0, (Object)toDownload), t);
        }
        if (t instanceof UnknownHostException) {
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1006, NLS.bind((String)Messages.TransportErrorTranslator_UnknownHost, (Object)toDownload), t);
        }
        if (t instanceof IDCreateException) {
            IStatus status = ((IDCreateException)t).getStatus();
            if (status != null && status.getException() != null) {
                t = status.getException();
            }
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1006, NLS.bind((String)Messages.TransportErrorTranslator_MalformedRemoteFileReference, (Object)toDownload), t);
        }
        int code = 0;
        int provisionCode = 1002;
        if (t instanceof IncomingFileTransferException) {
            code = ((IncomingFileTransferException)t).getErrorCode();
        } else if (t instanceof BrowseFileTransferException) {
            code = ((BrowseFileTransferException)t).getErrorCode();
        }
        if (code == 401) {
            provisionCode = 1007;
        } else if (code == 404) {
            provisionCode = 1200;
        }
        return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", provisionCode, code == 0 ? NLS.bind((String)Messages.io_failedRead, (Object)toDownload) : RepositoryStatus.codeToMessage(code, toDownload.toString()), t);
    }
}

