/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.RegistryPersistence;

public abstract class PreferencePersistence
extends RegistryPersistence {
    protected boolean preferenceListenerAttached = false;
    private final IPropertyChangeListener preferenceChangeListener = event -> {
        if (this.isChangeImportant(event)) {
            this.read();
        }
    };

    protected static final void addElementToIndexedArray(IMemento elementToAdd, IMemento[][] indexedArray, int index, int currentCount) {
        IMemento[] elements;
        if (currentCount == 0) {
            elements = new IMemento[1];
            indexedArray[index] = elements;
        } else if (currentCount >= indexedArray[index].length) {
            IMemento[] copy = new IMemento[indexedArray[index].length * 2];
            System.arraycopy(indexedArray[index], 0, copy, 0, currentCount);
            elements = copy;
            indexedArray[index] = elements;
        } else {
            elements = indexedArray[index];
        }
        elements[currentCount] = elementToAdd;
    }

    protected static final void addWarning(List<IStatus> warningsToLog, String message) {
        PreferencePersistence.addWarning(warningsToLog, message, null, null, null);
    }

    protected static final void addWarning(List<IStatus> warningsToLog, String message, String id) {
        PreferencePersistence.addWarning(warningsToLog, message, id, null, null);
    }

    protected static final void addWarning(List<IStatus> warningsToLog, String message, String id, String extraAttributeName, String extraAttributeValue) {
        String statusMessage = message;
        if (id != null) {
            statusMessage = String.valueOf(statusMessage) + ": id='" + id + '\'';
        }
        if (extraAttributeName != null) {
            statusMessage = id != null ? String.valueOf(statusMessage) + ',' : String.valueOf(statusMessage) + ':';
            statusMessage = String.valueOf(statusMessage) + ' ' + extraAttributeName + "='" + extraAttributeValue + '\'';
        }
        Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, statusMessage, null);
        warningsToLog.add((IStatus)status);
    }

    protected static final boolean readBoolean(IMemento memento, String attribute, boolean defaultValue) {
        String value = memento.getString(attribute);
        if (value == null) {
            return defaultValue;
        }
        if (defaultValue) {
            return !value.equalsIgnoreCase("false");
        }
        return !value.equalsIgnoreCase("true");
    }

    protected static final String readOptional(IMemento memento, String attribute) {
        String value = memento.getString(attribute);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }

    protected static final ParameterizedCommand readParameterizedCommand(IMemento memento, ICommandService commandService, List<IStatus> warningsToLog, String message, String id) {
        String commandId = PreferencePersistence.readRequired(memento, "commandId", warningsToLog, message, id);
        if (commandId == null) {
            return null;
        }
        Command command = commandService.getCommand(commandId);
        return PreferencePersistence.readParameters(memento, warningsToLog, command);
    }

    protected static final ParameterizedCommand readParameters(IMemento memento, List<IStatus> warningsToLog, Command command) {
        IMemento[] parameterMementos = memento.getChildren("parameter");
        if (parameterMementos == null || parameterMementos.length == 0) {
            return new ParameterizedCommand(command, null);
        }
        ArrayList<Parameterization> parameters = new ArrayList<Parameterization>();
        IMemento[] iMementoArray = parameterMementos;
        int n = parameterMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento parameterMemento = iMementoArray[n2];
            String id = parameterMemento.getString("id");
            if (id == null || id.isEmpty()) {
                PreferencePersistence.addWarning(warningsToLog, "Parameters need a name");
            } else {
                IParameter parameter;
                block13: {
                    parameter = null;
                    try {
                        IParameter[] commandParameters = command.getParameters();
                        if (commandParameters == null) break block13;
                        IParameter[] iParameterArray = commandParameters;
                        int n3 = commandParameters.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IParameter currentParameter = iParameterArray[n4];
                            if (Objects.equals(currentParameter.getId(), id)) {
                                parameter = currentParameter;
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                if (parameter == null) {
                    PreferencePersistence.addWarning(warningsToLog, "Could not find a matching parameter", id);
                } else {
                    String value = parameterMemento.getString("value");
                    if (value == null || value.isEmpty()) {
                        PreferencePersistence.addWarning(warningsToLog, "Parameters need a value", id);
                    } else {
                        parameters.add(new Parameterization(parameter, value));
                    }
                }
            }
            ++n2;
        }
        if (parameters.isEmpty()) {
            return new ParameterizedCommand(command, null);
        }
        return new ParameterizedCommand(command, parameters.toArray(new Parameterization[parameters.size()]));
    }

    protected static final String readRequired(IMemento memento, String attribute, List<IStatus> warningsToLog, String message) {
        return PreferencePersistence.readRequired(memento, attribute, warningsToLog, message, null);
    }

    protected static final String readRequired(IMemento memento, String attribute, List<IStatus> warningsToLog, String message, String id) {
        String value = memento.getString(attribute);
        if (value == null || value.isEmpty()) {
            PreferencePersistence.addWarning(warningsToLog, message, id);
            return null;
        }
        return value;
    }

    @Override
    public final void dispose() {
        super.dispose();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.preferenceChangeListener);
    }

    protected abstract boolean isChangeImportant(PropertyChangeEvent var1);

    @Override
    protected void read() {
        super.read();
        if (!this.preferenceListenerAttached) {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.addPropertyChangeListener(this.preferenceChangeListener);
        }
    }

    protected PreferencePersistence() {
    }
}

