/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import org.eclipse.swt.SWT;

class JSON {
    JSON() {
    }

    public static Object parse(char[] input) {
        return new Reader(input, 0, input.length).readTop();
    }

    public static Object parse(String input) {
        return JSON.parse(input.toCharArray());
    }

    public static String stringify(Object object) {
        return new Writer(object).toString();
    }

    static class Reader {
        char[] input;
        int pos;
        int end;
        StringBuilder sb;

        public Reader(char[] input, int start, int end) {
            this.input = input;
            this.pos = start;
            this.end = end;
        }

        char nextChar() {
            return this.pos < this.end ? this.input[this.pos++] : (char)'\u0000';
        }

        void error() {
            SWT.error(5, null, " [decoding error at " + (this.pos - 1) + "]");
        }

        void readLiteral(String literal) {
            int i = 0;
            int len = literal.length();
            while (i < len) {
                if (this.nextChar() != literal.charAt(i)) {
                    this.error();
                }
                ++i;
            }
        }

        int nextHexDigit() {
            char c = this.nextChar();
            if ('0' <= c && c <= '9') {
                return c - 48;
            }
            if ('a' <= c && c <= 'f') {
                return c - 97 + 10;
            }
            if ('A' <= c && c <= 'F') {
                return c - 65 + 10;
            }
            this.error();
            return 0;
        }

        char readEscape() {
            int c = this.nextChar();
            switch (c) {
                case 34: 
                case 47: 
                case 92: {
                    break;
                }
                case 98: {
                    c = 8;
                    break;
                }
                case 102: {
                    c = 12;
                    break;
                }
                case 110: {
                    c = 10;
                    break;
                }
                case 114: {
                    c = 13;
                    break;
                }
                case 116: {
                    c = 9;
                    break;
                }
                case 117: {
                    c = (char)(this.nextHexDigit() << 12 | this.nextHexDigit() << 8 | this.nextHexDigit() << 4 | this.nextHexDigit());
                    break;
                }
                default: {
                    this.error();
                }
            }
            return (char)c;
        }

        String readString() {
            char c;
            int start = this.pos;
            do {
                if ((c = this.nextChar()) < ' ') {
                    this.error();
                }
                if (c != '\\') continue;
                if (this.sb == null) {
                    this.sb = new StringBuilder();
                }
                this.sb.append(this.input, start, this.pos - start - 1);
                this.sb.append(this.readEscape());
                start = this.pos;
            } while (c != '\"');
            if (this.sb != null) {
                this.sb.append(this.input, start, this.pos - 1 - start);
                String result = this.sb.toString();
                this.sb.setLength(0);
                return result;
            }
            return String.valueOf(this.input, start, this.pos - start - 1);
        }

        double readNumber() {
            int start = this.pos - 1;
            block6: while (true) {
                char c = this.nextChar();
                switch (c) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': 
                    case 'e': {
                        continue block6;
                    }
                    default: {
                        --this.pos;
                    }
                    case '\u0000': 
                }
                try {
                    return Double.parseDouble(String.valueOf(this.input, start, this.pos - start));
                }
                catch (NumberFormatException numberFormatException) {
                    this.error();
                    continue;
                }
                break;
            }
        }

        Object readAny() {
            block12: while (true) {
                char c = this.nextChar();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block12;
                    }
                    case '\u0000': {
                        return Control.END;
                    }
                    case '[': {
                        return this.readArray();
                    }
                    case ']': {
                        return Control.ARRAY_END;
                    }
                    case ',': {
                        return Control.COMMA;
                    }
                    case '\"': {
                        return this.readString();
                    }
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return this.readNumber();
                    }
                    case 'n': {
                        this.readLiteral("ull");
                        return null;
                    }
                    case 't': {
                        this.readLiteral("rue");
                        return true;
                    }
                    case 'f': {
                        this.readLiteral("alse");
                        return false;
                    }
                }
                this.error();
            }
        }

        Object readArray() {
            Object sep;
            Object item = this.readAny();
            if (item == Control.ARRAY_END) {
                return new Object[0];
            }
            if (item instanceof Control) {
                this.error();
            }
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(item);
            while ((sep = this.readAny()) != Control.ARRAY_END) {
                if (sep != Control.COMMA) {
                    this.error();
                }
                if ((item = this.readAny()) instanceof Control) {
                    this.error();
                }
                items.add(item);
            }
            return items.toArray();
        }

        Object readTop() {
            Object item = this.readAny();
            if (item instanceof Control) {
                this.error();
            }
            if (this.readAny() != Control.END) {
                this.error();
            }
            return item;
        }

        static enum Control {
            END,
            ARRAY_END,
            COMMA;

        }
    }

    static class Writer {
        static final String[] ESCAPED = new String[96];
        StringBuilder sb = new StringBuilder();

        static {
            int i = 0;
            while (i < 32) {
                Writer.ESCAPED[i] = String.format("\\u%04x", i);
                ++i;
            }
            Writer.ESCAPED[8] = "\\b";
            Writer.ESCAPED[12] = "\\f";
            Writer.ESCAPED[10] = "\\n";
            Writer.ESCAPED[13] = "\\r";
            Writer.ESCAPED[9] = "\\t";
            Writer.ESCAPED[34] = "\\\"";
            Writer.ESCAPED[92] = "\\\\";
        }

        public Writer(Object object) {
            this.writeAny(object);
        }

        void writeAny(Object object) {
            if (object == null) {
                this.sb.append("null");
            } else if (object instanceof Boolean) {
                this.sb.append(object.toString());
            } else if (object instanceof Long) {
                this.sb.append((Long)object);
            } else if (object instanceof Integer) {
                this.sb.append((Integer)object);
            } else if (object instanceof Short) {
                this.sb.append(((Short)object).shortValue());
            } else if (object instanceof Byte) {
                this.sb.append(((Byte)object).byteValue());
            } else if (object instanceof Double) {
                this.sb.append((Double)object);
            } else if (object instanceof Float) {
                this.sb.append(((Float)object).floatValue());
            } else if (object instanceof String) {
                this.writeString(object.toString());
            } else if (object instanceof Object[]) {
                this.writeArray((Object[])object);
            } else {
                SWT.error(5, null, " [object not encodable: " + object.getClass() + "]");
            }
        }

        void writeString(String s) {
            this.sb.append('\"');
            int start = 0;
            int i = 0;
            int len = s.length();
            while (i < len) {
                char c = s.charAt(i);
                if (c < ESCAPED.length && ESCAPED[c] != null) {
                    this.sb.append(s, start, i);
                    this.sb.append(ESCAPED[c]);
                    start = i + 1;
                }
                ++i;
            }
            this.sb.append(s, start, s.length());
            this.sb.append('\"');
        }

        void writeArray(Object[] array) {
            this.sb.append('[');
            boolean first = true;
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!first) {
                    this.sb.append(',');
                }
                this.writeAny(item);
                first = false;
                ++n2;
            }
            this.sb.append(']');
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

