/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class MenuHelper {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("\\p{Alpha}[\\p{Alnum}+.-]*:.*");

    public static void trace(String msg, Throwable error) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)msg, (Throwable)error);
    }

    public static String getImageUrl(ImageDescriptor imageDescriptor) {
        return MenuHelper.getIconURI(imageDescriptor, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MExpression getVisibleWhen(IConfigurationElement commandAddition) {
        try {
            IConfigurationElement[] visibleConfig = commandAddition.getChildren("visibleWhen");
            if (visibleConfig.length <= 0) return null;
            if (visibleConfig.length >= 2) return null;
            IConfigurationElement[] visibleChild = visibleConfig[0].getChildren();
            if (visibleChild.length != 0) {
                if (visibleChild.length <= 0) return null;
                Expression visWhen = ExpressionConverter.getDefault().perform(visibleChild[0]);
                MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
                exp.setCoreExpressionId("programmatic.value");
                exp.setCoreExpression((Object)visWhen);
                return exp;
            }
            String checkEnabled = visibleConfig[0].getAttribute("checkEnabled");
            if (!Boolean.parseBoolean(checkEnabled)) return null;
            final String commandId = MenuHelper.getCommandId(commandAddition);
            if (commandId == null) {
                return null;
            }
            Expression visWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    EHandlerService service = MenuHelper.getFromContext(context, EHandlerService.class);
                    ICommandService commandService = MenuHelper.getFromContext(context, ICommandService.class);
                    if (service == null || commandService == null) {
                        WorkbenchPlugin.log("Could not retrieve EHandlerService or ICommandService from context evaluation context for" + commandId);
                        return EvaluationResult.FALSE;
                    }
                    Command c = commandService.getCommand(commandId);
                    ParameterizedCommand generateCommand = ParameterizedCommand.generateCommand((Command)c, (Map)Collections.EMPTY_MAP);
                    return EvaluationResult.valueOf((boolean)service.canExecute(generateCommand));
                }
            };
            MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
            exp.setCoreExpressionId("programmatic.value");
            exp.setCoreExpression((Object)visWhen);
            return exp;
        }
        catch (CoreException | InvalidRegistryObjectException e) {
            WorkbenchPlugin.log(e);
        }
        return null;
    }

    protected static <T> T getFromContext(IEvaluationContext context, Class<T> expectedType) {
        if (context == null || expectedType == null) {
            throw new NullPointerException();
        }
        Object rawValue = context.getVariable(expectedType.getName());
        return expectedType.isInstance(rawValue) ? (T)expectedType.cast(rawValue) : null;
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.isEmpty()) {
            id = MenuHelper.getCommandId(element);
        }
        if (id == null || id.isEmpty()) {
            id = MenuHelper.getConfigurationHandleId(element);
        }
        return id;
    }

    private static String getConfigurationHandleId(IConfigurationElement element) {
        return String.valueOf(element.getHandleId());
    }

    static String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    static int getMode(IConfigurationElement element) {
        if ("FORCE_TEXT".equals(element.getAttribute("mode"))) {
            return CommandContributionItem.MODE_FORCE_TEXT;
        }
        return 0;
    }

    static String getLabel(IConfigurationElement element) {
        return element.getAttribute("label");
    }

    static String getMnemonic(IConfigurationElement element) {
        return element.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement element) {
        return element.getAttribute("tooltip");
    }

    public static String getIconURI(IConfigurationElement element, String attr) {
        String iconPath = element.getAttribute(attr);
        if (iconPath == null) {
            return null;
        }
        if (!SCHEME_PATTERN.matcher(iconPath).matches()) {
            ImageDescriptor d = WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor(iconPath);
            if (d != null) {
                return MenuHelper.getImageUrl(d);
            }
            String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
            iconPath = "platform:/plugin/" + extendingPluginId + "/" + iconPath;
        }
        URL url = null;
        try {
            url = FileLocator.find((URL)new URL(iconPath));
        }
        catch (MalformedURLException malformedURLException) {}
        return url == null ? iconPath : MenuHelper.rewriteDurableURL(url.toString());
    }

    static String getHelpContextId(IConfigurationElement element) {
        return element.getAttribute("helpContextId");
    }

    public static boolean isSeparatorVisible(IConfigurationElement element) {
        String val = element.getAttribute("visible");
        return Boolean.parseBoolean(val);
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static ItemType getStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        if (style == null || style.isEmpty()) {
            return ItemType.PUSH;
        }
        if ("toggle".equals(style)) {
            return ItemType.CHECK;
        }
        if ("radio".equals(style)) {
            return ItemType.RADIO;
        }
        if ("pulldown".equals(style) && Policy.DEBUG_MENUS) {
            MenuHelper.trace("Failed to get style for pulldown", null);
        }
        return ItemType.PUSH;
    }

    public static boolean hasPulldownStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        return "pulldown".equals(style);
    }

    public static Map<String, String> getParameters(IConfigurationElement element) {
        IConfigurationElement[] parameters;
        HashMap<String, String> map = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = parameters = element.getChildren("parameter");
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement parameter = iConfigurationElementArray[n2];
            String name = parameter.getAttribute("name");
            String value = parameter.getAttribute("value");
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++n2;
        }
        return map;
    }

    public static MMenu createMenuAddition(IConfigurationElement menuAddition) {
        int idx;
        MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
        element.getPersistedState().put("persistState", Boolean.FALSE.toString());
        String id = MenuHelper.getId(menuAddition);
        element.setElementId(id);
        String text = MenuHelper.getLabel(menuAddition);
        String mnemonic = MenuHelper.getMnemonic(menuAddition);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        element.setVisibleWhen(MenuHelper.getVisibleWhen(menuAddition));
        element.setIconURI(MenuHelper.getIconURI(menuAddition, "icon"));
        element.setLabel(Util.safeString(text));
        return element;
    }

    public static MMenu createMenu(MenuManager manager) {
        MMenu subMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        subMenu.setLabel(manager.getMenuText());
        subMenu.setElementId(manager.getId());
        return subMenu;
    }

    public static MHandledToolItem createToolItem(MApplication application, CommandContributionItem cci) {
        MCommand command = MenuHelper.getMCommand(application, cci);
        if (command != null) {
            CommandContributionItemParameter data = cci.getData();
            MHandledToolItem toolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
            toolItem.setCommand(command);
            toolItem.setContributorURI(command.getContributorURI());
            toolItem.setVisible(cci.isVisible());
            String iconURI = null;
            String disabledIconURI = null;
            toolItem.setType(ItemType.PUSH);
            if (data.style == 32) {
                toolItem.setType(ItemType.CHECK);
            } else if (data.style == 16) {
                toolItem.setType(ItemType.RADIO);
            }
            if (data.icon != null) {
                iconURI = MenuHelper.getIconURI(data.icon, application.getContext());
            }
            if (iconURI == null) {
                iconURI = MenuHelper.getIconURI(command.getElementId(), application.getContext(), 0);
            }
            if (iconURI == null) {
                toolItem.setLabel(command.getCommandName());
            } else {
                toolItem.setIconURI(iconURI);
            }
            if (data.disabledIcon != null) {
                disabledIconURI = MenuHelper.getIconURI(data.disabledIcon, application.getContext());
            }
            if (disabledIconURI == null) {
                disabledIconURI = MenuHelper.getIconURI(command.getElementId(), application.getContext(), 1);
            }
            if (disabledIconURI != null) {
                MenuHelper.setDisabledIconURI((MToolItem)toolItem, disabledIconURI);
            }
            if (data.tooltip != null) {
                toolItem.setTooltip(data.tooltip);
            } else if (data.label != null) {
                toolItem.setTooltip(data.label);
            } else {
                toolItem.setTooltip(command.getDescription());
            }
            String itemId = cci.getId();
            toolItem.setElementId(itemId == null ? command.getElementId() : itemId);
            return toolItem;
        }
        return null;
    }

    public static MCommand getMCommand(MApplication application, CommandContributionItem contribution) {
        ParameterizedCommand command = contribution.getCommand();
        if (command != null) {
            for (MCommand mcommand : application.getCommands()) {
                if (!mcommand.getElementId().equals(command.getId())) continue;
                return mcommand;
            }
        }
        return null;
    }

    public static String getIconURI(ImageDescriptor descriptor, IEclipseContext context) {
        Adapter adapter;
        if (descriptor == null) {
            return null;
        }
        Adapter adapter2 = adapter = context != null ? (Adapter)context.get(Adapter.class) : null;
        if (adapter != null) {
            Object o = adapter.adapt((Object)descriptor, URL.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
            o = adapter.adapt((Object)descriptor, URI.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
        } else {
            Object o = Adapters.adapt((Object)descriptor, URL.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
            o = Adapters.adapt((Object)descriptor, URI.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
        }
        return null;
    }

    private static String rewriteDurableURL(String url) {
        if (!url.startsWith("bundleentry:") && !url.startsWith("bundleresource:")) {
            return url;
        }
        BundleContext ctxt = FrameworkUtil.getBundle(WorkbenchWindow.class).getBundleContext();
        try {
            URI uri = new URI(url);
            String host = uri.getHost();
            String bundleId = host.substring(0, host.indexOf(46));
            Bundle bundle = ctxt.getBundle(Long.parseLong(bundleId));
            StringBuilder builder = new StringBuilder("platform:/plugin/");
            builder.append(bundle.getSymbolicName());
            builder.append(uri.getPath());
            return builder.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return url;
        }
    }

    private static String getIconURI(String commandId, IEclipseContext workbench, int type) {
        if (commandId == null) {
            return null;
        }
        ICommandImageService imageService = (ICommandImageService)workbench.get(ICommandImageService.class);
        ImageDescriptor descriptor = imageService.getImageDescriptor(commandId, type);
        return MenuHelper.getIconURI(descriptor, workbench);
    }

    public static void setDisabledIconURI(MToolItem item, String disabledIconURI) {
        item.getTransientData().put("e4_disabled_icon_image_key", disabledIconURI);
    }
}

