/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class WorkbenchServiceRegistry
implements IExtensionChangeHandler {
    private static final String WORKBENCH_LEVEL = "workbench";
    private static final String EXT_ID_SERVICES = "org.eclipse.ui.services";
    private static WorkbenchServiceRegistry registry = null;
    public static final IServiceLocator GLOBAL_PARENT = new IServiceLocator(){

        @Override
        public <T> T getService(Class<T> api) {
            return null;
        }

        @Override
        public boolean hasService(Class<?> api) {
            return false;
        }
    };
    private final Map<String, ServiceFactoryHandle> factories = new HashMap<String, ServiceFactoryHandle>();
    private static final String[] supportedLevels = new String[]{"activeContexts", "activeShell", "activeWorkbenchWindow", "activeEditorId", "activePartId", "activeSite"};

    public static WorkbenchServiceRegistry getRegistry() {
        if (registry == null) {
            registry = new WorkbenchServiceRegistry();
        }
        return registry;
    }

    private WorkbenchServiceRegistry() {
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPoint()));
    }

    public Object getService(Class<?> key, IServiceLocator parentLocator, ServiceLocator locator) {
        Object result;
        ServiceFactoryHandle handle = this.factories.get(key.getName());
        if (handle == null) {
            handle = this.loadFromRegistry(key);
        }
        if (handle != null && (result = handle.factory.create(key, parentLocator, locator)) != null) {
            handle.serviceLocators.add(locator);
            return result;
        }
        return null;
    }

    private ServiceFactoryHandle loadFromRegistry(Class<?> key) {
        ServiceFactoryHandle result = null;
        IConfigurationElement[] serviceFactories = this.getExtensionPoint().getConfigurationElements();
        try {
            String requestedName = key.getName();
            boolean done = false;
            int i = 0;
            while (i < serviceFactories.length && !done) {
                IConfigurationElement[] serviceNameElements = serviceFactories[i].getChildren("service");
                int j = 0;
                while (j < serviceNameElements.length && !done) {
                    String serviceName = serviceNameElements[j].getAttribute("serviceClass");
                    if (requestedName.equals(serviceName)) {
                        done = true;
                    }
                    ++j;
                }
                if (done) {
                    AbstractServiceFactory f = (AbstractServiceFactory)serviceFactories[i].createExecutableExtension("factoryClass");
                    ServiceFactoryHandle handle = new ServiceFactoryHandle(f);
                    PlatformUI.getWorkbench().getExtensionTracker().registerObject(serviceFactories[i].getDeclaringExtension(), (Object)handle, 2);
                    ArrayList<String> serviceNames = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray = serviceNameElements;
                    int n = serviceNameElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement configElement = iConfigurationElementArray[n2];
                        String serviceName = configElement.getAttribute("serviceClass");
                        if (this.factories.containsKey(serviceName)) {
                            WorkbenchPlugin.log("Factory already exists for " + serviceName);
                        } else {
                            this.factories.put(serviceName, handle);
                            serviceNames.add(serviceName);
                        }
                        ++n2;
                    }
                    handle.serviceNames = serviceNames.toArray(new String[serviceNames.size()]);
                    result = handle;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        return result;
    }

    private IExtensionPoint getExtensionPoint() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtensionPoint(EXT_ID_SERVICES);
    }

    public AbstractSourceProvider[] getSourceProviders() {
        ArrayList<AbstractSourceProvider> providers = new ArrayList<AbstractSourceProvider>();
        IExtensionPoint ep = this.getExtensionPoint();
        IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (configElement.getName().equals("sourceProvider")) {
                try {
                    Object sourceProvider = configElement.createExecutableExtension("provider");
                    if (!(sourceProvider instanceof AbstractSourceProvider)) {
                        String attributeName = configElement.getAttribute("provider");
                        String message = "Source Provider '" + attributeName + "' should extend AbstractSourceProvider";
                        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, message);
                        WorkbenchPlugin.log((IStatus)status);
                    } else {
                        providers.add((AbstractSourceProvider)sourceProvider);
                        this.processVariables(configElement.getChildren("variable"));
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e.getStatus());
                }
            }
            ++n2;
        }
        return (AbstractSourceProvider[])providers.toArray(AbstractSourceProvider[]::new);
    }

    private void processVariables(IConfigurationElement[] children) {
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String name = configElement.getAttribute("name");
            if (name != null && !name.isEmpty()) {
                String level = configElement.getAttribute("priorityLevel");
                if (level == null || level.isEmpty()) {
                    level = WORKBENCH_LEVEL;
                } else {
                    boolean found = false;
                    int j = 0;
                    while (j < supportedLevels.length && !found) {
                        if (supportedLevels[j].equals(level)) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        level = WORKBENCH_LEVEL;
                    }
                }
                int existingPriority = SourcePriorityNameMapping.getMapping(level);
                int newPriority = existingPriority << 1;
                SourcePriorityNameMapping.addMapping(name, newPriority);
            }
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ServiceFactoryHandle) {
                ServiceFactoryHandle handle = (ServiceFactoryHandle)object;
                ServiceLocator[] locators = (ServiceLocator[])handle.serviceLocators.toArray(ServiceLocator[]::new);
                Arrays.sort(locators, (loc1, loc2) -> {
                    int l2;
                    int l1 = loc1.getService(IWorkbenchLocationService.class).getServiceLevel();
                    return l1 < (l2 = loc2.getService(IWorkbenchLocationService.class).getServiceLevel()) ? -1 : (l1 > l2 ? 1 : 0);
                });
                Object[] objectArray2 = locators;
                int n3 = locators.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServiceLocator locator = objectArray2[n4];
                    ServiceLocator serviceLocator = locator;
                    if (!serviceLocator.isDisposed()) {
                        serviceLocator.unregisterServices(handle.serviceNames);
                    }
                    ++n4;
                }
                handle.factory = null;
                objectArray2 = handle.serviceNames;
                n3 = handle.serviceNames.length;
                n4 = 0;
                while (n4 < n3) {
                    Object serviceName = objectArray2[n4];
                    if (this.factories.get(serviceName) == handle) {
                        this.factories.remove(serviceName);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    static class ServiceFactoryHandle {
        AbstractServiceFactory factory;
        final Set<ServiceLocator> serviceLocators = Collections.newSetFromMap(new WeakHashMap());
        String[] serviceNames;

        ServiceFactoryHandle(AbstractServiceFactory factory) {
            this.factory = factory;
        }
    }
}

