/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.eclipse.core.internal.jobs.ImplicitJobs;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.InternalJobGroup;
import org.eclipse.core.internal.jobs.InternalWorker;
import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.jobs.JobOSGiUtils;
import org.eclipse.core.internal.jobs.JobQueue;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;

public class JobManager
implements IJobManager,
DebugOptionsListener {
    private static final int NANOS_IN_MS = 1000000;
    public static final String PI_JOBS = "org.eclipse.core.jobs";
    public static final int PLUGIN_ERROR = 2;
    public static final long MAX_WAIT_INTERVAL = 100L;
    private static final String OPTION_DEADLOCK_ERROR = "org.eclipse.core.jobs/jobs/errorondeadlock";
    private static final String OPTION_DEBUG_BEGIN_END = "org.eclipse.core.jobs/jobs/beginend";
    private static final String OPTION_DEBUG_YIELDING = "org.eclipse.core.jobs/jobs/yielding";
    private static final String OPTION_DEBUG_YIELDING_DETAILED = "org.eclipse.core.jobs/jobs/yielding/detailed";
    private static final String OPTION_DEBUG_JOBS = "org.eclipse.core.jobs/jobs";
    private static final String OPTION_LOCKS = "org.eclipse.core.jobs/jobs/locks";
    private static final String OPTION_SHUTDOWN = "org.eclipse.core.jobs/jobs/shutdown";
    static DebugTrace DEBUG_TRACE;
    static boolean DEBUG;
    static boolean DEBUG_BEGIN_END;
    static boolean DEBUG_YIELDING;
    static boolean DEBUG_YIELDING_DETAILED;
    static boolean DEBUG_DEADLOCK;
    static boolean DEBUG_LOCKS;
    static boolean DEBUG_SHUTDOWN;
    private static JobManager instance;
    private final long originTime = System.nanoTime();
    private final AtomicLong currentTimeInMs;
    private static final ISchedulingRule nullRule;
    private volatile boolean active = true;
    final ImplicitJobs implicitJobs = new ImplicitJobs(this);
    private final JobListeners jobListeners = new JobListeners();
    final Object lock = new Object();
    private final IJobChangeListener jobGroupUpdater = IJobChangeListener.onDone(this::updateJobGroup);
    private final LockManager lockManager = new LockManager();
    private WorkerPool pool;
    private ProgressProvider progressProvider = null;
    private final HashSet<InternalJob> running;
    private final HashSet<InternalJob> yielding;
    private final JobQueue sleeping;
    private boolean suspended = false;
    private final JobQueue waiting;
    final JobQueue waitingThreadJobs;
    private final AtomicLong waitQueueCounter = new AtomicLong();
    final List<Object[]> monitorStack = new ArrayList<Object[]>();
    private final InternalWorker internalWorker;

    static {
        DEBUG = false;
        DEBUG_BEGIN_END = false;
        DEBUG_YIELDING = false;
        DEBUG_YIELDING_DETAILED = false;
        DEBUG_DEADLOCK = false;
        DEBUG_LOCKS = false;
        DEBUG_SHUTDOWN = false;
        nullRule = new ISchedulingRule(){

            @Override
            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            @Override
            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
    }

    public static void debug(String msg) {
        DEBUG_TRACE.trace(null, msg);
    }

    long getNextWaitQueueStamp() {
        return this.waitQueueCounter.getAndIncrement();
    }

    static synchronized JobManager getInstance() {
        if (instance == null) {
            new JobManager();
        }
        return instance;
    }

    private static String printJobName(Job job) {
        if (job instanceof ThreadJob) {
            Job realJob = ((ThreadJob)job).realJob;
            if (realJob != null) {
                return realJob.getClass().getName();
            }
            return "ThreadJob on rule: " + String.valueOf(job.getRule());
        }
        return job.getClass().getName();
    }

    public static String printState(Job job) {
        return JobManager.printState(job.internalGetState());
    }

    public static String printState(int state) {
        switch (state) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 4: {
                return "RUNNING";
            }
            case 8: {
                return "BLOCKED";
            }
            case 64: {
                return "YIELDING";
            }
            case 16: {
                return "ABOUT_TO_RUN";
            }
            case 32: {
                return "ABOUT_TO_SCHEDULE";
            }
        }
        return "UNKNOWN";
    }

    public static void shutdown() {
        if (instance != null) {
            instance.doShutdown();
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobManager() {
        this.currentTimeInMs = new AtomicLong(this.lifeTimeInMs());
        instance = this;
        Object object = this.lock;
        synchronized (object) {
            this.waiting = new JobQueue(false);
            this.waitingThreadJobs = new JobQueue(false, false);
            this.sleeping = new JobQueue(true);
            this.running = new HashSet(10);
            this.yielding = new HashSet(10);
            this.pool = new WorkerPool(this);
        }
        this.pool.setDaemon(JobOSGiUtils.getDefault().useDaemonThreads());
        this.internalWorker = new InternalWorker(this);
        this.internalWorker.setDaemon(JobOSGiUtils.getDefault().useDaemonThreads());
        this.internalWorker.start();
        this.jobListeners.add(this.jobGroupUpdater);
    }

    @Override
    public void addJobChangeListener(IJobChangeListener listener) {
        this.jobListeners.add(listener);
    }

    @Override
    public void beginRule(ISchedulingRule rule, IProgressMonitor monitor) {
        this.validateRule(rule);
        this.implicitJobs.begin(rule, this.monitorFor(monitor), false);
    }

    protected boolean cancel(InternalJob job) {
        IProgressMonitor[] monitor = new IProgressMonitor[1];
        boolean[] runCanceling = new boolean[1];
        Boolean canceled = this.withWriteLock(job, j -> {
            job.setAboutToRunCanceled(true);
            switch (job.getState()) {
                case 0: {
                    return true;
                }
                case 4: {
                    if (job.internalGetState() == 4) {
                        iProgressMonitorArray[0] = job.getProgressMonitor();
                        boolean bl = blArray[0] = !job.isRunCanceled();
                        if (!runCanceling[0]) break;
                        job.setRunCanceled(true);
                        break;
                    }
                    return false;
                }
                default: {
                    this.changeState(job, 0);
                }
            }
            if (monitor[0] == null) {
                this.jobListeners.queueDone((Job)job, Status.CANCEL_STATUS, false);
            }
            return null;
        });
        if (canceled != null) {
            return canceled;
        }
        if (monitor[0] != null) {
            if (runCanceling[0]) {
                if (!monitor[0].isCanceled()) {
                    monitor[0].setCanceled(true);
                }
                job.canceling();
            }
            return false;
        }
        return true;
    }

    @Override
    public void cancel(Object family) {
        for (InternalJob internalJob : this.select(family)) {
            this.cancel(internalJob);
        }
    }

    void cancel(InternalJobGroup jobGroup) {
        this.cancel(jobGroup, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(InternalJobGroup jobGroup, boolean cancelDueToError) {
        List<Job> jobsToCancel;
        Assert.isLegal((jobGroup != null ? 1 : 0) != 0, (String)"jobGroup should not be null");
        Object object = this.lock;
        synchronized (object) {
            jobsToCancel = jobGroup.cancelAndNotify(cancelDueToError);
        }
        for (Job job : jobsToCancel) {
            job.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(InternalJob job, int newState) {
        int oldJobState;
        assert (Thread.holdsLock(this.lock));
        boolean blockedJobs = false;
        Object object = job.jobStateLock;
        synchronized (object) {
            job.jobStateLock.notifyAll();
            oldJobState = job.getState();
            int oldState = job.internalGetState();
            switch (oldState) {
                case 64: {
                    this.yielding.remove(job);
                }
                case 0: 
                case 32: {
                    break;
                }
                case 8: {
                    job.remove();
                    break;
                }
                case 2: {
                    try {
                        this.waiting.remove(job);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal((boolean)false, (String)"Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 1: {
                    try {
                        this.sleeping.remove(job);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal((boolean)false, (String)"Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 4: 
                case 16: {
                    this.running.remove(job);
                    InternalJob blocked = job.previous();
                    job.remove();
                    blockedJobs = blocked != null;
                    while (blocked != null) {
                        InternalJob previous = blocked.previous();
                        this.changeState(blocked, 2);
                        blocked = previous;
                    }
                    break;
                }
                default: {
                    Assert.isLegal((boolean)false, (String)("Invalid job state: " + String.valueOf(job) + ", state: " + oldState));
                }
            }
            job.internalSetState(newState);
            switch (newState) {
                case 0: {
                    job.setStartTime(-1L);
                    job.setWaitQueueStamp(-1L);
                    job.setRunCanceled(false);
                }
                case 8: {
                    break;
                }
                case 2: {
                    this.waiting.enqueue(job);
                    break;
                }
                case 1: {
                    try {
                        this.sleeping.enqueue(job);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new RuntimeException("Error changing from state: " + oldState);
                    }
                }
                case 4: 
                case 16: {
                    job.setStartTime(-1L);
                    job.setWaitQueueStamp(-1L);
                    this.running.add(job);
                    break;
                }
                case 64: {
                    this.yielding.add(job);
                }
                case 32: {
                    break;
                }
                default: {
                    Assert.isLegal((boolean)false, (String)("Invalid job state: " + String.valueOf(job) + ", state: " + newState));
                }
            }
        }
        JobGroup jobGroup = job.getJobGroup();
        if (jobGroup != null) {
            jobGroup.jobStateChanged(job, oldJobState, job.getState());
        }
        if (blockedJobs) {
            this.pool.jobQueued();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProgressMonitor createMonitor(InternalJob job, IProgressMonitor group, int ticks) {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                if (job.getState() == 0) break block6;
                return null;
            }
            NullProgressMonitor monitor = null;
            if (this.progressProvider != null) {
                monitor = this.progressProvider.createMonitor((Job)job, group, ticks);
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            return monitor;
        }
    }

    /*
     * Exception decompiling
     */
    private <T, J extends InternalJob> T withWriteLock(J job, Function<J, T> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IProgressMonitor createMonitor(Job job) {
        if (this.progressProvider != null) {
            return this.progressProvider.createMonitor(job);
        }
        return new NullProgressMonitor();
    }

    @Override
    public IProgressMonitor createProgressGroup() {
        if (this.progressProvider != null) {
            return this.progressProvider.createProgressGroup();
        }
        return new NullProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job currentJob() {
        Thread current = Thread.currentThread();
        if (current instanceof Worker) {
            return ((Worker)current).currentJob();
        }
        Object object = this.lock;
        synchronized (object) {
            for (InternalJob internalJob : this.running) {
                Job job = (Job)internalJob;
                if (job.getThread() != current) continue;
                return job;
            }
        }
        return null;
    }

    @Override
    public ISchedulingRule currentRule() {
        Job currentJob = this.implicitJobs.getThreadJob(Thread.currentThread());
        if (currentJob != null) {
            return currentJob.getRule();
        }
        currentJob = this.currentJob();
        if (currentJob != null) {
            return currentJob.getRule();
        }
        return null;
    }

    private long delayFor(int priority) {
        switch (priority) {
            case 10: {
                return 0L;
            }
            case 20: {
                return 50L;
            }
            case 30: {
                return 100L;
            }
            case 40: {
                return 500L;
            }
            case 50: {
                return 1000L;
            }
        }
        Assert.isTrue((boolean)false, (String)("Job has invalid priority: " + priority));
        return 0L;
    }

    private boolean doSchedule(InternalJob job, long delay) {
        assert (Thread.holdsLock(this.lock));
        boolean cancelling = false;
        int state = job.internalGetState();
        if (state != 32 && state != 1) {
            return false;
        }
        if (job.isAboutToRunCanceled()) {
            cancelling = true;
            job.setResult(Status.CANCEL_STATUS);
            job.setProgressMonitor(null);
            job.setThread(null);
            this.changeState(job, 0);
        } else {
            if (job.getPriority() == 50 && job.getRule() == null) {
                long minDelay = this.running.size() * 100;
                delay = Math.max(delay, minDelay);
            }
            if (delay > 0L) {
                job.setStartTime(this.now() + delay);
                this.changeState(job, 1);
            } else {
                job.setStartTime(this.now() + this.delayFor(job.getPriority()));
                job.setWaitQueueStamp(this.getNextWaitQueueStamp());
                this.changeState(job, 2);
            }
        }
        if (cancelling) {
            this.jobListeners.queueDone((Job)job, Status.CANCEL_STATUS, false);
        }
        return !cancelling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() {
        Job element;
        int n;
        int n2;
        Job[] jobArray;
        Job[] toCancel = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                return;
            }
            this.active = false;
            toCancel = this.running.toArray(new Job[this.running.size()]);
            this.sleeping.clear();
            this.waiting.clear();
        }
        if (toCancel != null && toCancel.length > 0) {
            jobArray = toCancel;
            n2 = toCancel.length;
            n = 0;
            while (n < n2) {
                element = jobArray[n];
                this.cancel(element);
                ++n;
            }
            int waitAttempts22 = 0;
            while (waitAttempts22 < 3) {
                Thread.yield();
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.running.isEmpty()) {
                        break;
                    }
                }
                if (DEBUG_SHUTDOWN) {
                    JobManager.debug("Shutdown - job wait cycle #" + (waitAttempts22 + 1));
                    Job[] stillRunning = null;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        stillRunning = this.running.toArray(new Job[this.running.size()]);
                    }
                    if (stillRunning != null) {
                        Job[] jobArray2 = stillRunning;
                        int n3 = stillRunning.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Job element2 = jobArray2[n4];
                            JobManager.debug("\tJob: " + JobManager.printJobName(element2));
                            ++n4;
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                Thread.yield();
                ++waitAttempts22;
            }
            Object waitAttempts22 = this.lock;
            synchronized (waitAttempts22) {
                toCancel = this.running.toArray(new Job[this.running.size()]);
            }
        }
        this.internalWorker.cancel();
        if (toCancel != null) {
            jobArray = toCancel;
            n2 = toCancel.length;
            n = 0;
            while (n < n2) {
                element = jobArray[n];
                String jobName = JobManager.printJobName(element);
                String msg = "Job found still running after platform shutdown.  Jobs should be canceled by the plugin that scheduled them during shutdown: " + jobName;
                RuntimeLog.log((IStatus)new Status(2, PI_JOBS, 2, msg, null));
                System.err.println(msg);
                ++n;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.running.clear();
        }
        this.pool.shutdown();
        this.jobListeners.remove(this.jobGroupUpdater);
    }

    protected void endJob(InternalJob job, IStatus result, boolean notify, boolean worker) {
        if (result == Job.ASYNC_FINISH) {
            return;
        }
        Boolean scheduled = this.withWriteLock(job, j -> {
            boolean reschedule;
            long rescheduleDelay = -1L;
            if (job.getState() == 0) {
                return null;
            }
            if (DEBUG && notify) {
                JobManager.debug("Ending job: " + String.valueOf(job));
            }
            job.setResult(result);
            job.setProgressMonitor(null);
            job.setThread(null);
            rescheduleDelay = job.getStartTime();
            this.changeState(job, 0);
            boolean bl2 = reschedule = this.active && rescheduleDelay > -1L && job.shouldSchedule();
            if (notify) {
                this.jobListeners.queueDone((Job)job, result, reschedule);
            }
            if (reschedule) {
                return this.scheduleInternal(job, rescheduleDelay, reschedule);
            }
            return false;
        });
        if (scheduled == null) {
            return;
        }
        if (scheduled.booleanValue() && !worker) {
            this.pool.jobQueued();
        }
        if (job.getJobGroup() == null && result.matches(6)) {
            RuntimeLog.log((IStatus)result);
        }
    }

    @Override
    public void endRule(ISchedulingRule rule) {
        this.implicitJobs.end(rule, false);
    }

    @Override
    public Job[] find(Object family) {
        List<InternalJob> members = this.select(family);
        return members.toArray(new Job[members.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Job> find(InternalJobGroup jobGroup) {
        Assert.isLegal((jobGroup != null ? 1 : 0) != 0, (String)"jobGroup should not be null");
        Object object = this.lock;
        synchronized (object) {
            return jobGroup.internalGetActiveJobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalJob findBlockingJob(InternalJob waitingJob) {
        if (waitingJob.getRule() == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            block11: {
                block10: {
                    if (!this.running.isEmpty()) break block10;
                    return null;
                }
                boolean hasBlockedJobs = false;
                for (InternalJob job : this.running) {
                    if (waitingJob.isConflicting(job)) {
                        return job;
                    }
                    if (hasBlockedJobs) continue;
                    boolean bl = hasBlockedJobs = job.previous() != null;
                }
                if (hasBlockedJobs) break block11;
                return null;
            }
            for (InternalJob job : this.running) {
                while ((job = job.previous()) != null) {
                    if (!waitingJob.isConflicting(job)) continue;
                    return job;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalJob findBlockedJob(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            for (InternalJob waitingJob : this.waitingThreadJobs) {
                if (!waitingJob.isConflicting(job)) continue;
                return waitingJob;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue(JobQueue queue, InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            queue.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(JobQueue queue, InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            queue.enqueue(job);
        }
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    private String getWaitMessage(int jobCount) {
        String message = jobCount == 1 ? JobMessages.jobs_waitFamSubOne : JobMessages.jobs_waitFamSub;
        return NLS.bind((String)message, (Object)Integer.toString(jobCount));
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isBlocking(InternalJob runningJob) {
        Object object = this.lock;
        synchronized (object) {
            if (runningJob.getState() != 4) {
                return false;
            }
            InternalJob previous = runningJob.previous();
            while (previous != null) {
                if (previous.getPriority() < runningJob.getPriority()) {
                    if (!previous.isSystem()) {
                        return true;
                    }
                    if (previous instanceof ThreadJob && ((ThreadJob)previous).shouldInterrupt()) {
                        return true;
                    }
                }
                previous = previous.previous();
            }
            for (InternalJob waitingThreadJob : this.waitingThreadJobs) {
                ThreadJob waitingJob = (ThreadJob)waitingThreadJob;
                if (!runningJob.isConflicting(waitingJob) || !waitingJob.shouldInterrupt()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        Object object = this.lock;
        synchronized (object) {
            return this.running.isEmpty() && this.waiting.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspended() {
        Object object = this.lock;
        synchronized (object) {
            return this.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean join(InternalJob job, long timeout, IProgressMonitor monitor) throws InterruptedException {
        JobChangeAdapter listener;
        Semaphore barrier;
        Assert.isLegal((timeout >= 0L ? 1 : 0) != 0, (String)"timeout should not be negative");
        long deadline = timeout == 0L ? 0L : this.now() + timeout;
        Job currentJob = this.currentJob();
        if (currentJob != null) {
            JobGroup jobGroup = currentJob.getJobGroup();
            if (timeout == 0L && jobGroup != null && jobGroup.getMaxThreads() != 0 && jobGroup == job.getJobGroup()) {
                throw new IllegalStateException("Joining on a job belonging to the same group is not allowed");
            }
        }
        Object object = this.lock;
        synchronized (object) {
            int state;
            block18: {
                block17: {
                    state = job.getState();
                    if (state != 0) break block17;
                    return true;
                }
                if (!this.suspended || state == 4) break block18;
                return true;
            }
            if (state == 4 && job.getThread() == Thread.currentThread()) {
                throw new IllegalStateException("Job attempted to join itself");
            }
            barrier = new Semaphore(null);
            listener = new JobChangeAdapter(){

                @Override
                public void done(IJobChangeEvent event) {
                    barrier.release();
                }
            };
            job.addJobChangeListener(listener);
        }
        try {
            boolean canBlock = this.lockManager.canBlock();
            while (true) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                long remainingTime = deadline;
                if (deadline != 0L && (remainingTime -= this.now()) <= 0L) {
                    return false;
                }
                this.lockManager.aboutToWait(job.getThread());
                try {
                    long sleepTime = remainingTime != 0L && remainingTime <= 100L ? remainingTime : 100L;
                    if (!barrier.acquire(sleepTime)) continue;
                    return true;
                }
                catch (InterruptedException e) {
                    if (canBlock) throw e;
                    continue;
                }
                break;
            }
        }
        finally {
            this.lockManager.aboutToRelease();
            job.removeJobChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void join(final Object family, IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        monitor = this.monitorFor(monitor);
        listener = null;
        var6_4 = this.lock;
        synchronized (var6_4) {
            states = this.suspended != false ? 4 : 7;
            jobs = Collections.synchronizedSet(new HashSet<InternalJob>(this.select(family, states)));
            jobCount = jobs.size();
            if (jobCount > 0) {
                listener = new JobChangeAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void done(IJobChangeEvent event) {
                        Job job = event.getJob();
                        if (family == null || job.belongsTo(family)) {
                            if (((JobChangeEvent)event).reschedule) {
                                return;
                            }
                            boolean removed = jobs.remove(job);
                            if (!$assertionsDisabled && !removed) {
                                throw new AssertionError();
                            }
                            if (removed && jobs.isEmpty()) {
                                Set set = jobs;
                                synchronized (set) {
                                    jobs.notifyAll();
                                }
                            }
                        }
                    }

                    @Override
                    public void running(IJobChangeEvent event) {
                        Job job = event.getJob();
                        if (family == null || job.belongsTo(family)) {
                            jobs.add(job);
                        }
                    }

                    @Override
                    public void scheduled(IJobChangeEvent event) {
                        Job job = event.getJob();
                        if (family == null || job.belongsTo(family)) {
                            if (((JobChangeEvent)event).reschedule) {
                                return;
                            }
                            if (JobManager.this.isSuspended()) {
                                return;
                            }
                            boolean added = jobs.add(job);
                            if (!$assertionsDisabled && !added) {
                                throw new AssertionError();
                            }
                        }
                    }
                };
                this.addJobChangeListener(listener);
            }
        }
        if (jobCount == 0) {
            monitor.beginTask(JobMessages.jobs_blocked0, 1);
            monitor.done();
            return;
        }
        blockReports = 0;
        try {
            monitor.beginTask(JobMessages.jobs_blocked0, jobCount);
            monitor.subTask(this.getWaitMessage(jobCount));
            reportedWorkDone = 0;
            reportedBlockingJobs = Set.of();
            first = true;
            while (true) {
                var11_13 = jobs;
                synchronized (var11_13) {
                    if (jobs.isEmpty()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 18, 4, 9] lbl33 : MonitorExitStatement: MONITOREXIT : var11_13
                    }
                    if (first) {
                        first = false;
                    } else {
                        jobs.wait(100L);
                        if (jobs.isEmpty()) {
                            // MONITOREXIT @DISABLED, blocks:[16, 1, 2, 4, 9, 15] lbl40 : MonitorExitStatement: MONITOREXIT : var11_13
                        }
                    }
                    blockingJobs = new HashSet<InternalJob>(jobs);
                }
                jobsLeft = blockingJobs.size();
                if (!Objects.equals(reportedBlockingJobs, blockingJobs)) {
                    ++blockReports;
                    this.reportBlocked(monitor, blockingJobs);
                    reportedBlockingJobs = blockingJobs;
                }
                if (reportedWorkDone < (actualWorkDone = Math.max(0, jobCount - jobsLeft))) {
                    monitor.worked(actualWorkDone - reportedWorkDone);
                    reportedWorkDone = actualWorkDone;
                    monitor.subTask(this.getWaitMessage(jobsLeft));
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.lockManager.aboutToWait(null);
            }
        }
        finally {
            this.lockManager.aboutToRelease();
            this.removeJobChangeListener(listener);
            i = 0;
            ** while (i < blockReports)
        }
lbl-1000:
        // 1 sources

        {
            this.reportUnblocked(monitor);
            ++i;
            continue;
        }
lbl68:
        // 1 sources

        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean join(InternalJobGroup jobGroup, long timeout, IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        int jobCount;
        Assert.isLegal((jobGroup != null ? 1 : 0) != 0, (String)"jobGroup should not be null");
        Assert.isLegal((timeout >= 0L ? 1 : 0) != 0, (String)"timeout should not be negative");
        long deadline = timeout == 0L ? 0L : this.now() + timeout;
        Object object = this.lock;
        synchronized (object) {
            jobCount = jobGroup.getActiveJobsCount();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JobMessages.jobs_blocked0, (int)jobCount);
        try {
            while (true) {
                int jobsLeft;
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                long remainingTime = deadline;
                if (deadline != 0L && (remainingTime -= this.now()) <= 0L) {
                    return false;
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.suspended && jobGroup.getRunningJobsCount() == 0) {
                        break;
                    }
                }
                if (jobGroup.doJoin(remainingTime)) {
                    break;
                }
                Object object3 = this.lock;
                synchronized (object3) {
                    jobsLeft = jobGroup.getActiveJobsCount();
                }
                if (jobsLeft < jobCount) {
                    subMonitor.worked(jobCount - jobsLeft);
                }
                jobCount = jobsLeft;
                subMonitor.setWorkRemaining(jobCount);
                subMonitor.subTask(this.getWaitMessage(jobCount));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return true;
    }

    private IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (this.progressProvider != null) {
            try {
                IProgressMonitor monitorFor = this.progressProvider.monitorFor(monitor);
                if (monitorFor == null) {
                    throw new IllegalStateException("Internal error: " + this.progressProvider.getClass().getName() + "#monitorFor(" + String.valueOf(monitor) + ") returned null!");
                }
                return monitorFor;
            }
            catch (Exception e) {
                String msg = NLS.bind((String)JobMessages.meta_pluginProblems, (Object)PI_JOBS);
                RuntimeLog.log((IStatus)new Status(4, PI_JOBS, 2, msg, (Throwable)e));
            }
        }
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    @Override
    public ILock newLock() {
        return this.lockManager.newLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job nextJob() {
        Object object = this.lock;
        synchronized (object) {
            block10: {
                if (!this.suspended) break block10;
                return null;
            }
            long now = this.now();
            InternalJob job = this.sleeping.peek();
            while (job != null && job.getStartTime() < now) {
                job.setStartTime(now + this.delayFor(job.getPriority()));
                job.setWaitQueueStamp(this.getNextWaitQueueStamp());
                this.changeState(job, 2);
                job = this.sleeping.peek();
            }
            JobGroup jobGroup = null;
            job = this.waiting.peek();
            while (job != null) {
                InternalJob blocker = this.findBlockingJob(job);
                jobGroup = job.getJobGroup();
                InternalJob nextWaitingJob = job.previous();
                if (blocker != null) {
                    this.changeState(job, 8);
                    Assert.isTrue((job.next() == null ? 1 : 0) != 0);
                    Assert.isTrue((job.previous() == null ? 1 : 0) != 0);
                    blocker.addLast(job);
                } else if (jobGroup == null || ((InternalJobGroup)jobGroup).getMaxThreads() == 0 || ((InternalJobGroup)jobGroup).getState() != 2 && jobGroup.getRunningJobsCount() < ((InternalJobGroup)jobGroup).getMaxThreads()) break;
                InternalJob internalJob = job = nextWaitingJob == this.waiting.dummy ? null : nextWaitingJob;
            }
            if (job != null) {
                this.changeState(job, 16);
                if (DEBUG) {
                    JobManager.debug("Starting job: " + String.valueOf(job));
                }
            }
            return (Job)job;
        }
    }

    public long now() {
        long now = this.currentTimeInMs.updateAndGet(lastValue -> Math.max(lastValue, this.lifeTimeInMs()));
        return now;
    }

    private long lifeTimeInMs() {
        long now = Math.max(System.nanoTime() - this.originTime, 0L);
        return now / 1000000L;
    }

    public void optionsChanged(DebugOptions options) {
        DEBUG_TRACE = options.newDebugTrace(PI_JOBS);
        DEBUG = options.getBooleanOption(OPTION_DEBUG_JOBS, false);
        DEBUG_BEGIN_END = options.getBooleanOption(OPTION_DEBUG_BEGIN_END, false);
        DEBUG_YIELDING = options.getBooleanOption(OPTION_DEBUG_YIELDING, false);
        DEBUG_YIELDING_DETAILED = options.getBooleanOption(OPTION_DEBUG_YIELDING_DETAILED, false);
        DEBUG_DEADLOCK = options.getBooleanOption(OPTION_DEADLOCK_ERROR, false);
        DEBUG_LOCKS = options.getBooleanOption(OPTION_LOCKS, false);
        DEBUG_SHUTDOWN = options.getBooleanOption(OPTION_SHUTDOWN, false);
    }

    @Override
    public void removeJobChangeListener(IJobChangeListener listener) {
        this.jobListeners.remove(listener);
    }

    final void reportBlocked(IProgressMonitor monitor, Collection<InternalJob> blockingJobs) {
        Status reason;
        InternalJob blockingJob = blockingJobs.stream().sorted(Comparator.comparing(InternalJob::isSystem)).findFirst().orElse(null);
        if (blockingJob == null || blockingJob instanceof ThreadJob || blockingJob.isSystem()) {
            reason = new Status(1, PI_JOBS, 1, JobMessages.jobs_blocked0, null);
        } else {
            String msg = NLS.bind((String)JobMessages.jobs_blocked1, (Object)blockingJob.getName());
            reason = new JobStatus(1, (Job)blockingJob, msg);
        }
        monitor.setBlocked((IStatus)reason);
    }

    final void reportUnblocked(IProgressMonitor monitor) {
        monitor.clearBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.suspended = false;
            this.pool.jobQueued();
        }
    }

    @Override
    @Deprecated
    public final void resume(ISchedulingRule rule) {
        this.implicitJobs.resume(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalJob runNow(ThreadJob job, boolean releaseWaiting) {
        if (releaseWaiting) {
            ImplicitJobs implicitJobs = this.implicitJobs;
            synchronized (implicitJobs) {
                Object object = this.lock;
                synchronized (object) {
                    return this.doRunNow(job, releaseWaiting);
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            return this.doRunNow(job, releaseWaiting);
        }
    }

    private InternalJob doRunNow(ThreadJob job, boolean releaseWaiting) {
        InternalJob blocking = this.findBlockingJob(job);
        if (blocking == null) {
            this.changeState(job, 4);
            job.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            job.run(null);
            if (releaseWaiting) {
                this.implicitJobs.removeWaiting(job);
            }
        }
        return blocking;
    }

    protected void schedule(InternalJob job, long delay) {
        this.withWriteLock(job, j -> {
            if (this.scheduleInternal(job, delay, false)) {
                this.pool.jobQueued();
            }
            return null;
        });
    }

    protected boolean scheduleInternal(InternalJob job, long delay, boolean reschedule) {
        assert (Thread.holdsLock(this.lock));
        if (!this.active) {
            throw new IllegalStateException("Job manager has been shut down.");
        }
        Assert.isNotNull((Object)job, (String)"Job is null");
        Assert.isLegal((delay >= 0L ? 1 : 0) != 0, (String)"Scheduling delay is negative");
        if (!reschedule) {
            job.setAboutToRunCanceled(false);
        }
        if (job.getState() == 4) {
            job.setStartTime(delay);
            return false;
        }
        if (job.internalGetState() != 0) {
            return false;
        }
        if (DEBUG) {
            JobManager.debug("Scheduling job: " + String.valueOf(job));
        }
        this.changeState(job, 32);
        this.jobListeners.queueScheduled((Job)job, delay, reschedule);
        this.doSchedule(job, delay);
        return true;
    }

    private void select(List<InternalJob> members, Object family, InternalJob firstJob, int stateMask) {
        if (firstJob == null) {
            return;
        }
        InternalJob job = firstJob;
        do {
            if (family != null && !job.belongsTo(family) || (job.getState() & stateMask) == 0) continue;
            members.add(job);
        } while ((job = job.previous()) != null && job != firstJob);
    }

    private List<InternalJob> select(Object family) {
        return this.select(family, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InternalJob> select(Object family, int stateMask) {
        ArrayList<InternalJob> members = new ArrayList<InternalJob>();
        Object object = this.lock;
        synchronized (object) {
            if ((stateMask & 4) != 0) {
                for (InternalJob internalJob : this.running) {
                    this.select(members, family, internalJob, stateMask);
                }
            }
            if ((stateMask & 2) != 0) {
                this.select(members, family, this.waiting.peek(), stateMask);
                for (InternalJob internalJob : this.yielding) {
                    this.select(members, family, internalJob, stateMask);
                }
            }
            if ((stateMask & 1) != 0) {
                this.select(members, family, this.sleeping.peek(), stateMask);
            }
        }
        return members;
    }

    @Override
    public void setLockListener(LockListener listener) {
        this.lockManager.setLockListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPriority(InternalJob job, int newPriority) {
        Object object = this.lock;
        synchronized (object) {
            int oldPriority = job.getPriority();
            if (oldPriority == newPriority) {
                return;
            }
            job.internalSetPriority(newPriority);
            if (job.getState() == 2) {
                long oldStart = job.getStartTime();
                job.setStartTime(oldStart + (this.delayFor(newPriority) - this.delayFor(oldPriority)));
                this.waiting.resort(job);
            }
        }
    }

    @Override
    public void setProgressProvider(ProgressProvider provider) {
        this.progressProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRule(InternalJob job, ISchedulingRule rule) {
        Object object = this.lock;
        synchronized (object) {
            Assert.isLegal((job.getState() == 0 ? 1 : 0) != 0);
            this.validateRule(rule);
            job.internalSetRule(rule);
        }
    }

    protected boolean sleep(InternalJob job) {
        return this.withWriteLock(job, j -> {
            switch (job.getState()) {
                case 4: {
                    if (job.internalGetState() != 4) break;
                    return false;
                }
                case 1: {
                    job.setStartTime(Long.MAX_VALUE);
                    this.changeState(job, 1);
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            job.setStartTime(Long.MAX_VALUE);
            this.changeState(job, 1);
            this.jobListeners.queueSleeping((Job)job);
            return true;
        });
    }

    @Override
    public void sleep(Object family) {
        for (InternalJob internalJob : this.select(family)) {
            this.sleep(internalJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sleepHint() {
        Object object = this.lock;
        synchronized (object) {
            InternalJob next;
            block8: {
                block7: {
                    block6: {
                        if (!this.suspended) break block6;
                        return Long.MAX_VALUE;
                    }
                    if (this.waiting.isEmpty()) break block7;
                    return 0L;
                }
                next = this.sleeping.peek();
                if (next != null) break block8;
                return Long.MAX_VALUE;
            }
            return next.getStartTime() - this.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Job yieldRule(InternalJob job, IProgressMonitor monitor) {
        InternalJob unblocked;
        ThreadJob likeThreadJob;
        Thread currentThread = Thread.currentThread();
        Assert.isLegal((job.getState() == 4 ? 1 : 0) != 0, (String)("Cannot yieldRule job that is " + JobManager.printState(job.internalGetState())));
        Assert.isLegal((currentThread == job.getThread() ? 1 : 0) != 0, (String)"Cannot yieldRule from outside job's thread");
        ImplicitJobs implicitJobs = this.implicitJobs;
        synchronized (implicitJobs) {
            Object object = this.lock;
            synchronized (object) {
                likeThreadJob = this.implicitJobs.getThreadJob(currentThread);
                unblocked = job.previous();
                if (unblocked == null) {
                    if (likeThreadJob != null) {
                        unblocked = likeThreadJob.previous();
                        if (unblocked == null) {
                            unblocked = this.findBlockedJob(likeThreadJob);
                        }
                    } else {
                        unblocked = this.findBlockedJob(job);
                    }
                }
                if (unblocked == null) {
                    return null;
                }
                this.changeState(job, 64);
                if (DEBUG_YIELDING) {
                    JobManager.debug(String.valueOf(job) + " will yieldRule to " + String.valueOf(unblocked));
                }
                if (likeThreadJob != null && likeThreadJob != job) {
                    this.changeState(likeThreadJob, 64);
                    if (DEBUG_YIELDING) {
                        JobManager.debug(String.valueOf(job) + " will yieldRule to " + String.valueOf(unblocked));
                    }
                }
                if (likeThreadJob != null) {
                    job.setThread(null);
                    if (likeThreadJob.getRule() != null) {
                        this.getLockManager().removeLockThread(currentThread, likeThreadJob.getRule());
                    }
                }
                if (job.getRule() != null && !(job instanceof ThreadJob)) {
                    this.getLockManager().removeLockThread(currentThread, job.getRule());
                }
            }
        }
        if (DEBUG_YIELDING_DETAILED) {
            JobManager.debug(String.valueOf(job) + " is waiting for " + String.valueOf(unblocked) + " to transition from WAITING state");
        }
        this.waitForUnblocked(unblocked);
        IProgressMonitor mon = this.monitorFor(monitor);
        ProgressMonitorWrapper nonCanceling = new ProgressMonitorWrapper(mon){

            public boolean isCanceled() {
                this.getWrappedProgressMonitor().isCanceled();
                return false;
            }
        };
        if (DEBUG_YIELDING) {
            JobManager.debug(String.valueOf(job) + " waiting to resume");
        }
        if (likeThreadJob == null) {
            ThreadJob threadJob = new ThreadJob(job.getRule()){

                @Override
                boolean isResumingAfterYield() {
                    return true;
                }
            };
            threadJob.setRealJob((Job)job);
            ThreadJob.joinRun(threadJob, (IProgressMonitor)nonCanceling);
            Object object = this.lock;
            synchronized (object) {
                this.changeState(threadJob, 0);
                this.changeState(job, 4);
                job.setThread(currentThread);
            }
        }
        ThreadJob.joinRun(likeThreadJob, (IProgressMonitor)nonCanceling);
        Object object = this.lock;
        synchronized (object) {
            this.changeState(job, 4);
            job.setThread(currentThread);
        }
        if (DEBUG_YIELDING) {
            object = this.lock;
            synchronized (object) {
                Iterator<InternalJob> iterator = this.running.iterator();
                while (iterator.hasNext()) {
                    InternalJob other = iterator.next();
                    if (other == job) continue;
                    Assert.isTrue((!other.isConflicting(job) ? 1 : 0) != 0, (String)(String.valueOf(other) + " conflicts and ran simultaneously with " + String.valueOf(job)));
                }
            }
            JobManager.debug(String.valueOf(job) + " resumed");
        }
        if (unblocked instanceof ThreadJob && ((ThreadJob)unblocked).isResumingAfterYield()) {
            return ((ThreadJob)unblocked).realJob;
        }
        return (Job)unblocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void waitForUnblocked(InternalJob theJob) {
        block10: {
            interrupted = false;
            var3_3 = theJob.jobStateLock;
            synchronized (var3_3) {
                if (!(theJob instanceof ThreadJob)) ** GOTO lbl19
                while (((ThreadJob)theJob).isWaiting) {
                    try {
                        theJob.jobStateLock.wait();
                    }
                    catch (InterruptedException v0) {
                        interrupted = true;
                    }
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    try {
                        theJob.jobStateLock.wait();
                        continue;
                    }
                    catch (InterruptedException v1) {
                        interrupted = true;
                    }
lbl19:
                    // 3 sources

                    ** while (theJob.internalGetState() == 2)
                }
lbl20:
                // 1 sources

            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean shouldRun(Job job) {
        try {
            return job.shouldRun();
        }
        catch (AssertionError | Exception | LinkageError e) {
            Object t = e;
            RuntimeLog.log((IStatus)new Status(4, PI_JOBS, 2, "Error invoking shouldRun() method on: " + String.valueOf(job), (Throwable)t));
            return false;
        }
    }

    protected Job startJob(Worker worker) {
        Job job = null;
        while (true) {
            Boolean endJob;
            if ((job = this.nextJob()) == null) {
                return null;
            }
            boolean shouldRun = this.shouldRun(job);
            if (shouldRun) {
                this.jobListeners.queueAboutToRun(job);
                this.jobListeners.waitAndSendEvents(job, true);
            }
            if ((endJob = this.withWriteLock(job, j -> {
                block6: {
                    JobGroup jobGroup = j.getJobGroup();
                    boolean shouldReallyRun = shouldRun && (jobGroup == null || jobGroup.getState() != 2);
                    Job internal = j;
                    Object object = internal.jobStateLock;
                    synchronized (object) {
                        block5: {
                            if (internal.internalGetState() != 16) break block6;
                            if (!shouldReallyRun || internal.isAboutToRunCanceled()) break block5;
                            if (internal.getProgressMonitor() == null) {
                                internal.setProgressMonitor(this.createMonitor((Job)j));
                            }
                            ((InternalJob)internal).setThread(worker);
                            internal.internalSetState(4);
                            internal.jobStateLock.notifyAll();
                            this.jobListeners.queueRunning((Job)j);
                            return null;
                        }
                        return true;
                    }
                }
                return false;
            })) == null) break;
            if (!endJob.booleanValue()) continue;
            this.endJob(job, Status.CANCEL_STATUS, true, false);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void suspend() {
        Object object = this.lock;
        synchronized (object) {
            this.suspended = true;
        }
    }

    @Override
    @Deprecated
    public final void suspend(ISchedulingRule rule, IProgressMonitor monitor) {
        Assert.isNotNull((Object)rule);
        this.implicitJobs.suspend(rule, this.monitorFor(monitor));
    }

    @Override
    public void transferRule(ISchedulingRule rule, Thread destinationThread) {
        this.implicitJobs.transfer(rule, destinationThread);
    }

    private void validateRule(ISchedulingRule rule) {
        if (rule == null) {
            return;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] children;
            ISchedulingRule[] iSchedulingRuleArray = children = ((MultiRule)rule).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule element = iSchedulingRuleArray[n2];
                Assert.isLegal((element != rule ? 1 : 0) != 0);
                this.validateRule(element);
                ++n2;
            }
        }
        Assert.isLegal((boolean)rule.contains(rule));
        Assert.isLegal((!rule.contains(nullRule) ? 1 : 0) != 0);
        Assert.isLegal((boolean)rule.isConflicting(rule));
        Assert.isLegal((!rule.isConflicting(nullRule) ? 1 : 0) != 0);
    }

    protected void wakeUp(InternalJob job, long delay) {
        Assert.isLegal((delay >= 0L ? 1 : 0) != 0, (String)"Scheduling delay is negative");
        boolean notSleeping = this.withWriteLock(job, j -> {
            if (job.getState() != 1) {
                return true;
            }
            boolean scheduled = this.doSchedule(job, delay);
            if (scheduled && delay == 0L) {
                this.jobListeners.queueAwake((Job)job);
            }
            return false;
        });
        if (notSleeping) {
            return;
        }
        this.pool.jobQueued();
    }

    @Override
    public void wakeUp(Object family) {
        for (InternalJob internalJob : this.select(family)) {
            this.wakeUp(internalJob, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endMonitoring(ThreadJob threadJob) {
        List<Object[]> list = this.monitorStack;
        synchronized (list) {
            int i = this.monitorStack.size() - 1;
            while (i >= 0) {
                if (this.monitorStack.get(i)[0] == threadJob) {
                    this.monitorStack.remove(i);
                    this.monitorStack.notifyAll();
                    break;
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginMonitoring(ThreadJob threadJob, IProgressMonitor monitor) {
        List<Object[]> list = this.monitorStack;
        synchronized (list) {
            this.monitorStack.add(new Object[]{threadJob, monitor});
            this.monitorStack.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobGroup(IJobChangeEvent event) {
        int seedJobsRemainingCount;
        int canceledJobsCount;
        int failedJobsCount;
        int activeJobsCount;
        int jobGroupState;
        Job job = event.getJob();
        JobGroup jobGroup = ((InternalJob)job).getJobGroup();
        if (jobGroup == null) {
            return;
        }
        IStatus jobResult = event.getResult();
        boolean reschedule = ((JobChangeEvent)event).reschedule;
        List<IStatus> jobResults = Collections.emptyList();
        Object object = this.lock;
        synchronized (object) {
            jobGroupState = ((InternalJobGroup)jobGroup).getState();
            activeJobsCount = jobGroup.getActiveJobsCount();
            failedJobsCount = jobGroup.getFailedJobsCount();
            canceledJobsCount = jobGroup.getCanceledJobsCount();
            seedJobsRemainingCount = jobGroup.getSeedJobsRemainingCount();
            if (activeJobsCount == 0) {
                jobResults = jobGroup.getCompletedJobResults();
            }
        }
        if (!(reschedule || jobGroupState == 0 || activeJobsCount != 0 || seedJobsRemainingCount > 0 && jobGroupState != 2)) {
            MultiStatus jobGroupResult = ((InternalJobGroup)jobGroup).computeGroupResult(jobResults);
            Assert.isLegal((jobGroupResult != null ? 1 : 0) != 0, (String)"The group result should not be null");
            boolean isJobGroupCompleted = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (((InternalJobGroup)jobGroup).getState() != 0 && jobGroup.getActiveJobsCount() == 0) {
                    jobGroup.endJobGroup(jobGroupResult);
                    isJobGroupCompleted = true;
                }
            }
            if (isJobGroupCompleted) {
                ((JobChangeEvent)event).jobGroupResult = jobGroupResult;
                if (jobGroupResult.matches(6)) {
                    RuntimeLog.log((IStatus)jobGroupResult);
                }
            }
            return;
        }
        if (jobGroupState != 2 && ((InternalJobGroup)jobGroup).shouldCancel(jobResult, failedJobsCount, canceledJobsCount)) {
            this.cancel(jobGroup, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return "waiting: " + String.valueOf(this.waiting) + "\nsleeping: " + String.valueOf(this.sleeping) + "\nrunnning: " + String.valueOf(this.running) + "\nyielding: " + String.valueOf(this.yielding);
        }
    }
}

