/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.viewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public final class ColumnResizer {
    private ColumnResizer() {
        throw new RuntimeException("No instances");
    }

    public static Handler addColumnResizer(Tree tree) {
        return new TreeColumnResizeHandler(tree);
    }

    public static Handler addColumnResizer(Table table) {
        return new TableColumnResizeHandler(table);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ColumnResizerHandler<T extends Composite, C extends Item>
    extends Handler
    implements ControlListener {
        private static int PADDING = SWT.getPlatform().equals("cocoa") ? 28 : 10;
        private final T control;
        private final ParentHandler parentHandler;
        private int clientWidth = -1;
        private List<Integer> columnWidths = Collections.emptyList();
        private boolean resizing;

        public ColumnResizerHandler(T control) {
            this.control = control;
            for (Item column : this.getColumns()) {
                this.disableResizeable(column);
            }
            this.parentHandler = new ParentHandler((Composite)control);
            control.addControlListener((ControlListener)this);
        }

        public T getControl() {
            return this.control;
        }

        protected abstract boolean isPackable();

        protected abstract List<? extends C> getColumns();

        protected abstract void disableResizeable(C var1);

        protected abstract int getWidth(C var1);

        protected abstract void setWidth(C var1, int var2);

        protected abstract void pack(C var1);

        protected List<Integer> getColumnWidths() {
            List<C> columns = this.getColumns();
            ArrayList<Integer> result = new ArrayList<Integer>(columns.size());
            for (Item column : columns) {
                result.add(this.getWidth(column));
            }
            return result;
        }

        public void controlResized(ControlEvent controlEvent) {
            if (!this.resizing && this.isPackable()) {
                boolean inputChanged;
                T control = this.getControl();
                Rectangle clientArea = control.getClientArea();
                int clientWidth = clientArea.width - clientArea.x;
                List<Integer> columnWidths = this.getColumnWidths();
                boolean bl = inputChanged = controlEvent == null;
                if (inputChanged || clientWidth != this.clientWidth || this.columnWidths.equals(columnWidths)) {
                    try {
                        this.resizing = true;
                        control.setRedraw(false);
                        List<C> columns = this.getColumns();
                        for (Item column : columns) {
                            this.pack(column);
                        }
                        List<Integer> packedColumnWidths = this.getColumnWidths();
                        int total = 0;
                        int limit = columns.size() - 1;
                        int i = 0;
                        while (i < limit) {
                            int width = packedColumnWidths.get(i) + PADDING;
                            total += width;
                            this.setWidth((Item)columns.get(i), width);
                            ++i;
                        }
                        int width = packedColumnWidths.get(limit);
                        if (total + width < clientWidth) {
                            width = clientWidth - total;
                        }
                        this.setWidth((Item)columns.get(limit), width);
                    }
                    finally {
                        this.clientWidth = clientWidth;
                        this.columnWidths = this.getColumnWidths();
                        control.setRedraw(true);
                        this.parentHandler.run();
                        this.resizing = false;
                    }
                }
            }
        }

        public void controlMoved(ControlEvent e) {
        }

        @Override
        public void resizeColumns() {
            this.controlResized(null);
        }

        @Override
        public void dispose() {
            this.parentHandler.dispose();
            this.control.removeControlListener((ControlListener)this);
        }
    }

    public static abstract class Handler {
        private Handler() {
        }

        public abstract void resizeColumns();

        public abstract void dispose();
    }

    private static class ParentHandler
    extends ControlAdapter
    implements DisposeListener,
    Runnable {
        private final Composite control;
        private final Composite parent;
        private boolean dispatched;

        public ParentHandler(Composite control) {
            this.control = control;
            this.parent = control.getParent();
            control.addDisposeListener((DisposeListener)this);
            this.parent.addControlListener((ControlListener)this);
        }

        public void run() {
            if (!this.parent.isDisposed() && this.dispatched) {
                this.dispatched = false;
                this.parent.setRedraw(true);
            }
        }

        public void controlResized(ControlEvent e) {
            if (!this.dispatched) {
                this.parent.setRedraw(false);
                this.dispatched = true;
                this.parent.getDisplay().asyncExec((Runnable)this);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.parent.removeControlListener((ControlListener)this);
        }

        public void dispose() {
            this.run();
            this.dispatched = false;
            this.control.removeDisposeListener((DisposeListener)this);
            this.parent.removeControlListener((ControlListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnResizeHandler
    extends ColumnResizerHandler<Table, TableColumn> {
        public TableColumnResizeHandler(Table table) {
            super(table);
        }

        @Override
        protected List<? extends TableColumn> getColumns() {
            return Arrays.asList(((Table)this.getControl()).getColumns());
        }

        @Override
        protected void disableResizeable(TableColumn column) {
            column.setResizable(false);
        }

        @Override
        protected int getWidth(TableColumn column) {
            return column.getWidth();
        }

        @Override
        protected void setWidth(TableColumn column, int width) {
            column.setWidth(width);
        }

        @Override
        protected boolean isPackable() {
            TableItem[] items = ((Table)this.getControl()).getItems();
            return items.length == 0 || !items[0].isDisposed();
        }

        @Override
        protected void pack(TableColumn column) {
            column.pack();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeColumnResizeHandler
    extends ColumnResizerHandler<Tree, TreeColumn> {
        public TreeColumnResizeHandler(Tree tree) {
            super(tree);
            class TreeStateListener
            implements TreeListener,
            Runnable {
                private boolean dispatched;

                TreeStateListener() {
                }

                public void run() {
                    this.dispatched = false;
                    if (!((Tree)TreeColumnResizeHandler.this.getControl()).isDisposed()) {
                        TreeColumnResizeHandler.this.resizeColumns();
                    }
                }

                private void dispatch() {
                    if (!this.dispatched) {
                        this.dispatched = true;
                        ((Tree)TreeColumnResizeHandler.this.getControl()).getDisplay().asyncExec((Runnable)this);
                    }
                }

                public void treeCollapsed(TreeEvent e) {
                    this.dispatch();
                }

                public void treeExpanded(TreeEvent e) {
                    this.dispatch();
                }
            }
            tree.addTreeListener((TreeListener)new TreeStateListener());
        }

        @Override
        protected List<? extends TreeColumn> getColumns() {
            return Arrays.asList(((Tree)this.getControl()).getColumns());
        }

        @Override
        protected void disableResizeable(TreeColumn column) {
            column.setResizable(false);
        }

        @Override
        protected int getWidth(TreeColumn column) {
            return column.getWidth();
        }

        @Override
        protected void setWidth(TreeColumn column, int width) {
            column.setWidth(width);
        }

        @Override
        protected boolean isPackable() {
            TreeItem[] items = ((Tree)this.getControl()).getItems();
            return items.length == 0 || !items[0].isDisposed();
        }

        @Override
        protected void pack(TreeColumn column) {
            column.pack();
        }
    }
}

