/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.oomph.maven.util.MavenValidator;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class POMXMLUtil {
    private static final String USER_DATA_LOCATION_KEY = "location";
    private static final String USER_DATA_PARENT_ELEMENT_KEY = "parent";
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final XPathFactory XPATH_FACTORY;
    private static final Pattern ELEMENT_NAME_PATTERN;
    private static final String XPATH_DELIMITER = "/";
    private static final String POM_PREFIX_REPLACEMENT = "pom:$0";
    private static final String START_MARKER = "\u00ab";
    private static final String END_MARKER = "\u00bb";
    private static Pattern START_ELEMENT_PATTERN;

    static {
        try {
            DOCUMENT_BUILDER = XMLUtil.createDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        XPATH_FACTORY = XPathFactory.newInstance();
        ELEMENT_NAME_PATTERN = Pattern.compile("^[a-zA-Z]+$");
        START_ELEMENT_PATTERN = Pattern.compile("\u00ab<([^ \r\n\t/>]+)");
    }

    public static final Document parseDocument(Path path) throws IOException, SAXException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Document document = DOCUMENT_BUILDER.parse(inputStream);
            document.setUserData(USER_DATA_LOCATION_KEY, path, null);
            return document;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Path getLocation(Element element) {
        return POMXMLUtil.getLocation(element.getOwnerDocument());
    }

    public static final Path getLocation(Document document) {
        return (Path)document.getUserData(USER_DATA_LOCATION_KEY);
    }

    private static XPath newXPath(final Document document) {
        XPath xPath = XPATH_FACTORY.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("")) {
                    return document.lookupNamespaceURI(null);
                }
                String result = document.lookupNamespaceURI(prefix);
                if (result == null) {
                    result = document.lookupNamespaceURI(null);
                }
                return result;
            }

            @Override
            public Iterator<String> getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return document.lookupPrefix(namespaceURI);
            }
        });
        return xPath;
    }

    public static SegmentSequence xpath(String ... segments) {
        return SegmentSequence.create((String)XPATH_DELIMITER, (String[])((String[])Stream.of(segments).map(segment -> ELEMENT_NAME_PATTERN.matcher((CharSequence)segment).replaceAll(POM_PREFIX_REPLACEMENT)).toArray(String[]::new)));
    }

    public static Element getElement(Node node, SegmentSequence xpath) {
        List<Element> elements = POMXMLUtil.getElements(node, xpath);
        return elements.isEmpty() ? null : elements.get(0);
    }

    public static List<Element> getElements(Node node) {
        return POMXMLUtil.getElements(node, POMXMLUtil.xpath("*"));
    }

    public static List<Element> getElements(Node node, SegmentSequence xpath) {
        XPath xPath = POMXMLUtil.newXPath(node.getOwnerDocument());
        try {
            NodeList nodeList = (NodeList)xPath.compile(xpath.toString()).evaluate(node, XPathConstants.NODESET);
            ArrayList<Element> result = new ArrayList<Element>();
            int i = 0;
            int length = nodeList.getLength();
            while (i < length) {
                Node item = nodeList.item(i);
                if (item instanceof Element) {
                    Element element = (Element)item;
                    result.add(element);
                }
                ++i;
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(xpath.toString());
        }
    }

    public static String toString(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter out = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(out));
        return out.toString();
    }

    public static Charset getEncoding(Document document) {
        String xmlEncoding = document.getXmlEncoding();
        return xmlEncoding == null ? StandardCharsets.UTF_8 : Charset.forName(xmlEncoding);
    }

    public static String getLocationContent(Document document) {
        Path location = POMXMLUtil.getLocation(document);
        if (location != null) {
            try {
                String originalContent = Files.readString(location, POMXMLUtil.getEncoding(document));
                return originalContent;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Element createChildElement(Element parent, String elementName) {
        Element element = parent.getOwnerDocument().createElement(elementName);
        element.setUserData(USER_DATA_PARENT_ELEMENT_KEY, parent, null);
        return element;
    }

    private static Element getParent(Node node) {
        return (Element)node.getUserData(USER_DATA_PARENT_ELEMENT_KEY);
    }

    /*
     * Exception decompiling
     */
    public static TextRegion getSelection(Element element) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<Document, String> applyElementEdits(Map<Document, Map<TextRegion, MavenValidator.ElementEdit>> elementEdits) {
        LinkedHashMap<Document, String> result = new LinkedHashMap<Document, String>();
        for (Map.Entry<Document, Map<TextRegion, MavenValidator.ElementEdit>> entry : elementEdits.entrySet()) {
            Document document = entry.getKey();
            String content = POMXMLUtil.getLocationContent(document);
            if (content == null) continue;
            int index = 0;
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<TextRegion, MavenValidator.ElementEdit> editEntry : new TreeMap<TextRegion, MavenValidator.ElementEdit>(entry.getValue()).entrySet()) {
                int newLineIndex;
                TextRegion textRegion = editEntry.getKey();
                builder.append(content, index, textRegion.start());
                index = textRegion.end();
                String replacedContent = content.substring(textRegion.start(), index);
                String indent = "";
                Object nestedIdent = "";
                if (replacedContent.isBlank() && (newLineIndex = replacedContent.lastIndexOf(10)) != -1) {
                    indent = replacedContent;
                    nestedIdent = indent.indexOf(9) != -1 ? indent + "\t" : indent + "  ";
                }
                MavenValidator.ElementEdit elementEdit = editEntry.getValue();
                Element element = elementEdit.element();
                String elementName = element.getNodeName();
                builder.append((String)nestedIdent).append('<').append(elementName).append('>');
                builder.append(elementEdit.value());
                builder.append("</").append(elementName).append('>').append(indent);
            }
            builder.append(content.substring(index));
            result.put(document, builder.toString());
        }
        return result;
    }

    public record TextRegion(int start, int end) implements Comparable<TextRegion>
    {
        public int length() {
            return this.end - this.start;
        }

        @Override
        public int compareTo(TextRegion o) {
            int result = Integer.compare(this.start, o.start);
            if (result == 0) {
                result = Integer.compare(this.end, o.end);
            }
            return result;
        }
    }
}

