/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs.cpd;

import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.cpd.CustomizePerspectiveDialog;

class UnavailableContributionItemCheckListener
implements ICheckStateListener {
    private final CustomizePerspectiveDialog dialog;
    private CheckboxTreeViewer viewer;
    private ICheckStateListener originalListener;

    public UnavailableContributionItemCheckListener(CustomizePerspectiveDialog dialog, CheckboxTreeViewer viewer, ICheckStateListener originalListener) {
        this.dialog = dialog;
        this.viewer = viewer;
        this.originalListener = originalListener;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        ViewerFilter[] filters;
        CustomizePerspectiveDialog.DisplayItem item = (CustomizePerspectiveDialog.DisplayItem)event.getElement();
        boolean isEffectivelyAvailable = CustomizePerspectiveDialog.isEffectivelyAvailable(item, (filters = this.viewer.getFilters()).length > 0 ? filters[0] : null);
        if (isEffectivelyAvailable) {
            this.originalListener.checkStateChanged(event);
            return;
        }
        boolean isAvailable = CustomizePerspectiveDialog.isAvailable(item);
        this.viewer.update(event.getElement(), null);
        if (isAvailable) {
            if (!this.viewer.getExpandedState((Object)item)) {
                this.viewer.expandToLevel((Object)item, -1);
            }
            MessageBox mb = new MessageBox(this.viewer.getControl().getShell(), 268435496);
            mb.setText(WorkbenchMessages.HideItemsCannotMakeVisible_dialogTitle);
            mb.setMessage(NLS.bind((String)WorkbenchMessages.HideItemsCannotMakeVisible_unavailableChildrenText, (Object)item.getLabel()));
            mb.open();
        } else {
            MessageBox mb;
            if (item.getIContributionItem() instanceof HandledContributionItem) {
                mb = new MessageBox(this.viewer.getControl().getShell(), 268435496);
                mb.setText(WorkbenchMessages.HideItemsCannotMakeVisible_dialogTitle);
                String errorExplanation = NLS.bind((String)WorkbenchMessages.HideItemsCannotMakeVisible_unavailableCommandItemText, (Object)item.getLabel());
                mb.setMessage(errorExplanation);
            } else {
                mb = new MessageBox(this.viewer.getControl().getShell(), 268435656);
                mb.setText(WorkbenchMessages.HideItemsCannotMakeVisible_dialogTitle);
                String errorExplanation = NLS.bind((String)WorkbenchMessages.HideItemsCannotMakeVisible_unavailableCommandGroupText, (Object)item.getLabel(), (Object)item.getActionSet());
                String message = NLS.bind((String)"{0}{1}{1}{2}", (Object[])new Object[]{errorExplanation, CustomizePerspectiveDialog.NEW_LINE, WorkbenchMessages.HideItemsCannotMakeVisible_switchToCommandGroupTab});
                mb.setMessage(message);
            }
            if (mb.open() == 64) {
                this.dialog.showActionSet(item);
            }
        }
    }
}

