/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ParameterAnnotation;

public class RuntimeVisibleParameterAnnotationsAttribute
extends ClassFileAttribute {
    private static final ParameterAnnotation[] NO_ENTRIES = new ParameterAnnotation[0];
    private final int parametersNumber;
    private ParameterAnnotation[] parameterAnnotations;

    public RuntimeVisibleParameterAnnotationsAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.parametersNumber = length = this.u1At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 7;
            this.parameterAnnotations = new ParameterAnnotation[length];
            int i = 0;
            while (i < length) {
                ParameterAnnotation parameterAnnotation;
                this.parameterAnnotations[i] = parameterAnnotation = new ParameterAnnotation(classFileBytes, constantPool, offset + readOffset);
                readOffset += parameterAnnotation.sizeInBytes();
                ++i;
            }
        } else {
            this.parameterAnnotations = NO_ENTRIES;
        }
    }

    public ParameterAnnotation[] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public int getParametersNumber() {
        return this.parametersNumber;
    }
}

