/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.internal.core.LazyProfileRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyProfile
extends Profile {
    private final LazyProfileRegistry registry;
    private final File profileDirectory;
    private SoftReference<Profile> delegate;
    private Profile parent;

    public LazyProfile(LazyProfileRegistry registry, String profileId, File profileDirectory) {
        super(registry.getProvisioningAgent(), profileId, null, null);
        this.registry = registry;
        this.profileDirectory = profileDirectory;
    }

    public synchronized Profile getDelegate(boolean loadOnDemand) {
        if (this.delegate != null) {
            Profile referent = this.delegate.get();
            if (referent != null) {
                return referent;
            }
            this.delegate = null;
        }
        if (!loadOnDemand) {
            return null;
        }
        String profileId = this.getProfileId();
        Profile referent = this.registry.loadProfile(profileId, this.profileDirectory);
        if (referent == null) {
            throw new P2Exception("Profile '" + profileId + "' could not be loaded from " + this.profileDirectory);
        }
        referent.setParent(this.parent);
        this.delegate = new SoftReference<Profile>(referent);
        return referent;
    }

    private Profile getDelegate() {
        return this.getDelegate(true);
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return this.getDelegate().query(query, monitor);
    }

    public IProfile getParentProfile() {
        return this.getDelegate().getParentProfile();
    }

    public synchronized void setParent(Profile parent) {
        this.parent = parent;
        Profile delegate = this.getDelegate(false);
        if (delegate != null) {
            delegate.setParent(parent);
        }
    }

    public boolean isRootProfile() {
        return this.getDelegate().isRootProfile();
    }

    public void addSubProfile(String subProfileId) throws IllegalArgumentException {
        this.getDelegate().addSubProfile(subProfileId);
    }

    public void removeSubProfile(String subProfileId) throws IllegalArgumentException {
        this.getDelegate().removeSubProfile(subProfileId);
    }

    public boolean hasSubProfiles() {
        return this.getDelegate().hasSubProfiles();
    }

    public List<String> getSubProfileIds() {
        return this.getDelegate().getSubProfileIds();
    }

    public String getProperty(String key) {
        StackTraceElement[] stackTrace;
        Profile delegate = this.getDelegate();
        if ("org.eclipse.equinox.p2.cache".equals(key) && "true".equals(delegate.getProperty("org.eclipse.oomph.p2.profile.shared.pool")) && (stackTrace = Thread.currentThread().getStackTrace()).length > 3 && "updateRoamingProfile".equals(stackTrace[2].getMethodName())) {
            return delegate.getProperty("org.eclipse.equinox.p2.installFolder");
        }
        return delegate.getProperty(key);
    }

    public String getLocalProperty(String key) {
        return this.getDelegate().getLocalProperty(key);
    }

    public void setProperty(String key, String value) {
        Profile delegate = this.getDelegate();
        if ("org.eclipse.equinox.p2.cache".equals(key) && "true".equals(delegate.getProperty("org.eclipse.oomph.p2.profile.shared.pool")) && delegate.getProperty("org.eclipse.equinox.p2.cache") != null) {
            return;
        }
        delegate.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.getDelegate().removeProperty(key);
    }

    public synchronized IIndex<IInstallableUnit> getIndex(String memberName) {
        return this.getDelegate().getIndex(memberName);
    }

    public Iterator<IInstallableUnit> everything() {
        return this.getDelegate().everything();
    }

    public Object getManagedProperty(Object client, String memberName, Object key) {
        return this.getDelegate().getManagedProperty(client, memberName, key);
    }

    public IQueryResult<IInstallableUnit> available(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return this.getDelegate().available(query, monitor);
    }

    public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
        return this.getDelegate().getInstallableUnitProperty(iu, key);
    }

    public String setInstallableUnitProperty(IInstallableUnit iu, String key, String value) {
        return this.getDelegate().setInstallableUnitProperty(iu, key, value);
    }

    public String removeInstallableUnitProperty(IInstallableUnit iu, String key) {
        return this.getDelegate().removeInstallableUnitProperty(iu, key);
    }

    public Map<String, String> getLocalProperties() {
        return this.getDelegate().getLocalProperties();
    }

    public Map<String, String> getProperties() {
        return this.getDelegate().getProperties();
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.getDelegate().getProvisioningAgent();
    }

    public void addProperties(Map<String, String> properties) {
        this.getDelegate().addProperties(properties);
    }

    public void addInstallableUnit(IInstallableUnit iu) {
        this.getDelegate().addInstallableUnit(iu);
    }

    public void removeInstallableUnit(IInstallableUnit iu) {
        this.getDelegate().removeInstallableUnit(iu);
    }

    public Map<String, String> getInstallableUnitProperties(IInstallableUnit iu) {
        return this.getDelegate().getInstallableUnitProperties(iu);
    }

    public void clearLocalProperties() {
        this.getDelegate().clearLocalProperties();
    }

    public boolean isChanged() {
        return this.getDelegate().isChanged();
    }

    public void setChanged(boolean isChanged) {
        this.getDelegate().setChanged(isChanged);
    }

    public void clearInstallableUnits() {
        this.getDelegate().clearInstallableUnits();
    }

    public Profile snapshot() {
        return this.getDelegate().snapshot();
    }

    public void addInstallableUnitProperties(IInstallableUnit iu, Map<String, String> properties) {
        this.getDelegate().addInstallableUnitProperties(iu, properties);
    }

    public void clearInstallableUnitProperties(IInstallableUnit iu) {
        this.getDelegate().clearInstallableUnitProperties(iu);
    }

    public void clearOrphanedInstallableUnitProperties() {
        this.getDelegate().clearOrphanedInstallableUnitProperties();
    }

    public long getTimestamp() {
        return this.getDelegate().getTimestamp();
    }

    public void setTimestamp(long millis) {
        this.getDelegate().setTimestamp(millis);
    }

    public void setSurrogateProfileHandler(ISurrogateProfileHandler surrogateProfileHandler) {
        this.getDelegate().setSurrogateProfileHandler(surrogateProfileHandler);
    }

    public String toString() {
        return this.getProfileId();
    }
}

