/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.oomph.internal.ui.AbstractPreferencePage;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.ui.StorageConfigurationComposite;

public class SynchronizerPreferencePage
extends AbstractPreferencePage {
    public static final String ID = "org.eclipse.oomph.setup.SynchronizerPreferencePage";
    private Button enableButton;
    private StorageConfigurationComposite storageConfigurationComposite;
    private Button syncButton;
    private Button deleteButton;
    private boolean initialEnabled = SynchronizerManager.INSTANCE.isSyncEnabled();

    protected Control doCreateContents(Composite parent) {
        IStorage storage = SynchronizerManager.INSTANCE.getStorage();
        IStorageService service = storage.getService();
        boolean showServices = StorageConfigurationComposite.isShowServices();
        GridLayout layout = new GridLayout(showServices ? 2 : 1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)layout);
        if (service == null && !showServices) {
            Label label = new Label(main, 0);
            label.setText("No service available.");
        } else {
            this.enableButton = new Button(main, 32);
            this.enableButton.setText("Synchronize with" + (showServices ? ":" : " " + service.getServiceLabel()));
            this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SynchronizerPreferencePage.this.updateEnablement();
                }
            });
            if (showServices) {
                this.storageConfigurationComposite = new StorageConfigurationComposite(main, 0, storage){

                    protected StructuredViewer createViewer(Composite parent) {
                        TableComboViewer viewer = new TableComboViewer(parent, 2056);
                        TableCombo tableCombo = viewer.getTableCombo();
                        tableCombo.defineColumns(2);
                        tableCombo.setToolTipText("Select the service to synchronize with");
                        return viewer;
                    }
                };
            }
            this.syncButton = new Button(main, 8);
            this.syncButton.setText("Synchronize Now...");
            this.syncButton.setLayoutData((Object)new GridData(16384, 4, false, false, layout.numColumns, 1));
            this.syncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SynchronizerPreferencePage.this.performApply();
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    final Display display = window.getShell().getDisplay();
                    UIUtil.asyncExec((Display)display, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                Shell activeShell = display.getActiveShell();
                                Object data = activeShell.getData();
                                if (data instanceof PreferenceDialog) {
                                    PreferenceDialog preferenceDialog = (PreferenceDialog)data;
                                    ReflectUtil.invokeMethod((String)"okPressed", (Object)preferenceDialog);
                                }
                            }
                            catch (Throwable ex) {
                                SetupUIPlugin.INSTANCE.log(ex);
                            }
                        }
                    });
                    UIUtil.asyncExec((Display)display, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                Shell shell = SetupPropertyTester.getHandlingShell();
                                if (shell != null) {
                                    shell.setVisible(true);
                                } else {
                                    SynchronizerManager.Impact impact = SynchronizerManager.INSTANCE.performFullSynchronization();
                                    if (impact != null && impact.hasLocalImpact()) {
                                        SetupWizard.Updater.perform(false);
                                    }
                                }
                            }
                            catch (Throwable ex) {
                                SetupUIPlugin.INSTANCE.log(ex);
                            }
                        }
                    });
                }
            });
            this.enableButton.setSelection(this.initialEnabled);
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    SynchronizerPreferencePage.this.updateEnablement();
                }
            });
        }
        return main;
    }

    protected void performDefaults() {
        if (this.enableButton != null) {
            this.enableButton.setSelection(this.initialEnabled);
            this.updateEnablement();
        }
        if (this.storageConfigurationComposite != null) {
            this.storageConfigurationComposite.performDefaults();
        }
        super.performDefaults();
    }

    protected void performApply() {
        if (this.enableButton != null) {
            this.updateEnablement();
        }
        super.performApply();
    }

    public boolean performOk() {
        if (this.enableButton != null) {
            if (this.storageConfigurationComposite != null) {
                this.storageConfigurationComposite.performApply();
            }
            this.initialEnabled = this.enableButton.getSelection();
            SynchronizerManager.INSTANCE.setSyncEnabled(this.initialEnabled);
        }
        return super.performOk();
    }

    private boolean needsApply() {
        block4: {
            if (this.enableButton == null || this.enableButton.getSelection() == this.initialEnabled) break block4;
            return true;
        }
        try {
            if (this.storageConfigurationComposite != null) {
                return this.storageConfigurationComposite.isDirty();
            }
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
        return false;
    }

    private void updateEnablement() {
        Button applyButton;
        boolean enabled;
        boolean bl = enabled = this.enableButton != null ? this.enableButton.getSelection() : false;
        if (this.storageConfigurationComposite != null) {
            this.storageConfigurationComposite.setEnabled(enabled);
        }
        if (this.syncButton != null) {
            this.syncButton.setEnabled(enabled);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(enabled);
        }
        boolean needsApply = this.needsApply();
        Button defaultsButton = this.getDefaultsButton();
        if (defaultsButton != null) {
            defaultsButton.setEnabled(needsApply);
        }
        if ((applyButton = this.getApplyButton()) != null) {
            applyButton.setEnabled(needsApply);
        }
    }
}

