/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.osgi.service.log.LogLevel;

public class LogThrottle {
    private LinkedBlockingQueue<String> fThrottleQueue;
    private HashMap<String, MutableInt> fActiveMessages = new HashMap();
    private String fThrottleMessage;
    private int fThrottleValue;

    public LogThrottle(int queueSize, int throttleValue) {
        this.fThrottleValue = throttleValue;
        this.fThrottleQueue = new LinkedBlockingQueue(queueSize);
        this.fThrottleMessage = MessageFormat.format("The previous message has been throttled.\nThe previous message has been logged {0} times and will not be logged again.", this.fThrottleValue);
    }

    public boolean log(int logLevel, String message, Throwable e) {
        int store = this.store(message);
        if (store <= this.fThrottleValue) {
            Activator.log((int)logLevel, (String)message, (Throwable)e);
        }
        if (store == this.fThrottleValue) {
            Activator.log((int)LogLevel.WARN.ordinal(), (String)this.fThrottleMessage);
        }
        return store <= this.fThrottleValue;
    }

    public LogThrottle setThrottle(int throttleValue) {
        if (throttleValue > 0) {
            this.fThrottleValue = throttleValue;
        }
        return this;
    }

    protected synchronized int store(String messageText) {
        MutableInt counter = this.check(messageText);
        counter.increment();
        if (counter.fCount >= this.fThrottleValue) {
            this.fThrottleQueue.remove(messageText);
            while (!this.fThrottleQueue.offer(messageText)) {
                String message = this.fThrottleQueue.poll();
                this.fActiveMessages.remove(message);
            }
        }
        return counter.fCount;
    }

    private synchronized MutableInt check(String messageText) {
        MutableInt counter = this.fActiveMessages.get(messageText);
        if (counter == null) {
            counter = new MutableInt();
            this.fActiveMessages.put(messageText, counter);
        }
        return counter;
    }

    private class MutableInt {
        private int fCount;

        private MutableInt() {
        }

        public void increment() {
            ++this.fCount;
        }
    }
}

