/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.LazyResourceManager;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@NoInstantiate
@NoExtend
public class JFaceResources {
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final Map<Display, ResourceManager> registries = new HashMap<Display, ResourceManager>();
    public static final String BANNER_FONT = "org.eclipse.jface.bannerfont";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.jface.messages");
    private static ColorRegistry colorRegistry;
    public static final String DEFAULT_FONT = "org.eclipse.jface.defaultfont";
    public static final String DIALOG_FONT = "org.eclipse.jface.dialogfont";
    private static FontRegistry fontRegistry;
    public static final String HEADER_FONT = "org.eclipse.jface.headerfont";
    private static ImageRegistry imageRegistry;
    public static final String TEXT_FONT = "org.eclipse.jface.textfont";
    @Deprecated
    public static final String VIEWER_FONT = "org.eclipse.jface.viewerfont";
    @Deprecated
    public static final String WINDOW_FONT = "org.eclipse.jface.windowfont";
    private static final int CACHE_SIZE;

    static {
        fontRegistry = null;
        imageRegistry = null;
        CACHE_SIZE = Integer.getInteger("org.eclipse.jface.resource.cacheSize", 300);
    }

    public static String format(String key, Object ... args) {
        return MessageFormat.format(JFaceResources.getString(key), args);
    }

    public static Font getBannerFont() {
        return JFaceResources.getFontRegistry().get(BANNER_FONT);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry();
        }
        return colorRegistry;
    }

    public static ResourceManager getResources(Display toQuery) {
        Objects.requireNonNull(toQuery, "toQuery");
        ResourceManager reg = registries.get(toQuery);
        if (reg == null) {
            reg = CACHE_SIZE == 0 ? new DeviceResourceManager((Device)toQuery) : new LazyResourceManager(CACHE_SIZE, new DeviceResourceManager((Device)toQuery));
            registries.put(toQuery, reg);
            ResourceManager mgr = reg;
            toQuery.disposeExec(() -> {
                mgr.dispose();
                registries.remove(toQuery);
            });
        }
        return reg;
    }

    public static ResourceManager getResources() {
        Display display = Display.getCurrent();
        Objects.requireNonNull(display, "This is not an UI thread (or Device already disposed)");
        return JFaceResources.getResources(display);
    }

    public static Font getDefaultFont() {
        return JFaceResources.getFontRegistry().defaultFont();
    }

    public static FontDescriptor getDefaultFontDescriptor() {
        return JFaceResources.getFontRegistry().defaultFontDescriptor();
    }

    public static Font getDialogFont() {
        return JFaceResources.getFontRegistry().get(DIALOG_FONT);
    }

    public static FontDescriptor getDialogFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(DIALOG_FONT);
    }

    public static Font getFont(String symbolicName) {
        return JFaceResources.getFontRegistry().get(symbolicName);
    }

    public static FontDescriptor getFontDescriptor(String symbolicName) {
        return JFaceResources.getFontRegistry().getDescriptor(symbolicName);
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry("org.eclipse.jface.resource.jfacefonts");
        }
        return fontRegistry;
    }

    public static Font getHeaderFont() {
        return JFaceResources.getFontRegistry().get(HEADER_FONT);
    }

    public static FontDescriptor getHeaderFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(HEADER_FONT);
    }

    public static Image getImage(String key) {
        return JFaceResources.getImageRegistry().get(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(JFaceResources.getResources(Display.getCurrent()));
            JFaceResources.initializeDefaultImages();
        }
        return imageRegistry;
    }

    private static void initializeDefaultImages() {
        Bundle bundle = null;
        try {
            bundle = FrameworkUtil.getBundle(JFaceResources.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JFaceResources.declareImage(bundle, "org.eclipse.jface.wizard.Wizard.pageImage", "$nl$/icons/full/page.png", Wizard.class, "images/page.png");
        JFaceResources.declareImage(bundle, "dialog_messasge_info_image", "$nl$/icons/full/message_info.png", Dialog.class, "images/message_info.png");
        JFaceResources.declareImage(bundle, "dialog_messasge_warning_image", "$nl$/icons/full/message_warning.png", Dialog.class, "images/message_warning.png");
        JFaceResources.declareImage(bundle, "dialog_message_error_image", "$nl$/icons/full/message_error.png", Dialog.class, "images/message_error.png");
        JFaceResources.declareImage(bundle, "dialog_help_image", "$nl$/icons/full/help.png", Dialog.class, "images/help.png");
        JFaceResources.declareImage(bundle, "dialog_title_banner_image", "$nl$/icons/full/title_banner.png", TitleAreaDialog.class, "images/title_banner.png");
        JFaceResources.declareImage(bundle, "preference_dialog_title_image", "$nl$/icons/full/pref_dialog_title.png", PreferenceDialog.class, "images/pref_dialog_title.png");
        JFaceResources.declareImage(bundle, "popup_menu_image", "$nl$/icons/full/popup_menu.png", PopupDialog.class, "images/popup_menu.png");
        JFaceResources.declareImage(bundle, "popup_menu_image_diabled", "$nl$/icons/full/popup_menu_disabled.png", PopupDialog.class, "images/popup_menu_disabled.png");
    }

    private static final void declareImage(Object bundle, String key, String path, Class<?> fallback, String fallbackPath) {
        imageRegistry.put(key, ImageDescriptor.createFromURLSupplier(false, () -> {
            URL url;
            if (bundle != null && (url = FileLocator.find((Bundle)((Bundle)bundle), (IPath)IPath.fromOSString((String)path), null)) != null) {
                return url;
            }
            return fallback.getResource(fallbackPath);
        }));
    }

    public static String getString(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String[] getStrings(String[] keys) {
        Assert.isNotNull((Object)keys);
        int length = keys.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = JFaceResources.getString(keys[i]);
            ++i;
        }
        return result;
    }

    public static Font getTextFont() {
        return JFaceResources.getFontRegistry().get(TEXT_FONT);
    }

    public static FontDescriptor getTextFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(TEXT_FONT);
    }

    @Deprecated
    public static Font getViewerFont() {
        return JFaceResources.getFontRegistry().get(VIEWER_FONT);
    }

    public static void setFontRegistry(FontRegistry registry) {
        Assert.isTrue((fontRegistry == null ? 1 : 0) != 0, (String)"Font registry can only be set once.");
        fontRegistry = registry;
    }

    public static LocalResourceManager managerFor(Control owner) {
        return new LocalResourceManager(JFaceResources.getResources(), owner);
    }

    private JFaceResources() {
    }
}

