/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.QuickFixWizard;
import org.eclipse.ui.internal.views.markers.ShowMarkers;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class QuickFixHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MarkerSupportView view = this.getView(event);
        if (view == null) {
            return this;
        }
        LinkedHashMap<IMarkerResolution, Collection<IMarker>> resolutionsMap = new LinkedHashMap<IMarkerResolution, Collection<IMarker>>();
        IMarker[] selectedMarkers = view.getSelectedMarkers();
        IMarker firstSelectedMarker = selectedMarkers[0];
        IRunnableWithProgress resolutionsRunnable = monitor -> {
            monitor.beginTask(MarkerMessages.resolveMarkerAction_computationManyAction, 100);
            IMarker[] allMarkers = view.getAllMarkers();
            monitor.worked(20);
            IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(firstSelectedMarker);
            int progressCount = 80;
            if (resolutions.length > 1) {
                progressCount /= resolutions.length;
            }
            IMarkerResolution[] iMarkerResolutionArray = resolutions;
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution markerResolution = iMarkerResolutionArray[n2];
                if (markerResolution instanceof WorkbenchMarkerResolution) {
                    Object[] other = ((WorkbenchMarkerResolution)markerResolution).findOtherMarkers(allMarkers);
                    if (QuickFixHandler.containsAllButFirst(other, selectedMarkers)) {
                        LinkedHashSet<Object> markers1 = new LinkedHashSet<Object>(other.length + 1);
                        markers1.add(firstSelectedMarker);
                        markers1.addAll(Arrays.asList(other));
                        resolutionsMap.put(markerResolution, markers1);
                    }
                } else if (selectedMarkers.length == 1) {
                    ArrayList<IMarker> markers2 = new ArrayList<IMarker>(1);
                    markers2.add(firstSelectedMarker);
                    resolutionsMap.put(markerResolution, markers2);
                }
                monitor.worked(progressCount);
                ++n2;
            }
            monitor.done();
        };
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)Adapters.adapt((Object)view.getSite(), IWorkbenchSiteProgressService.class);
        ProgressMonitorDialog context = new ProgressMonitorDialog(view.getSite().getShell());
        try {
            if (service == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, resolutionsRunnable, null);
            } else {
                service.runInUI((IRunnableContext)context, resolutionsRunnable, null);
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        String markerDescription = firstSelectedMarker.getAttribute("message", "");
        if (resolutionsMap.isEmpty()) {
            if (selectedMarkers.length == 1) {
                MessageDialog.openInformation((Shell)view.getSite().getShell(), (String)MarkerMessages.resolveMarkerAction_dialogTitle, (String)NLS.bind((String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFound, (Object[])new Object[]{markerDescription}));
            } else {
                MessageDialog.openInformation((Shell)view.getSite().getShell(), (String)MarkerMessages.resolveMarkerAction_dialogTitle, (String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFoundForMultiSelection);
            }
        } else {
            String description = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)markerDescription);
            Consumer<StructuredViewer> showMarkers = v -> {
                ShowMarkers showMarkers = new ShowMarkers((StructuredViewer)v, view.getSite());
            };
            Consumer<Control> bindHelp = c -> PlatformUI.getWorkbench().getHelpSystem().setHelp(c, "org.eclipse.ui.problem_view_context");
            Consumer<Throwable> reporter = t -> StatusManager.getManager().handle(StatusUtil.newError(t));
            QuickFixWizard wizard = new QuickFixWizard(description, selectedMarkers, resolutionsMap, showMarkers, bindHelp, reporter);
            wizard.setWindowTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
            QuickFixWizardDialog dialog = new QuickFixWizardDialog(view.getSite().getShell(), (IWizard)wizard);
            dialog.open();
        }
        return this;
    }

    private static boolean containsAllButFirst(Object[] extent, Object[] members) {
        int i = 1;
        while (i < members.length) {
            block3: {
                Object[] objectArray = extent;
                int n = extent.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray[n2];
                    if (members[i] != e) {
                        ++n2;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class QuickFixWizardDialog
    extends WizardDialog {
        public QuickFixWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(0xC70 | QuickFixWizardDialog.getDefaultOrientation());
        }
    }
}

