/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.jetty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.passage.lbc.runtime.ServerRequestExecutor;
import org.eclipse.passage.lbc.runtime.ServerRequestHandler;

public class JettyRequestHandler
extends AbstractHandler
implements ServerRequestHandler {
    private List<ServerRequestExecutor> serverRequestExecutors = new ArrayList<ServerRequestExecutor>();

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (ServerRequestExecutor requestExecutor : this.serverRequestExecutors) {
            if (!requestExecutor.checkAccesstMode((HttpServletRequest)baseRequest)) continue;
            requestExecutor.executeRequest(request, response);
            baseRequest.setHandled(true);
        }
    }

    public void addRequestExecutor(ServerRequestExecutor executor) {
        if (!this.serverRequestExecutors.contains(executor)) {
            this.serverRequestExecutors.add(executor);
        }
    }

    public void remRequestExecutor(ServerRequestExecutor executor) {
        if (this.serverRequestExecutors.contains(executor)) {
            this.serverRequestExecutors.remove(executor);
        }
    }
}

