/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.details;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DashboardDetailsPart {
    private final IEclipseContext contex;

    @Inject
    public DashboardDetailsPart(IEclipseContext context) {
        this.contex = context;
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Label header = new Label(content, 0);
        header.setFont(JFaceResources.getHeaderFont());
        header.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 128).grab(true, false).indent(0, 20).create());
        String pattern = "Welcome to %s";
        String brandingName = ((IApplicationContext)this.contex.get(IApplicationContext.class)).getBrandingName();
        header.setText(String.format(pattern, brandingName));
        Label title = new Label(content, 0);
        title.setFont(JFaceResources.getBannerFont());
        title.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 128).grab(true, false).indent(0, 10).create());
        title.setText("Quick Start Guide");
        StyledText styled = new StyledText(content, 586);
        styled.setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 128).grab(true, true).create());
        String text = this.composeWelcomeText();
        styled.setText(text);
        styled.setBackground(JFaceColors.getInformationViewerBackgroundColor((Display)Display.getDefault()));
    }

    protected String composeWelcomeText() {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("1. Create Feature Set").append('\n');
        sb.append("The 'Feature Set' groups the related functionality that may be distributed via several 'Products'");
        sb.append('\n');
        sb.append('\n');
        sb.append("2. Create Features").append('\n');
        sb.append("The 'Feature' corresponds to the scenario for your product, that you want to restrict. ");
        sb.append("For example, you may want to restrict export to some proprieatry format or other actions. ");
        sb.append("You do not need to describe all the funcionality of your 'Product', but only the parts you want to restrict. ");
        sb.append("The 'identifier' attribute of the 'Feature' is important for the licensing configuration.");
        sb.append('\n');
        sb.append('\n');
        sb.append("3. Create Feature Versions").append('\n');
        sb.append("The 'Feature Version' is a state of your 'Feature' that included to the 'Product Version'. ");
        sb.append("The 'version' attribute of the 'Feature Version' is important for the licensing configuration.");
        sb.append('\n');
        sb.append('\n');
        sb.append("4. Create Product Line").append('\n');
        sb.append("The 'Product Line' groups the related 'Products' in your offering. It may be different editions of the related functionality.");
        sb.append('\n');
        sb.append('\n');
        sb.append("5. Create Product").append('\n');
        sb.append("The 'Product' corresponds to the ready-to-use item in your offering. ");
        sb.append("The 'identifier' attribute of the 'Product' is important for the licensing configuration.");
        sb.append('\n');
        sb.append('\n');
        sb.append("6. Create Product Version").append('\n');
        sb.append("The 'Product Version' corresponds to the binaries you are planning to release or already released for the 'Product'. ");
        sb.append("It is recommended to create the 'Product Version' for each external 'Product' shipment. ");
        sb.append("The 'version' attribute of the 'Product Version' is important for the licensing configuration. ");
        sb.append("The 'Product Version' completes the definition of licensing configuration that will be checked in the user environment.");
        sb.append('\n');
        sb.append('\n');
        sb.append("7. Create Product Version Feature").append('\n');
        sb.append("The 'Product Version Feature' describes the state of functionality included to the 'Product Version'. ");
        sb.append("It is used as a reference to formulate 'License Pack'.");
        sb.append('\n');
        sb.append('\n');
        sb.append("8. Create User Origin").append('\n');
        sb.append("The 'User Origin' provides access to 'User' descriptors. ");
        sb.append("The typical example of the 'User Origin' is the list of users registered on your web site to download 'Product Version'.");
        sb.append('\n');
        sb.append('\n');
        sb.append("9. Create User").append('\n');
        sb.append("The 'User' describes the licensee of your functionality. ");
        sb.append("The 'identifier' of the 'User' is a part of the 'License Pack' definition.");
        sb.append('\n');
        sb.append('\n');
        sb.append("10. Create License Pack").append('\n');
        sb.append("The 'License Pack' is a container for 'License Grant' descriptors. ");
        sb.append("It has references to the 'Product Version' that is licensed to 'User'. ");
        sb.append("The 'License Pack' is intended to be delivered to the 'User' environment to allow usage of restricted functionality.");
        return sb.toString();
    }
}

