/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.api.access.LicensingRequest;
import org.eclipse.passage.lic.emf.ecore.LicensingEcore;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.model.api.LicenseGrant;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;
import org.eclipse.passage.loc.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.DashboardUiMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class IssueLicensePackPage
extends WizardPage {
    private final IEclipseContext context;
    private LicensePack licensePack;
    private VViewModelProperties viewModelProperties;
    private Composite base;

    protected IssueLicensePackPage(String pageName, IEclipseContext context) {
        super(pageName);
        this.context = context;
        this.setTitle(DashboardUiMessages.IssueLicensePackPage_page_title);
        this.setDescription(DashboardUiMessages.IssueLicensePackPage_page_description);
    }

    public void init(LicensingRequest request) {
        if (this.licensePack != null) {
            this.licensePack.setPlanIdentifier(request.getPlanIdentifier());
            this.licensePack.setProductIdentifier(request.getProductIdentifier());
            this.licensePack.setProductVersion(request.getProductVersion());
            this.licensePack.setUserIdentifier(request.getUserIdentifier());
            EList licenseGrants = this.licensePack.getLicenseGrants();
            for (LicenseGrant licenseGrant : licenseGrants) {
                licenseGrant.setValidFrom(request.getValidFrom());
                licenseGrant.setValidUntil(request.getValidUntil());
            }
            return;
        }
        OperatorLicenseService operatorLicenseService = (OperatorLicenseService)this.context.get(OperatorLicenseService.class);
        LicensePackDescriptor licensePackDescriptor = operatorLicenseService.createLicensePack(request);
        if (licensePackDescriptor instanceof LicensePack) {
            this.licensePack = (LicensePack)licensePackDescriptor;
            this.licensePack.eAdapters().add((Object)new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    IssueLicensePackPage.this.setPageComplete(IssueLicensePackPage.this.validatePage());
                }
            });
        }
        this.updatePage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.setControl((Control)composite);
        this.base = new Composite(composite, 0);
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.base.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.viewModelProperties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        this.viewModelProperties.addInheritableProperty("useOnModifyDatabinding", (Object)"true");
        this.updatePage();
        Dialog.applyDialogFont((Control)composite);
    }

    private void updatePage() {
        if (this.base == null || this.base.isDisposed()) {
            this.setPageComplete(false);
            return;
        }
        if (this.licensePack != null) {
            try {
                ECPSWTViewRenderer.INSTANCE.render(this.base, (EObject)this.licensePack, this.viewModelProperties);
                this.base.layout();
            }
            catch (ECPRendererException e) {
                e.printStackTrace();
            }
        }
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        String errors = LicensingEcore.extractValidationError((EObject)this.licensePack);
        this.setErrorMessage(errors);
        return errors == null;
    }

    public LicensePackDescriptor getLicensePack() {
        return this.licensePack;
    }
}

