/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.floating;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.FloatingDataPack;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.ComposedPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.PageFields;
import org.eclipse.passage.loc.internal.api.FloatingLicenseRequest;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.core.request.FloatingLicenseData;

public final class IssueLicenseRequestPage
implements Supplier<IWizardPage> {
    private final Supplier<Optional<LicensePlan>> plan;
    private final Supplier<Optional<Collection<User>>> users;
    private final Supplier<Optional<ProductVersion>> product;
    private final Supplier<Optional<List<LocalDate>>> period;
    private final Supplier<Optional<Integer>> capacity;
    private final ComposedPage page;

    IssueLicenseRequestPage(IEclipseContext context, FloatingDataPack initial) {
        this.page = new ComposedPage(IssueLicenseRequestPage.class.getSimpleName(), IssueLicensePageMessages.IssueLicenseRequestPage_page_description, context);
        PageFields units = this.page.withBlock();
        this.plan = units.withLicensePlan(initial.plan());
        this.users = units.withUsers(initial.users());
        this.product = units.withProductVersion(initial.product());
        this.period = units.withPeriod();
        this.capacity = units.withDefaultCapacity();
    }

    @Override
    public IWizardPage get() {
        return this.page.get();
    }

    FloatingLicenseRequest request() {
        return new FloatingLicenseData(() -> this.users.get().get(), () -> this.plan.get().get(), () -> this.product.get().get(), () -> this.from(), () -> this.until(), () -> this.capacity.get().get());
    }

    private LocalDate from() {
        return this.period.get().get().get(0);
    }

    private LocalDate until() {
        return this.period.get().get().get(1);
    }
}

